/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedZoneStory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import zombie.SandboxOptions;
import zombie.core.Rand;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoDeadBody;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.randomizedWorld.RandomizedWorldBase;
import zombie.util.Type;

public class RandomizedZoneStoryBase
extends RandomizedWorldBase {
    public boolean alwaysDo = false;
    public static final int baseChance = 15;
    public static int totalChance = 0;
    public static final String zoneStory = "ZoneStory";
    public int chance = 0;
    protected int minZoneWidth = 0;
    protected int minZoneHeight = 0;
    public final ArrayList<String> zoneType = new ArrayList();
    private static final HashMap<RandomizedZoneStoryBase, Integer> rzsMap = new HashMap();

    public static boolean isValidForStory(IsoMetaGrid.Zone zone, boolean bl) {
        if (zone.pickedXForZoneStory > 0 && zone.pickedYForZoneStory > 0 && zone.pickedRZStory != null && RandomizedZoneStoryBase.checkCanSpawnStory(zone, bl)) {
            zone.pickedRZStory.randomizeZoneStory(zone);
            zone.pickedRZStory = null;
            zone.pickedXForZoneStory = 0;
            zone.pickedYForZoneStory = 0;
        }
        if (!bl && zone.hourLastSeen != 0) {
            return false;
        }
        if (!bl && zone.haveConstruction) {
            return false;
        }
        if (!zoneStory.equals(zone.type)) {
            return false;
        }
        RandomizedZoneStoryBase.doRandomStory(zone);
        return true;
    }

    public static void initAllRZSMapChance(IsoMetaGrid.Zone zone) {
        totalChance = 0;
        rzsMap.clear();
        for (int i = 0; i < IsoWorld.instance.getRandomizedZoneList().size(); ++i) {
            RandomizedZoneStoryBase randomizedZoneStoryBase = IsoWorld.instance.getRandomizedZoneList().get(i);
            if (!randomizedZoneStoryBase.isValid(zone, false) || !randomizedZoneStoryBase.isTimeValid(false)) continue;
            totalChance += randomizedZoneStoryBase.chance;
            rzsMap.put(randomizedZoneStoryBase, randomizedZoneStoryBase.chance);
        }
    }

    public boolean isValid(IsoMetaGrid.Zone zone, boolean bl) {
        boolean bl2 = false;
        for (int i = 0; i < this.zoneType.size(); ++i) {
            if (!this.zoneType.get(i).equals(zone.name)) continue;
            bl2 = true;
            break;
        }
        return bl2 && zone.w >= this.minZoneWidth && zone.h >= this.minZoneHeight;
    }

    private static boolean doRandomStory(IsoMetaGrid.Zone zone) {
        int n;
        ++zone.hourLastSeen;
        int n2 = 6;
        switch (SandboxOptions.instance.ZoneStoryChance.getValue()) {
            case 1: {
                return false;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 12;
                break;
            }
            case 5: {
                n2 = 20;
                break;
            }
            case 6: {
                n2 = 40;
            }
        }
        RandomizedZoneStoryBase randomizedZoneStoryBase = null;
        for (n = 0; n < IsoWorld.instance.getRandomizedZoneList().size(); ++n) {
            RandomizedZoneStoryBase randomizedZoneStoryBase2 = IsoWorld.instance.getRandomizedZoneList().get(n);
            if (!randomizedZoneStoryBase2.alwaysDo || !randomizedZoneStoryBase2.isValid(zone, false) || !randomizedZoneStoryBase2.isTimeValid(false)) continue;
            randomizedZoneStoryBase = randomizedZoneStoryBase2;
        }
        if (randomizedZoneStoryBase != null) {
            n = zone.x;
            int n3 = zone.y;
            int n4 = zone.x + zone.w - randomizedZoneStoryBase.minZoneWidth / 2;
            int n5 = zone.y + zone.h - randomizedZoneStoryBase.minZoneHeight / 2;
            zone.pickedXForZoneStory = Rand.Next(n, n4 + 1);
            zone.pickedYForZoneStory = Rand.Next(n3, n5 + 1);
            zone.pickedRZStory = randomizedZoneStoryBase;
            return true;
        }
        if (Rand.Next(100) < n2) {
            RandomizedZoneStoryBase.initAllRZSMapChance(zone);
            randomizedZoneStoryBase = RandomizedZoneStoryBase.getRandomStory();
            if (randomizedZoneStoryBase == null) {
                return false;
            }
            n = zone.x;
            int n6 = zone.y;
            int n7 = zone.x + zone.w - randomizedZoneStoryBase.minZoneWidth / 2;
            int n8 = zone.y + zone.h - randomizedZoneStoryBase.minZoneHeight / 2;
            zone.pickedXForZoneStory = Rand.Next(n, n7 + 1);
            zone.pickedYForZoneStory = Rand.Next(n6, n8 + 1);
            zone.pickedRZStory = randomizedZoneStoryBase;
            return true;
        }
        return false;
    }

    public IsoGridSquare getRandomFreeSquare(RandomizedZoneStoryBase randomizedZoneStoryBase, IsoMetaGrid.Zone zone) {
        IsoGridSquare isoGridSquare = null;
        for (int i = 0; i < 1000; ++i) {
            int n;
            int n2 = Rand.Next(zone.pickedXForZoneStory - randomizedZoneStoryBase.minZoneWidth / 2, zone.pickedXForZoneStory + randomizedZoneStoryBase.minZoneWidth / 2);
            isoGridSquare = this.getSq(n2, n = Rand.Next(zone.pickedYForZoneStory - randomizedZoneStoryBase.minZoneHeight / 2, zone.pickedYForZoneStory + randomizedZoneStoryBase.minZoneHeight / 2), zone.z);
            if (isoGridSquare == null || !isoGridSquare.isFree(false)) continue;
            return isoGridSquare;
        }
        return null;
    }

    public IsoGridSquare getRandomFreeSquareFullZone(RandomizedZoneStoryBase randomizedZoneStoryBase, IsoMetaGrid.Zone zone) {
        IsoGridSquare isoGridSquare = null;
        for (int i = 0; i < 1000; ++i) {
            int n;
            int n2 = Rand.Next(zone.x, zone.x + zone.w);
            isoGridSquare = this.getSq(n2, n = Rand.Next(zone.y, zone.y + zone.h), zone.z);
            if (isoGridSquare == null || !isoGridSquare.isFree(false)) continue;
            return isoGridSquare;
        }
        return null;
    }

    private static RandomizedZoneStoryBase getRandomStory() {
        int n = Rand.Next(totalChance);
        Iterator<RandomizedZoneStoryBase> iterator = rzsMap.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            RandomizedZoneStoryBase randomizedZoneStoryBase = iterator.next();
            if (n >= (n2 += rzsMap.get(randomizedZoneStoryBase).intValue())) continue;
            return randomizedZoneStoryBase;
        }
        return null;
    }

    private static boolean checkCanSpawnStory(IsoMetaGrid.Zone zone, boolean bl) {
        int n = zone.pickedXForZoneStory - zone.pickedRZStory.minZoneWidth / 2 - 2;
        int n2 = zone.pickedYForZoneStory - zone.pickedRZStory.minZoneHeight / 2 - 2;
        int n3 = zone.pickedXForZoneStory + zone.pickedRZStory.minZoneWidth / 2 + 2;
        int n4 = zone.pickedYForZoneStory + zone.pickedRZStory.minZoneHeight / 2 + 2;
        int n5 = n / 10;
        int n6 = n2 / 10;
        int n7 = n3 / 10;
        int n8 = n4 / 10;
        for (int i = n6; i <= n8; ++i) {
            for (int j = n5; j <= n7; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunk(j, i);
                if (isoChunk != null && isoChunk.bLoaded) continue;
                return false;
            }
        }
        return true;
    }

    public void randomizeZoneStory(IsoMetaGrid.Zone zone) {
    }

    public boolean isValid() {
        return true;
    }

    public void cleanAreaForStory(RandomizedZoneStoryBase randomizedZoneStoryBase, IsoMetaGrid.Zone zone) {
        int n = zone.pickedXForZoneStory - randomizedZoneStoryBase.minZoneWidth / 2 - 1;
        int n2 = zone.pickedYForZoneStory - randomizedZoneStoryBase.minZoneHeight / 2 - 1;
        int n3 = zone.pickedXForZoneStory + randomizedZoneStoryBase.minZoneWidth / 2 + 1;
        int n4 = zone.pickedYForZoneStory + randomizedZoneStoryBase.minZoneHeight / 2 + 1;
        for (int i = n; i < n3; ++i) {
            for (int j = n2; j < n4; ++j) {
                IsoObject isoObject;
                int n5;
                IsoGridSquare isoGridSquare = IsoWorld.instance.getCell().getGridSquare(i, j, zone.z);
                if (isoGridSquare == null) continue;
                isoGridSquare.removeBlood(false, false);
                for (n5 = isoGridSquare.getObjects().size() - 1; n5 >= 0; --n5) {
                    isoObject = isoGridSquare.getObjects().get(n5);
                    if (isoGridSquare.getFloor() == isoObject) continue;
                    isoGridSquare.RemoveTileObject(isoObject);
                }
                for (n5 = isoGridSquare.getSpecialObjects().size() - 1; n5 >= 0; --n5) {
                    isoObject = isoGridSquare.getSpecialObjects().get(n5);
                    isoGridSquare.RemoveTileObject(isoObject);
                }
                for (n5 = isoGridSquare.getStaticMovingObjects().size() - 1; n5 >= 0; --n5) {
                    isoObject = Type.tryCastTo(isoGridSquare.getStaticMovingObjects().get(n5), IsoDeadBody.class);
                    if (isoObject == null) continue;
                    isoGridSquare.removeCorpse((IsoDeadBody)isoObject, false);
                }
                isoGridSquare.RecalcProperties();
                isoGridSquare.RecalcAllWithNeighbours(true);
            }
        }
    }

    public int getMinimumWidth() {
        return this.minZoneWidth;
    }

    public int getMinimumHeight() {
        return this.minZoneHeight;
    }

    public static enum ZoneType {
        Forest,
        Beach,
        Lake,
        Baseball,
        MusicFestStage,
        MusicFest,
        NewsStory;

    }
}

