/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedZoneStory;

import java.util.ArrayList;
import zombie.characters.IsoZombie;
import zombie.core.Rand;
import zombie.iso.IsoMetaGrid;
import zombie.iso.objects.IsoDeadBody;
import zombie.randomizedWorld.randomizedZoneStory.RandomizedZoneStoryBase;

public class RZSBuryingCamp
extends RandomizedZoneStoryBase {
    public RZSBuryingCamp() {
        this.name = "Burying Camp";
        this.chance = 7;
        this.minZoneHeight = 6;
        this.minZoneWidth = 6;
        this.minimumDays = 20;
        this.zoneType.add(RandomizedZoneStoryBase.ZoneType.Forest.toString());
    }

    @Override
    public void randomizeZoneStory(IsoMetaGrid.Zone zone) {
        this.cleanAreaForStory(this, zone);
        boolean bl = Rand.NextBool(2);
        int n = zone.x + 1;
        int n2 = zone.y + 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = Rand.Next(3, 7);
        for (int i = 0; i < n5; ++i) {
            if (bl) {
                this.addTileObject(n + i, zone.y + 2, zone.z, "location_community_cemetary_01_22");
                if (i == 2) {
                    this.addTileObject(n + i, zone.y + 3, zone.z, "location_community_cemetary_01_35");
                    this.addTileObject(n + i, zone.y + 4, zone.z, "location_community_cemetary_01_34");
                    n3 = n + i;
                    n4 = zone.y + 5;
                    continue;
                }
                this.addTileObject(n + i, zone.y + 3, zone.z, "location_community_cemetary_01_43");
                this.addTileObject(n + i, zone.y + 4, zone.z, "location_community_cemetary_01_42");
                if (!Rand.NextBool(2)) continue;
                this.addTileObject(n + i, zone.y + 6, zone.z, "vegetation_ornamental_01_" + Rand.Next(16, 19));
                continue;
            }
            this.addTileObject(zone.x + 2, n2 + i, zone.z, "location_community_cemetary_01_23");
            if (i == 2) {
                this.addTileObject(zone.x + 3, n2 + i, zone.z, "location_community_cemetary_01_32");
                this.addTileObject(zone.x + 4, n2 + i, zone.z, "location_community_cemetary_01_33");
                n3 = zone.x + 5;
                n4 = n2 + i;
                continue;
            }
            this.addTileObject(zone.x + 3, n2 + i, zone.z, "location_community_cemetary_01_40");
            this.addTileObject(zone.x + 4, n2 + i, zone.z, "location_community_cemetary_01_41");
            if (!Rand.NextBool(2)) continue;
            this.addTileObject(zone.x + 6, n2 + i, zone.z, "vegetation_ornamental_01_" + Rand.Next(16, 19));
        }
        this.addItemOnGround(this.getSq(n3 + 1, n4 + 1, zone.z), "Base.Shovel");
        ArrayList<IsoZombie> arrayList = this.addZombiesOnSquare(1, null, null, this.getRandomFreeSquare(this, zone));
        if (arrayList != null && !arrayList.isEmpty()) {
            IsoZombie isoZombie = arrayList.get(0);
            IsoDeadBody isoDeadBody = RZSBuryingCamp.createRandomDeadBody(this.getSq(n3, n4, zone.z), null, Rand.Next(7, 12), 0, null);
            if (isoDeadBody != null) {
                this.addBloodSplat(isoDeadBody.getSquare(), 10);
                isoZombie.faceLocationF(isoDeadBody.x, isoDeadBody.y);
                isoZombie.setX(isoDeadBody.x + 1.0f);
                isoZombie.setY(isoDeadBody.y);
                isoZombie.setEatBodyTarget(isoDeadBody, true);
            }
        }
        this.addItemOnGround(this.getRandomFreeSquare(this, zone), "Base.WhiskeyEmpty");
        this.addItemOnGround(this.getRandomFreeSquare(this, zone), "Base.WineEmpty");
    }
}

