/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import zombie.core.math.PZMath;
import zombie.debug.LineDrawer;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.Vector2;
import zombie.popman.ObjectPool;
import zombie.util.Type;

public class VehicleStorySpawner {
    private static final VehicleStorySpawner instance = new VehicleStorySpawner();
    private static final Vector2 s_vector2_1 = new Vector2();
    private static final Vector2 s_vector2_2 = new Vector2();
    private static final ObjectPool<Element> s_elementPool = new ObjectPool<Element>(Element::new);
    private static final int[] s_AABB = new int[4];
    public final ArrayList<Element> m_elements = new ArrayList();
    public final HashMap<String, Object> m_storyParams = new HashMap();

    public static VehicleStorySpawner getInstance() {
        return instance;
    }

    public void clear() {
        s_elementPool.release((List<Element>)this.m_elements);
        this.m_elements.clear();
        this.m_storyParams.clear();
    }

    public Element addElement(String string, float f, float f2, float f3, float f4, float f5) {
        Element element = s_elementPool.alloc().init(string, f, f2, f3, f4, f5);
        this.m_elements.add(element);
        return element;
    }

    public void setParameter(String string, boolean bl) {
        this.m_storyParams.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setParameter(String string, float f) {
        this.m_storyParams.put(string, Float.valueOf(f));
    }

    public void setParameter(String string, int n) {
        this.m_storyParams.put(string, n);
    }

    public void setParameter(String string, Object object) {
        this.m_storyParams.put(string, object);
    }

    public boolean getParameterBoolean(String string) {
        return this.getParameter(string, Boolean.class);
    }

    public float getParameterFloat(String string) {
        return this.getParameter(string, Float.class).floatValue();
    }

    public int getParameterInteger(String string) {
        return this.getParameter(string, Integer.class);
    }

    public String getParameterString(String string) {
        return this.getParameter(string, String.class);
    }

    public <E> E getParameter(String string, Class<E> clazz) {
        return Type.tryCastTo(this.m_storyParams.get(string), clazz);
    }

    public void spawn(float f, float f2, float f3, float f4, IElementSpawner iElementSpawner) {
        for (int i = 0; i < this.m_elements.size(); ++i) {
            Element element = this.m_elements.get(i);
            Vector2 vector22 = s_vector2_1.setLengthAndDirection(element.direction, 1.0f);
            vector22.add(element.position);
            this.rotate(f, f2, vector22, f4);
            this.rotate(f, f2, element.position, f4);
            element.direction = Vector2.getDirection(vector22.x - element.position.x, vector22.y - element.position.y);
            element.z = f3;
            element.square = IsoWorld.instance.CurrentCell.getGridSquare(element.position.x, element.position.y, f3);
            iElementSpawner.spawn(this, element);
        }
    }

    public Vector2 rotate(float f, float f2, Vector2 vector22, float f3) {
        float f4 = vector22.x;
        float f5 = vector22.y;
        vector22.x = f + (float)((double)f4 * Math.cos(f3) - (double)f5 * Math.sin(f3));
        vector22.y = f2 + (float)((double)f4 * Math.sin(f3) + (double)f5 * Math.cos(f3));
        return vector22;
    }

    public void getAABB(float f, float f2, float f3, float f4, float f5, int[] nArray) {
        Vector2 vector22 = s_vector2_1.setLengthAndDirection(f5, 1.0f);
        Vector2 vector23 = s_vector2_2.set(vector22);
        vector23.tangent();
        vector22.x *= f4 / 2.0f;
        vector22.y *= f4 / 2.0f;
        vector23.x *= f3 / 2.0f;
        vector23.y *= f3 / 2.0f;
        float f6 = f + vector22.x;
        float f7 = f2 + vector22.y;
        float f8 = f - vector22.x;
        float f9 = f2 - vector22.y;
        float f10 = f6 - vector23.x;
        float f11 = f7 - vector23.y;
        float f12 = f6 + vector23.x;
        float f13 = f7 + vector23.y;
        float f14 = f8 - vector23.x;
        float f15 = f9 - vector23.y;
        float f16 = f8 + vector23.x;
        float f17 = f9 + vector23.y;
        float f18 = PZMath.min(f10, PZMath.min(f12, PZMath.min(f14, f16)));
        float f19 = PZMath.max(f10, PZMath.max(f12, PZMath.max(f14, f16)));
        float f20 = PZMath.min(f11, PZMath.min(f13, PZMath.min(f15, f17)));
        float f21 = PZMath.max(f11, PZMath.max(f13, PZMath.max(f15, f17)));
        nArray[0] = (int)PZMath.floor(f18);
        nArray[1] = (int)PZMath.floor(f20);
        nArray[2] = (int)PZMath.ceil(f19);
        nArray[3] = (int)PZMath.ceil(f21);
    }

    public void render(float f, float f2, float f3, float f4, float f5, float f6) {
        LineDrawer.DrawIsoRectRotated(f, f2, f3, f4, f5, f6, 0.0f, 0.0f, 1.0f, 1.0f);
        float f7 = 1.0f;
        float f8 = 1.0f;
        float f9 = 1.0f;
        float f10 = 1.0f;
        float f11 = Float.MAX_VALUE;
        float f12 = Float.MAX_VALUE;
        float f13 = -3.4028235E38f;
        float f14 = -3.4028235E38f;
        for (Element element : this.m_elements) {
            Vector2 vector22 = s_vector2_1.setLengthAndDirection(element.direction, 1.0f);
            LineDrawer.DrawIsoLine(element.position.x, element.position.y, f3, element.position.x + vector22.x, element.position.y + vector22.y, f3, f7, f8, f9, f10, 1);
            LineDrawer.DrawIsoRectRotated(element.position.x, element.position.y, f3, element.width, element.height, element.direction, f7, f8, f9, f10);
            this.getAABB(element.position.x, element.position.y, element.width, element.height, element.direction, s_AABB);
            f11 = PZMath.min(f11, (float)s_AABB[0]);
            f12 = PZMath.min(f12, (float)s_AABB[1]);
            f13 = PZMath.max(f13, (float)s_AABB[2]);
            f14 = PZMath.max(f14, (float)s_AABB[3]);
        }
    }

    public static final class Element {
        String id;
        final Vector2 position = new Vector2();
        float direction;
        float width;
        float height;
        float z;
        IsoGridSquare square;

        Element init(String string, float f, float f2, float f3, float f4, float f5) {
            this.id = string;
            this.position.set(f, f2);
            this.direction = f3;
            this.width = f4;
            this.height = f5;
            this.z = 0.0f;
            this.square = null;
            return this;
        }
    }

    public static interface IElementSpawner {
        public void spawn(VehicleStorySpawner var1, Element var2);
    }
}

