/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import java.util.ArrayList;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.Vector2;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;

public final class RVSUtilityVehicle
extends RandomizedVehicleStoryBase {
    private ArrayList<String> tools = null;
    private ArrayList<String> carpenterTools = null;
    private Params params = new Params();

    public RVSUtilityVehicle() {
        this.name = "Utility Vehicle";
        this.minZoneWidth = 8;
        this.minZoneHeight = 9;
        this.setChance(7);
        this.tools = new ArrayList();
        this.tools.add("Base.PickAxe");
        this.tools.add("Base.Shovel");
        this.tools.add("Base.Shovel2");
        this.tools.add("Base.Hammer");
        this.tools.add("Base.LeadPipe");
        this.tools.add("Base.PipeWrench");
        this.tools.add("Base.Sledgehammer");
        this.tools.add("Base.Sledgehammer2");
        this.carpenterTools = new ArrayList();
        this.carpenterTools.add("Base.Hammer");
        this.carpenterTools.add("Base.NailsBox");
        this.carpenterTools.add("Base.Plank");
        this.carpenterTools.add("Base.Plank");
        this.carpenterTools.add("Base.Plank");
        this.carpenterTools.add("Base.Screwdriver");
        this.carpenterTools.add("Base.Saw");
        this.carpenterTools.add("Base.Saw");
        this.carpenterTools.add("Base.Woodglue");
    }

    @Override
    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        this.callVehicleStorySpawner(zone, isoChunk, 0.0f);
    }

    public void doUtilityVehicle(IsoMetaGrid.Zone zone, IsoChunk isoChunk, String string, String string2, String string3, Integer n, String string4, ArrayList<String> arrayList, int n2, boolean bl) {
        this.params.zoneName = string;
        this.params.scriptName = string2;
        this.params.outfits = string3;
        this.params.femaleChance = n;
        this.params.vehicleDistrib = string4;
        this.params.items = arrayList;
        this.params.nbrOfItem = n2;
        this.params.addTrailer = bl;
    }

    @Override
    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        int n;
        int n2 = Rand.Next(0, 7);
        switch (n2) {
            case 0: {
                this.doUtilityVehicle(zone, isoChunk, null, "Base.PickUpTruck", "ConstructionWorker", 0, "ConstructionWorker", this.tools, Rand.Next(0, 3), true);
                break;
            }
            case 1: {
                this.doUtilityVehicle(zone, isoChunk, "police", null, "Police", null, null, null, 0, false);
                break;
            }
            case 2: {
                this.doUtilityVehicle(zone, isoChunk, "fire", null, "Fireman", null, null, null, 0, false);
                break;
            }
            case 3: {
                this.doUtilityVehicle(zone, isoChunk, "ranger", null, "Ranger", null, null, null, 0, true);
                break;
            }
            case 4: {
                this.doUtilityVehicle(zone, isoChunk, "mccoy", null, "McCoys", 0, "Carpenter", this.carpenterTools, Rand.Next(2, 6), true);
                break;
            }
            case 5: {
                this.doUtilityVehicle(zone, isoChunk, "postal", null, "Postal", null, null, null, 0, false);
                break;
            }
            case 6: {
                this.doUtilityVehicle(zone, isoChunk, "fossoil", null, "Fossoil", null, null, null, 0, false);
            }
        }
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        vehicleStorySpawner.clear();
        Vector2 vector22 = IsoDirections.N.ToVector();
        float f = 0.5235988f;
        if (bl) {
            f = 0.0f;
        }
        vector22.rotate(Rand.Next(-f, f));
        float f2 = -2.0f;
        int n3 = 5;
        vehicleStorySpawner.addElement("vehicle1", 0.0f, f2, vector22.getDirection(), 2.0f, n3);
        if (this.params.addTrailer && Rand.NextBool(7)) {
            n = 3;
            vehicleStorySpawner.addElement("trailer", 0.0f, f2 + (float)n3 / 2.0f + 1.0f + (float)n / 2.0f, vector22.getDirection(), 2.0f, n);
        }
        if (this.params.items != null) {
            for (n = 0; n < this.params.nbrOfItem; ++n) {
                vehicleStorySpawner.addElement("tool", Rand.Next(-3.5f, 3.5f), Rand.Next(-3.5f, 3.5f), 0.0f, 1.0f, 1.0f);
            }
        }
        vehicleStorySpawner.setParameter("zone", zone);
        return true;
    }

    @Override
    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
        IsoGridSquare isoGridSquare = element.square;
        if (isoGridSquare == null) {
            return;
        }
        float f = element.z;
        IsoMetaGrid.Zone zone = vehicleStorySpawner.getParameter("zone", IsoMetaGrid.Zone.class);
        BaseVehicle baseVehicle = vehicleStorySpawner.getParameter("vehicle1", BaseVehicle.class);
        switch (element.id) {
            case "tool": {
                if (baseVehicle == null) break;
                float f2 = PZMath.max(element.position.x - (float)isoGridSquare.x, 0.001f);
                float f3 = PZMath.max(element.position.y - (float)isoGridSquare.y, 0.001f);
                float f4 = 0.0f;
                isoGridSquare.AddWorldInventoryItem(PZArrayUtil.pickRandom(this.params.items), f2, f3, f4);
                break;
            }
            case "trailer": {
                if (baseVehicle == null) break;
                this.addTrailer(baseVehicle, zone, isoGridSquare.getChunk(), this.params.zoneName, this.params.vehicleDistrib, Rand.NextBool(1) ? "Base.Trailer" : "Base.TrailerCover");
                break;
            }
            case "vehicle1": {
                baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f, element.direction, this.params.zoneName, this.params.scriptName, null, this.params.vehicleDistrib);
                if (baseVehicle == null) break;
                this.addZombiesOnVehicle(Rand.Next(2, 5), this.params.outfits, this.params.femaleChance, baseVehicle);
            }
        }
    }

    private static final class Params {
        String zoneName;
        String scriptName;
        String outfits;
        Integer femaleChance;
        String vehicleDistrib;
        ArrayList<String> items;
        int nbrOfItem;
        boolean addTrailer;

        private Params() {
        }
    }
}

