/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import java.util.ArrayList;
import zombie.characters.IsoZombie;
import zombie.core.Rand;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoDeadBody;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.vehicles.BaseVehicle;

public final class RVSCrashHorde
extends RandomizedVehicleStoryBase {
    public RVSCrashHorde() {
        this.name = "Crash Horde";
        this.minZoneWidth = 8;
        this.minZoneHeight = 8;
        this.setChance(1);
        this.setMinimumDays(60);
    }

    @Override
    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        this.callVehicleStorySpawner(zone, isoChunk, 0.0f);
    }

    @Override
    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        vehicleStorySpawner.clear();
        float f = 0.5235988f;
        if (bl) {
            f = 0.0f;
        }
        Vector2 vector22 = IsoDirections.N.ToVector();
        vector22.rotate(Rand.Next(-f, f));
        vehicleStorySpawner.addElement("vehicle1", 0.0f, 0.0f, vector22.getDirection(), 2.0f, 5.0f);
        vehicleStorySpawner.setParameter("zone", zone);
        vehicleStorySpawner.setParameter("burnt", Rand.NextBool(5));
        return true;
    }

    @Override
    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
        IsoGridSquare isoGridSquare = element.square;
        if (isoGridSquare == null) {
            return;
        }
        float f = element.z;
        IsoMetaGrid.Zone zone = vehicleStorySpawner.getParameter("zone", IsoMetaGrid.Zone.class);
        boolean bl = vehicleStorySpawner.getParameterBoolean("burnt");
        switch (element.id) {
            case "vehicle1": {
                BaseVehicle baseVehicle = this.addVehicleFlipped(zone, element.position.x, element.position.y, f + 0.25f, element.direction, bl ? "normalburnt" : "bad", null, null, null);
                if (baseVehicle == null) break;
                int n = Rand.Next(4);
                String string = null;
                switch (n) {
                    case 0: {
                        string = "Front";
                        break;
                    }
                    case 1: {
                        string = "Rear";
                        break;
                    }
                    case 2: {
                        string = "Left";
                        break;
                    }
                    case 3: {
                        string = "Right";
                    }
                }
                baseVehicle = baseVehicle.setSmashed(string);
                baseVehicle.setBloodIntensity("Front", Rand.Next(0.7f, 1.0f));
                baseVehicle.setBloodIntensity("Rear", Rand.Next(0.7f, 1.0f));
                baseVehicle.setBloodIntensity("Left", Rand.Next(0.7f, 1.0f));
                baseVehicle.setBloodIntensity("Right", Rand.Next(0.7f, 1.0f));
                ArrayList<IsoZombie> arrayList = this.addZombiesOnVehicle(Rand.Next(2, 4), null, null, baseVehicle);
                if (arrayList == null) break;
                for (int i = 0; i < arrayList.size(); ++i) {
                    IsoZombie isoZombie = arrayList.get(i);
                    isoZombie.upKillCount = false;
                    this.addBloodSplat(isoZombie.getSquare(), Rand.Next(10, 20));
                    if (bl) {
                        isoZombie.setSkeleton(true);
                        isoZombie.getHumanVisual().setSkinTextureIndex(0);
                    } else {
                        isoZombie.DoCorpseInventory();
                        if (Rand.NextBool(10)) {
                            isoZombie.setFakeDead(true);
                            isoZombie.bCrawling = true;
                            isoZombie.setCanWalk(false);
                            isoZombie.setCrawlerType(1);
                        }
                    }
                    new IsoDeadBody(isoZombie, false);
                }
                this.addZombiesOnVehicle(Rand.Next(12, 20), null, null, baseVehicle);
                break;
            }
        }
    }
}

