/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.inventory.InventoryItem;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.Vector2;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehiclePart;

public final class RVSChangingTire
extends RandomizedVehicleStoryBase {
    public RVSChangingTire() {
        this.name = "Changing Tire";
        this.minZoneWidth = 5;
        this.minZoneHeight = 5;
        this.setChance(3);
    }

    @Override
    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        float f = 0.5235988f;
        this.callVehicleStorySpawner(zone, isoChunk, Rand.Next(-f, f));
    }

    @Override
    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        vehicleStorySpawner.clear();
        boolean bl2 = Rand.NextBool(2);
        if (bl) {
            bl2 = true;
        }
        int n = bl2 ? 1 : -1;
        Vector2 vector22 = IsoDirections.N.ToVector();
        vehicleStorySpawner.addElement("vehicle1", (float)n * -1.5f, 0.0f, vector22.getDirection(), 2.0f, 5.0f);
        vehicleStorySpawner.addElement("tire1", (float)n * 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        vehicleStorySpawner.addElement("tool1", (float)n * 0.8f, -0.2f, 0.0f, 1.0f, 1.0f);
        vehicleStorySpawner.addElement("tool2", (float)n * 1.2f, 0.2f, 0.0f, 1.0f, 1.0f);
        vehicleStorySpawner.addElement("tire2", (float)n * 2.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        vehicleStorySpawner.setParameter("zone", zone);
        vehicleStorySpawner.setParameter("removeRightWheel", bl2);
        return true;
    }

    @Override
    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
        IsoGridSquare isoGridSquare = element.square;
        if (isoGridSquare == null) {
            return;
        }
        float f = PZMath.max(element.position.x - (float)isoGridSquare.x, 0.001f);
        float f2 = PZMath.max(element.position.y - (float)isoGridSquare.y, 0.001f);
        float f3 = 0.0f;
        float f4 = element.z;
        IsoMetaGrid.Zone zone = vehicleStorySpawner.getParameter("zone", IsoMetaGrid.Zone.class);
        boolean bl = vehicleStorySpawner.getParameterBoolean("removeRightWheel");
        BaseVehicle baseVehicle = vehicleStorySpawner.getParameter("vehicle1", BaseVehicle.class);
        switch (element.id) {
            case "tire1": {
                if (baseVehicle == null) break;
                InventoryItem inventoryItem = isoGridSquare.AddWorldInventoryItem("Base.ModernTire" + baseVehicle.getScript().getMechanicType(), f, f2, f3);
                if (inventoryItem != null) {
                    inventoryItem.setItemCapacity(inventoryItem.getMaxCapacity());
                }
                this.addBloodSplat(isoGridSquare, Rand.Next(10, 20));
                break;
            }
            case "tire2": {
                InventoryItem inventoryItem;
                if (baseVehicle == null || (inventoryItem = isoGridSquare.AddWorldInventoryItem("Base.OldTire" + baseVehicle.getScript().getMechanicType(), f, f2, f3)) == null) break;
                inventoryItem.setCondition(0);
                break;
            }
            case "tool1": {
                isoGridSquare.AddWorldInventoryItem("Base.LugWrench", f, f2, f3);
                break;
            }
            case "tool2": {
                isoGridSquare.AddWorldInventoryItem("Base.Jack", f, f2, f3);
                break;
            }
            case "vehicle1": {
                baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f4, element.direction, "good", null, null, null);
                if (baseVehicle == null) break;
                baseVehicle.setGeneralPartCondition(0.7f, 40.0f);
                baseVehicle.setRust(0.0f);
                VehiclePart vehiclePart = baseVehicle.getPartById(bl ? "TireRearRight" : "TireRearLeft");
                baseVehicle.setTireRemoved(vehiclePart.getWheelIndex(), true);
                vehiclePart.setModelVisible("InflatedTirePlusWheel", false);
                vehiclePart.setInventoryItem(null);
                this.addZombiesOnVehicle(2, null, null, baseVehicle);
                vehicleStorySpawner.setParameter("vehicle1", baseVehicle);
                break;
            }
        }
    }
}

