/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import zombie.core.Rand;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.Vector2;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.vehicles.BaseVehicle;

public final class RVSCarCrash
extends RandomizedVehicleStoryBase {
    public RVSCarCrash() {
        this.name = "Basic Car Crash";
        this.minZoneWidth = 5;
        this.minZoneHeight = 7;
        this.setChance(25);
    }

    @Override
    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        this.callVehicleStorySpawner(zone, isoChunk, 0.0f);
    }

    @Override
    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        vehicleStorySpawner.clear();
        float f = 0.5235988f;
        if (bl) {
            f = 0.0f;
        }
        Vector2 vector22 = IsoDirections.N.ToVector();
        vector22.rotate(Rand.Next(-f, f));
        vehicleStorySpawner.addElement("vehicle1", 0.0f, 1.0f, vector22.getDirection(), 2.0f, 5.0f);
        boolean bl2 = Rand.NextBool(2);
        vector22 = bl2 ? IsoDirections.E.ToVector() : IsoDirections.W.ToVector();
        vector22.rotate(Rand.Next(-f, f));
        vehicleStorySpawner.addElement("vehicle2", 0.0f, -2.5f, vector22.getDirection(), 2.0f, 5.0f);
        vehicleStorySpawner.setParameter("zone", zone);
        vehicleStorySpawner.setParameter("smashed", Rand.NextBool(3));
        vehicleStorySpawner.setParameter("east", bl2);
        return true;
    }

    @Override
    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
        IsoGridSquare isoGridSquare = element.square;
        if (isoGridSquare == null) {
            return;
        }
        float f = element.z;
        IsoMetaGrid.Zone zone = vehicleStorySpawner.getParameter("zone", IsoMetaGrid.Zone.class);
        boolean bl = vehicleStorySpawner.getParameterBoolean("smashed");
        boolean bl2 = vehicleStorySpawner.getParameterBoolean("east");
        switch (element.id) {
            case "vehicle1": 
            case "vehicle2": {
                BaseVehicle baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f, element.direction, "bad", null, null, null);
                if (baseVehicle == null) break;
                if (bl) {
                    String string = "Front";
                    if ("vehicle2".equals(element.id)) {
                        string = bl2 ? "Right" : "Left";
                    }
                    baseVehicle = baseVehicle.setSmashed(string);
                    baseVehicle.setBloodIntensity(string, 1.0f);
                }
                if (!"vehicle1".equals(element.id) || Rand.Next(10) >= 4) break;
                this.addZombiesOnVehicle(Rand.Next(2, 5), null, null, baseVehicle);
            }
        }
    }
}

