/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedDeadSurvivor;

import zombie.VirtualZombieManager;
import zombie.ZombieSpawnRecorder;
import zombie.characters.IsoZombie;
import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.areas.IsoRoom;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.interfaces.BarricadeAble;
import zombie.network.GameServer;
import zombie.randomizedWorld.randomizedDeadSurvivor.RandomizedDeadSurvivorBase;

public final class RDSZombieLockedBathroom
extends RandomizedDeadSurvivorBase {
    @Override
    public void randomizeDeadSurvivor(BuildingDef buildingDef) {
        IsoDeadBody isoDeadBody = null;
        for (int i = 0; i < buildingDef.rooms.size(); ++i) {
            IsoObject isoObject;
            IsoRoom isoRoom;
            IsoGridSquare isoGridSquare;
            RoomDef roomDef = buildingDef.rooms.get(i);
            IsoGridSquare isoGridSquare2 = null;
            if (!"bathroom".equals(roomDef.name)) continue;
            if (IsoWorld.getZombiesEnabled() && (isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(roomDef.getX(), roomDef.getY(), roomDef.getZ())) != null && isoGridSquare.getRoom() != null && (isoGridSquare = (isoRoom = isoGridSquare.getRoom()).getRandomFreeSquare()) != null) {
                VirtualZombieManager.instance.choices.clear();
                VirtualZombieManager.instance.choices.add(isoGridSquare);
                isoObject = VirtualZombieManager.instance.createRealZombieAlways(IsoDirections.fromIndex(Rand.Next(8)).index(), false);
                ZombieSpawnRecorder.instance.record((IsoZombie)isoObject, this.getClass().getSimpleName());
            }
            for (int j = roomDef.x - 1; j < roomDef.x2 + 1; ++j) {
                for (int k = roomDef.y - 1; k < roomDef.y2 + 1; ++k) {
                    IsoBarricade isoBarricade;
                    isoGridSquare2 = IsoWorld.instance.getCell().getGridSquare(j, k, roomDef.getZ());
                    if (isoGridSquare2 == null || (isoObject = isoGridSquare2.getIsoDoor()) == null || !this.isDoorToRoom((IsoDoor)isoObject, roomDef)) continue;
                    if (((IsoDoor)isoObject).IsOpen()) {
                        ((IsoDoor)isoObject).ToggleDoor(null);
                    }
                    if ((isoBarricade = IsoBarricade.AddBarricadeToObject((BarricadeAble)((Object)isoObject), isoGridSquare2.getRoom().def == roomDef)) != null) {
                        isoBarricade.addPlank(null, null);
                        if (GameServer.bServer) {
                            isoBarricade.transmitCompleteItemToClients();
                        }
                    }
                    isoDeadBody = this.addDeadBodyTheOtherSide((IsoDoor)isoObject);
                    break;
                }
                if (isoDeadBody != null) break;
            }
            if (isoDeadBody != null) {
                isoDeadBody.setPrimaryHandItem(super.addWeapon("Base.Pistol", true));
            }
            return;
        }
    }

    private boolean isDoorToRoom(IsoDoor isoDoor, RoomDef roomDef) {
        if (isoDoor == null || roomDef == null) {
            return false;
        }
        IsoGridSquare isoGridSquare = isoDoor.getSquare();
        IsoGridSquare isoGridSquare2 = isoDoor.getOppositeSquare();
        if (isoGridSquare == null || isoGridSquare2 == null) {
            return false;
        }
        return isoGridSquare.getRoomID() == roomDef.ID != (isoGridSquare2.getRoomID() == roomDef.ID);
    }

    private boolean checkIsBathroom(IsoGridSquare isoGridSquare) {
        return isoGridSquare.getRoom() != null && "bathroom".equals(isoGridSquare.getRoom().getName());
    }

    private IsoDeadBody addDeadBodyTheOtherSide(IsoDoor isoDoor) {
        IsoGridSquare isoGridSquare = null;
        if (isoDoor.north) {
            isoGridSquare = IsoWorld.instance.getCell().getGridSquare(isoDoor.getX(), isoDoor.getY(), isoDoor.getZ());
            if (this.checkIsBathroom(isoGridSquare)) {
                isoGridSquare = IsoWorld.instance.getCell().getGridSquare(isoDoor.getX(), isoDoor.getY() - 1.0f, isoDoor.getZ());
            }
        } else {
            isoGridSquare = IsoWorld.instance.getCell().getGridSquare(isoDoor.getX(), isoDoor.getY(), isoDoor.getZ());
            if (this.checkIsBathroom(isoGridSquare)) {
                isoGridSquare = IsoWorld.instance.getCell().getGridSquare(isoDoor.getX() - 1.0f, isoDoor.getY(), isoDoor.getZ());
            }
        }
        return RandomizedDeadSurvivorBase.createRandomDeadBody(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ(), null, Rand.Next(5, 10));
    }

    public RDSZombieLockedBathroom() {
        this.name = "Locked in Bathroom";
        this.setChance(5);
    }
}

