/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedDeadSurvivor;

import java.util.ArrayList;
import zombie.characters.IsoPlayer;
import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.RoomDef;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.randomizedWorld.randomizedDeadSurvivor.RandomizedDeadSurvivorBase;

public final class RDSStagDo
extends RandomizedDeadSurvivorBase {
    private final ArrayList<String> items = new ArrayList();
    private final ArrayList<String> otherItems = new ArrayList();

    public RDSStagDo() {
        this.name = "Stag Do";
        this.setChance(2);
        this.setMaximumDays(60);
        this.otherItems.add("Base.Cigarettes");
        this.otherItems.add("Base.WhiskeyFull");
        this.otherItems.add("Base.Wine");
        this.otherItems.add("Base.Wine2");
        this.items.add("Base.Crisps");
        this.items.add("Base.Crisps2");
        this.items.add("Base.Crisps3");
        this.items.add("Base.Pop");
        this.items.add("Base.Pop2");
        this.items.add("Base.Pop3");
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        this.debugLine = "";
        if (GameClient.bClient) {
            return false;
        }
        if (buildingDef.isAllExplored() && !bl) {
            return false;
        }
        if (!bl) {
            for (int i = 0; i < GameServer.Players.size(); ++i) {
                IsoPlayer isoPlayer = GameServer.Players.get(i);
                if (isoPlayer.getSquare() == null || isoPlayer.getSquare().getBuilding() == null || isoPlayer.getSquare().getBuilding().def != buildingDef) continue;
                return false;
            }
        }
        if (this.getRoom(buildingDef, "livingroom") != null) {
            return true;
        }
        this.debugLine = "No living room";
        return false;
    }

    @Override
    public void randomizeDeadSurvivor(BuildingDef buildingDef) {
        RoomDef roomDef = this.getRoom(buildingDef, "livingroom");
        this.addZombies(buildingDef, Rand.Next(5, 7), null, 0, roomDef);
        this.addZombies(buildingDef, 1, "NakedVeil", 100, roomDef);
        this.addRandomItemsOnGround(roomDef, this.items, Rand.Next(3, 7));
        this.addRandomItemsOnGround(roomDef, this.otherItems, Rand.Next(2, 6));
        buildingDef.bAlarmed = false;
    }
}

