/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedDeadSurvivor;

import java.util.ArrayList;
import zombie.characters.IsoPlayer;
import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.RoomDef;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.randomizedWorld.randomizedDeadSurvivor.RandomizedDeadSurvivorBase;

public final class RDSHouseParty
extends RandomizedDeadSurvivorBase {
    final ArrayList<String> items = new ArrayList();

    public RDSHouseParty() {
        this.name = "House Party";
        this.setChance(4);
        this.items.add("Base.Crisps");
        this.items.add("Base.Crisps2");
        this.items.add("Base.Crisps3");
        this.items.add("Base.Pop");
        this.items.add("Base.Pop2");
        this.items.add("Base.Pop3");
        this.items.add("Base.Cupcake");
        this.items.add("Base.Cupcake");
        this.items.add("Base.CakeSlice");
        this.items.add("Base.CakeSlice");
        this.items.add("Base.CakeSlice");
        this.items.add("Base.CakeSlice");
        this.items.add("Base.CakeSlice");
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        this.debugLine = "";
        if (GameClient.bClient) {
            return false;
        }
        if (buildingDef.isAllExplored() && !bl) {
            return false;
        }
        if (!bl) {
            for (int i = 0; i < GameServer.Players.size(); ++i) {
                IsoPlayer isoPlayer = GameServer.Players.get(i);
                if (isoPlayer.getSquare() == null || isoPlayer.getSquare().getBuilding() == null || isoPlayer.getSquare().getBuilding().def != buildingDef) continue;
                return false;
            }
        }
        if (this.getRoom(buildingDef, "livingroom") != null) {
            return true;
        }
        this.debugLine = "No living room";
        return false;
    }

    @Override
    public void randomizeDeadSurvivor(BuildingDef buildingDef) {
        RoomDef roomDef = this.getRoom(buildingDef, "livingroom");
        this.addZombies(buildingDef, Rand.Next(5, 8), "Party", null, roomDef);
        this.addRandomItemsOnGround(roomDef, this.items, Rand.Next(4, 7));
        buildingDef.bAlarmed = false;
    }
}

