/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedDeadSurvivor;

import java.util.ArrayList;
import zombie.core.Rand;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.iso.BuildingDef;
import zombie.iso.RoomDef;
import zombie.iso.objects.IsoDeadBody;
import zombie.randomizedWorld.randomizedDeadSurvivor.RandomizedDeadSurvivorBase;

public final class RDSDeadDrunk
extends RandomizedDeadSurvivorBase {
    final ArrayList<String> alcoholList = new ArrayList();

    public RDSDeadDrunk() {
        this.name = "Dead Drunk";
        this.setChance(10);
        this.alcoholList.add("Base.WhiskeyFull");
        this.alcoholList.add("Base.WhiskeyEmpty");
        this.alcoholList.add("Base.Wine");
        this.alcoholList.add("Base.WineEmpty");
        this.alcoholList.add("Base.Wine2");
        this.alcoholList.add("Base.WineEmpty2");
    }

    @Override
    public void randomizeDeadSurvivor(BuildingDef buildingDef) {
        RoomDef roomDef = this.getLivingRoomOrKitchen(buildingDef);
        IsoDeadBody isoDeadBody = RandomizedDeadSurvivorBase.createRandomDeadBody(roomDef, 0);
        if (isoDeadBody == null) {
            return;
        }
        int n = Rand.Next(2, 4);
        for (int i = 0; i < n; ++i) {
            InventoryItem inventoryItem = InventoryItemFactory.CreateItem(this.alcoholList.get(Rand.Next(0, this.alcoholList.size())));
            isoDeadBody.getSquare().AddWorldInventoryItem(inventoryItem, Rand.Next(0.5f, 1.0f), Rand.Next(0.5f, 1.0f), 0.0f);
            buildingDef.bAlarmed = false;
        }
        isoDeadBody.setPrimaryHandItem(InventoryItemFactory.CreateItem("Base.WhiskeyEmpty"));
    }
}

