/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedDeadSurvivor;

import zombie.core.Rand;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.iso.BuildingDef;
import zombie.iso.RoomDef;
import zombie.iso.objects.IsoDeadBody;
import zombie.randomizedWorld.randomizedDeadSurvivor.RandomizedDeadSurvivorBase;

public final class RDSBleach
extends RandomizedDeadSurvivorBase {
    public RDSBleach() {
        this.name = "Suicide by Bleach";
        this.setChance(10);
        this.setMinimumDays(60);
    }

    @Override
    public void randomizeDeadSurvivor(BuildingDef buildingDef) {
        RoomDef roomDef = this.getLivingRoomOrKitchen(buildingDef);
        IsoDeadBody isoDeadBody = RandomizedDeadSurvivorBase.createRandomDeadBody(roomDef, 0);
        if (isoDeadBody == null) {
            return;
        }
        int n = Rand.Next(1, 3);
        for (int i = 0; i < n; ++i) {
            InventoryItem inventoryItem = InventoryItemFactory.CreateItem("Base.BleachEmpty");
            isoDeadBody.getSquare().AddWorldInventoryItem(inventoryItem, Rand.Next(0.5f, 1.0f), Rand.Next(0.5f, 1.0f), 0.0f);
        }
        isoDeadBody.setPrimaryHandItem(InventoryItemFactory.CreateItem("Base.BleachEmpty"));
        buildingDef.bAlarmed = false;
    }
}

