/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding.TableStories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import zombie.core.Rand;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;
import zombie.randomizedWorld.randomizedBuilding.TableStories.RBTSBreakfast;
import zombie.randomizedWorld.randomizedBuilding.TableStories.RBTSButcher;
import zombie.randomizedWorld.randomizedBuilding.TableStories.RBTSDinner;
import zombie.randomizedWorld.randomizedBuilding.TableStories.RBTSDrink;
import zombie.randomizedWorld.randomizedBuilding.TableStories.RBTSElectronics;
import zombie.randomizedWorld.randomizedBuilding.TableStories.RBTSFoodPreparation;
import zombie.randomizedWorld.randomizedBuilding.TableStories.RBTSSandwich;
import zombie.randomizedWorld.randomizedBuilding.TableStories.RBTSSewing;
import zombie.randomizedWorld.randomizedBuilding.TableStories.RBTSSoup;

public class RBTableStoryBase
extends RandomizedBuildingBase {
    public static ArrayList<RBTableStoryBase> allStories = new ArrayList();
    public static int totalChance = 0;
    protected int chance = 0;
    protected ArrayList<String> rooms = new ArrayList();
    protected boolean need2Tables = false;
    protected boolean ignoreAgainstWall = false;
    protected IsoObject table2 = null;
    protected IsoObject table1 = null;
    protected boolean westTable = false;
    private static final HashMap<RBTableStoryBase, Integer> rbtsmap = new HashMap();
    private static final ArrayList<IsoObject> tableObjects = new ArrayList();
    public ArrayList<HashMap<String, Integer>> fullTableMap = new ArrayList();

    public static void initStories(IsoGridSquare isoGridSquare, IsoObject isoObject) {
        if (allStories.isEmpty()) {
            allStories.add(new RBTSBreakfast());
            allStories.add(new RBTSDinner());
            allStories.add(new RBTSSoup());
            allStories.add(new RBTSSewing());
            allStories.add(new RBTSElectronics());
            allStories.add(new RBTSFoodPreparation());
            allStories.add(new RBTSButcher());
            allStories.add(new RBTSSandwich());
            allStories.add(new RBTSDrink());
        }
        totalChance = 0;
        rbtsmap.clear();
        for (int i = 0; i < allStories.size(); ++i) {
            RBTableStoryBase rBTableStoryBase = allStories.get(i);
            if (!rBTableStoryBase.isValid(isoGridSquare, isoObject, false) || !rBTableStoryBase.isTimeValid(false)) continue;
            totalChance += rBTableStoryBase.chance;
            rbtsmap.put(rBTableStoryBase, rBTableStoryBase.chance);
        }
    }

    public static RBTableStoryBase getRandomStory(IsoGridSquare isoGridSquare, IsoObject isoObject) {
        RBTableStoryBase.initStories(isoGridSquare, isoObject);
        int n = Rand.Next(totalChance);
        Iterator<RBTableStoryBase> iterator = rbtsmap.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            RBTableStoryBase rBTableStoryBase = iterator.next();
            if (n >= (n2 += rbtsmap.get(rBTableStoryBase).intValue())) continue;
            rBTableStoryBase.table1 = isoObject;
            return rBTableStoryBase;
        }
        return null;
    }

    public boolean isValid(IsoGridSquare isoGridSquare, IsoObject isoObject, boolean bl) {
        if (bl) {
            return true;
        }
        if (this.rooms != null && isoGridSquare.getRoom() != null && !this.rooms.contains(isoGridSquare.getRoom().getName())) {
            return false;
        }
        if (this.need2Tables) {
            this.table2 = this.getSecondTable(isoObject);
            if (this.table2 == null) {
                return false;
            }
        }
        return !this.ignoreAgainstWall || isoGridSquare.getWallFull() == false;
    }

    public IsoObject getSecondTable(IsoObject isoObject) {
        this.westTable = true;
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        if (this.ignoreAgainstWall && isoGridSquare.getWallFull().booleanValue()) {
            return null;
        }
        isoObject.getSpriteGridObjects(tableObjects);
        IsoGridSquare isoGridSquare2 = isoGridSquare.getAdjacentSquare(IsoDirections.W);
        IsoObject isoObject2 = this.checkForTable(isoGridSquare2, isoObject, tableObjects);
        if (isoObject2 == null) {
            isoGridSquare2 = isoGridSquare.getAdjacentSquare(IsoDirections.E);
            isoObject2 = this.checkForTable(isoGridSquare2, isoObject, tableObjects);
        }
        if (isoObject2 == null) {
            this.westTable = false;
        }
        if (isoObject2 == null) {
            isoGridSquare2 = isoGridSquare.getAdjacentSquare(IsoDirections.N);
            isoObject2 = this.checkForTable(isoGridSquare2, isoObject, tableObjects);
        }
        if (isoObject2 == null) {
            isoGridSquare2 = isoGridSquare.getAdjacentSquare(IsoDirections.S);
            isoObject2 = this.checkForTable(isoGridSquare2, isoObject, tableObjects);
        }
        if (isoObject2 != null && this.ignoreAgainstWall && isoGridSquare2.getWallFull().booleanValue()) {
            return null;
        }
        return isoObject2;
    }

    private IsoObject checkForTable(IsoGridSquare isoGridSquare, IsoObject isoObject, ArrayList<IsoObject> arrayList) {
        if (isoGridSquare == null) {
            return null;
        }
        if (isoGridSquare.isSomethingTo(isoObject.getSquare())) {
            return null;
        }
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            IsoObject isoObject2 = isoGridSquare.getObjects().get(i);
            if (!arrayList.isEmpty() && !arrayList.contains(isoObject2) || !isoObject2.getProperties().isTable() || isoObject2.getContainer() != null || isoObject2 == isoObject) continue;
            return isoObject2;
        }
        return null;
    }
}

