/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBSpiffo
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (int j = buildingDef.y - 1; j < buildingDef.y2 + 1; ++j) {
                block2: for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null || !this.roomValid(isoGridSquare)) continue;
                    for (int i2 = 0; i2 < isoGridSquare.getObjects().size(); ++i2) {
                        IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                        if (!Rand.NextBool(2) || !this.isTableFor3DItems(isoObject, isoGridSquare)) continue;
                        System.out.println("adding item on table " + isoObject.getSprite().getName() + " coords: " + isoGridSquare.x + "," + isoGridSquare.y);
                        if (Rand.NextBool(2)) {
                            this.addWorldItem("Burger", isoGridSquare, isoObject);
                        }
                        if (Rand.NextBool(2)) {
                            this.addWorldItem("Fries", isoGridSquare, isoObject);
                        }
                        if (Rand.NextBool(2)) {
                            this.addWorldItem("Ketchup", isoGridSquare, isoObject);
                        }
                        if (Rand.NextBool(3)) {
                            this.addWorldItem("Fork", isoGridSquare, isoObject);
                        }
                        if (Rand.NextBool(3)) {
                            this.addWorldItem("ButterKnife", isoGridSquare, isoObject);
                        }
                        if (!Rand.NextBool(30)) continue block2;
                        this.addWorldItem("MugSpiffo", isoGridSquare, isoObject);
                        continue block2;
                    }
                }
            }
        }
    }

    public boolean roomValid(IsoGridSquare isoGridSquare) {
        return isoGridSquare.getRoom() != null && ("spiffo_dining".equals(isoGridSquare.getRoom().getName()) || "burgerkitchen".equals(isoGridSquare.getRoom().getName()));
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        return buildingDef.getRoom("spiffo_dining") != null || buildingDef.getRoom("burgerkitchen") != null || bl;
    }

    public RBSpiffo() {
        this.name = "Spiffo Restaurant";
        this.setAlwaysDo(true);
    }
}

