/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import zombie.core.Rand;
import zombie.inventory.ItemPickerJava;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoWindow;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBLooted
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        buildingDef.bAlarmed = false;
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (int j = buildingDef.y - 1; j < buildingDef.y2 + 1; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null) continue;
                    for (int i2 = 0; i2 < isoGridSquare.getObjects().size(); ++i2) {
                        IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                        if (Rand.Next(100) >= 85 && isoObject instanceof IsoDoor && ((IsoDoor)isoObject).isExteriorDoor(null)) {
                            ((IsoDoor)isoObject).destroy();
                        }
                        if (Rand.Next(100) >= 85 && isoObject instanceof IsoWindow) {
                            ((IsoWindow)isoObject).smashWindow(false, false);
                        }
                        if (isoObject.getContainer() == null || isoObject.getContainer().getItems() == null) continue;
                        for (int i3 = 0; i3 < isoObject.getContainer().getItems().size(); ++i3) {
                            if (Rand.Next(100) >= 80) continue;
                            isoObject.getContainer().getItems().remove(i3);
                            --i3;
                        }
                        ItemPickerJava.updateOverlaySprite(isoObject);
                        isoObject.getContainer().setExplored(true);
                    }
                }
            }
        }
        buildingDef.setAllExplored(true);
        buildingDef.bAlarmed = false;
    }

    public RBLooted() {
        this.name = "Looted";
        this.setChance(10);
    }
}

