/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBCafe
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (int j = buildingDef.y - 1; j < buildingDef.y2 + 1; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null || !this.roomValid(isoGridSquare)) continue;
                    for (int i2 = 0; i2 < isoGridSquare.getObjects().size(); ++i2) {
                        IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                        if (!Rand.NextBool(2) || !this.isTableFor3DItems(isoObject, isoGridSquare)) continue;
                        if (Rand.NextBool(2)) {
                            int n = Rand.Next(3);
                            switch (n) {
                                case 0: {
                                    this.addWorldItem("Mugl", isoGridSquare, isoObject);
                                    break;
                                }
                                case 1: {
                                    this.addWorldItem("MugWhite", isoGridSquare, isoObject);
                                    break;
                                }
                                case 2: {
                                    this.addWorldItem("MugRed", isoGridSquare, isoObject);
                                }
                            }
                        }
                        if (Rand.NextBool(4)) {
                            this.addWorldItem("Cupcake", isoGridSquare, isoObject);
                        }
                        if (Rand.NextBool(4)) {
                            this.addWorldItem("CookieJelly", isoGridSquare, isoObject);
                        }
                        if (Rand.NextBool(4)) {
                            this.addWorldItem("CookieChocolateChip", isoGridSquare, isoObject);
                        }
                        if (Rand.NextBool(4)) {
                            this.addWorldItem("Kettle", isoGridSquare, isoObject);
                        }
                        if (Rand.NextBool(3)) {
                            this.addWorldItem("Sugar", isoGridSquare, isoObject);
                        }
                        if (!Rand.NextBool(2)) continue;
                        this.addWorldItem("Teabag2", isoGridSquare, isoObject);
                    }
                }
            }
        }
    }

    public boolean roomValid(IsoGridSquare isoGridSquare) {
        return isoGridSquare.getRoom() != null && "cafe".equals(isoGridSquare.getRoom().getName());
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        return buildingDef.getRoom("cafe") != null || bl;
    }

    public RBCafe() {
        this.name = "Cafe (Seahorse..)";
        this.setAlwaysDo(true);
    }
}

