/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import java.util.ArrayList;
import zombie.characters.IsoZombie;
import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.SpawnPoints;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;
import zombie.vehicles.BaseVehicle;

public final class RBBurntFireman
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        int n;
        buildingDef.bAlarmed = false;
        int n2 = Rand.Next(1, 4);
        buildingDef.setHasBeenVisited(true);
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (n = buildingDef.y - 1; n < buildingDef.y2 + 1; ++n) {
                for (int j = 0; j < 8; ++j) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, n, j);
                    if (isoGridSquare == null || Rand.Next(100) >= 70) continue;
                    isoGridSquare.Burn(false);
                }
            }
        }
        buildingDef.setAllExplored(true);
        ArrayList<IsoZombie> arrayList = this.addZombies(buildingDef, n2, "FiremanFullSuit", 35, this.getLivingRoomOrKitchen(buildingDef));
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList.get(n).getInventory().setExplored(true);
        }
        BaseVehicle baseVehicle = Rand.NextBool(2) ? this.spawnCarOnNearestNav("Base.PickUpVanLightsFire", buildingDef) : this.spawnCarOnNearestNav("Base.PickUpTruckLightsFire", buildingDef);
        if (baseVehicle != null) {
            baseVehicle.setAlarmed(false);
        }
        if (baseVehicle != null && !arrayList.isEmpty()) {
            arrayList.get(Rand.Next(arrayList.size())).addItemToSpawnAtDeath(baseVehicle.createVehicleKey());
        }
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        if (!super.isValid(buildingDef, bl)) {
            return false;
        }
        if (buildingDef.getRooms().size() > 20) {
            return false;
        }
        return !SpawnPoints.instance.isSpawnBuilding(buildingDef);
    }

    public RBBurntFireman() {
        this.name = "Burnt Fireman";
        this.setChance(2);
    }
}

