/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import java.util.ArrayList;
import zombie.characters.IsoZombie;
import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.SpawnPoints;
import zombie.iso.objects.IsoDeadBody;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBBurntCorpse
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        int n;
        buildingDef.bAlarmed = false;
        buildingDef.setHasBeenVisited(true);
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (n = buildingDef.y - 1; n < buildingDef.y2 + 1; ++n) {
                for (int j = 0; j < 8; ++j) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, n, j);
                    if (isoGridSquare == null || Rand.Next(100) >= 60) continue;
                    isoGridSquare.Burn(false);
                }
            }
        }
        buildingDef.setAllExplored(true);
        buildingDef.bAlarmed = false;
        ArrayList<IsoZombie> arrayList = this.addZombies(buildingDef, Rand.Next(3, 7), null, null, null);
        if (arrayList == null) {
            return;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            IsoZombie isoZombie = arrayList.get(n);
            isoZombie.setSkeleton(true);
            isoZombie.getHumanVisual().setSkinTextureIndex(0);
            new IsoDeadBody(isoZombie, false);
        }
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        if (!super.isValid(buildingDef, bl)) {
            return false;
        }
        if (buildingDef.getRooms().size() > 20) {
            return false;
        }
        return !SpawnPoints.instance.isSpawnBuilding(buildingDef);
    }

    public RBBurntCorpse() {
        this.name = "Burnt with corpses";
        this.setChance(3);
    }
}

