/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import zombie.core.Rand;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemPickerJava;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoRadio;
import zombie.iso.objects.IsoStove;
import zombie.iso.objects.IsoTelevision;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.sprite.IsoSprite;
import zombie.network.GameServer;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;
import zombie.randomizedWorld.randomizedBuilding.TableStories.RBTableStoryBase;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSBandPractice;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSBathroomZed;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSBedroomZed;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSBleach;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSCorpsePsycho;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSDeadDrunk;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSFootballNight;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSGunmanInBathroom;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSGunslinger;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSHenDo;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSHockeyPsycho;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSHouseParty;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSPokerNight;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSPoliceAtHouse;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSPrisonEscape;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSPrisonEscapeWithPolice;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSSkeletonPsycho;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSSpecificProfession;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSStagDo;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSStudentNight;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSSuicidePact;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSTinFoilHat;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSZombieLockedBathroom;
import zombie.randomizedWorld.randomizedDeadSurvivor.RDSZombiesEating;
import zombie.randomizedWorld.randomizedDeadSurvivor.RandomizedDeadSurvivorBase;

public final class RBBasic
extends RandomizedBuildingBase {
    private final ArrayList<String> specificProfessionDistribution = new ArrayList();
    private final Map<String, String> specificProfessionRoomDistribution = new HashMap<String, String>();
    private static final HashMap<Integer, String> kitchenSinkItems = new HashMap();
    private static final HashMap<Integer, String> kitchenCounterItems = new HashMap();
    private static final HashMap<Integer, String> kitchenStoveItems = new HashMap();
    private static final HashMap<Integer, String> bathroomSinkItems = new HashMap();
    private final ArrayList<String> coldFood = new ArrayList();
    private final Map<String, String> plankStash = new HashMap<String, String>();
    private final ArrayList<RandomizedDeadSurvivorBase> deadSurvivorsStory = new ArrayList();
    private int totalChanceRDS = 0;
    private static final HashMap<RandomizedDeadSurvivorBase, Integer> rdsMap = new HashMap();
    private static final ArrayList<String> uniqueRDSSpawned = new ArrayList();
    private ArrayList<IsoObject> tablesDone = new ArrayList();
    private boolean doneTable = false;

    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        int n;
        this.tablesDone = new ArrayList();
        boolean bl = Rand.Next(100) <= 20;
        ArrayList<ItemContainer> arrayList = new ArrayList<ItemContainer>();
        String string = this.specificProfessionDistribution.get(Rand.Next(0, this.specificProfessionDistribution.size()));
        ItemPickerJava.ItemPickerRoom itemPickerRoom = (ItemPickerJava.ItemPickerRoom)ItemPickerJava.rooms.get((Object)string);
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        boolean bl2 = Rand.NextBool(9);
        for (n = buildingDef.x - 1; n < buildingDef.x2 + 1; ++n) {
            for (int i = buildingDef.y - 1; i < buildingDef.y2 + 1; ++i) {
                for (int j = 0; j < 8; ++j) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(n, i, j);
                    if (isoGridSquare == null) continue;
                    if (bl2 && isoGridSquare.getFloor() != null && this.plankStash.containsKey(isoGridSquare.getFloor().getSprite().getName())) {
                        IsoThumpable isoThumpable = new IsoThumpable(isoGridSquare.getCell(), isoGridSquare, this.plankStash.get(isoGridSquare.getFloor().getSprite().getName()), false, null);
                        isoThumpable.setIsThumpable(false);
                        isoThumpable.container = new ItemContainer("plankstash", isoGridSquare, isoThumpable);
                        isoGridSquare.AddSpecialObject(isoThumpable);
                        isoGridSquare.RecalcAllWithNeighbours(true);
                        bl2 = false;
                    }
                    for (int k = 0; k < isoGridSquare.getObjects().size(); ++k) {
                        Object object;
                        IsoObject isoObject = isoGridSquare.getObjects().get(k);
                        if (Rand.Next(100) <= 65 && isoObject instanceof IsoDoor && !((IsoDoor)isoObject).isExteriorDoor(null)) {
                            ((IsoDoor)isoObject).ToggleDoorSilent();
                            ((IsoDoor)isoObject).syncIsoObject(true, (byte)1, null, null);
                        }
                        if (isoObject instanceof IsoWindow) {
                            IsoCurtain isoCurtain;
                            object = (IsoWindow)isoObject;
                            if (Rand.NextBool(80)) {
                                buildingDef.bAlarmed = false;
                                ((IsoWindow)object).ToggleWindow(null);
                            }
                            if ((isoCurtain = ((IsoWindow)object).HasCurtains()) != null && Rand.NextBool(15)) {
                                isoCurtain.ToggleDoorSilent();
                            }
                        }
                        if (bl && Rand.Next(100) <= 70 && isoObject.getContainer() != null && isoGridSquare.getRoom() != null && isoGridSquare.getRoom().getName() != null && this.specificProfessionRoomDistribution.get(string).contains(isoGridSquare.getRoom().getName()) && itemPickerRoom.Containers.containsKey((Object)isoObject.getContainer().getType())) {
                            isoObject.getContainer().clear();
                            arrayList.add(isoObject.getContainer());
                            isoObject.getContainer().setExplored(true);
                        }
                        if (Rand.Next(100) < 15 && isoObject.getContainer() != null && isoObject.getContainer().getType().equals("stove")) {
                            object = isoObject.getContainer().AddItem(this.coldFood.get(Rand.Next(0, this.coldFood.size())));
                            ((InventoryItem)object).setCooked(true);
                            ((InventoryItem)object).setAutoAge();
                        }
                        if (this.tablesDone.contains(isoObject) || !isoObject.getProperties().isTable() || isoObject.getContainer() != null || this.doneTable) continue;
                        this.checkForTableSpawn(buildingDef, isoObject);
                    }
                    if (isoGridSquare.getRoom() != null && "kitchen".equals(isoGridSquare.getRoom().getName())) {
                        this.doKitchenStuff(isoGridSquare);
                    }
                    if (isoGridSquare.getRoom() != null && "bathroom".equals(isoGridSquare.getRoom().getName())) {
                        this.doBathroomStuff(isoGridSquare);
                    }
                    if (isoGridSquare.getRoom() != null && "bedroom".equals(isoGridSquare.getRoom().getName())) {
                        this.doBedroomStuff(isoGridSquare);
                    }
                    if (isoGridSquare.getRoom() == null || !"livingroom".equals(isoGridSquare.getRoom().getName())) continue;
                    this.doLivingRoomStuff(isoGridSquare);
                }
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ItemContainer itemContainer = (ItemContainer)arrayList.get(n);
            ItemPickerJava.fillContainerType(itemPickerRoom, itemContainer, "", null);
            ItemPickerJava.updateOverlaySprite(itemContainer.getParent());
            if (!GameServer.bServer) continue;
            GameServer.sendItemsInContainer(itemContainer.getParent(), itemContainer);
        }
        if (!bl && Rand.Next(100) < 25) {
            this.addRandomDeadSurvivorStory(buildingDef);
            buildingDef.setAllExplored(true);
            buildingDef.bAlarmed = false;
        }
        this.doneTable = false;
    }

    private void doLivingRoomStuff(IsoGridSquare isoGridSquare) {
        Object object;
        int n;
        Object object2 = null;
        boolean bl = false;
        for (n = 0; n < isoGridSquare.getObjects().size(); ++n) {
            object = isoGridSquare.getObjects().get(n);
            if (Rand.NextBool(5) && ((IsoObject)object).getProperties().Val("BedType") == null && ((IsoObject)object).getSurfaceOffsetNoTable() > 0.0f && ((IsoObject)object).getSurfaceOffsetNoTable() < 30.0f && !(object instanceof IsoRadio)) {
                object2 = object;
            }
            if (!(object instanceof IsoRadio) && !(object instanceof IsoTelevision)) continue;
            bl = true;
            break;
        }
        if (!bl && object2 != null) {
            n = Rand.Next(0, 6);
            object = "Base.TVRemote";
            switch (n) {
                case 0: {
                    object = "Base.TVRemote";
                    break;
                }
                case 1: {
                    object = "Base.TVMagazine";
                    break;
                }
                case 2: {
                    object = "Base.Newspaper";
                    break;
                }
                case 3: {
                    object = "Base.VideoGame";
                    break;
                }
                case 4: {
                    object = "Base.Mugl";
                    break;
                }
                case 5: {
                    object = "Base.Headphones";
                }
            }
            IsoDirections isoDirections = this.getFacing(((IsoObject)object2).getSprite());
            if (isoDirections != null) {
                if (isoDirections == IsoDirections.E) {
                    this.addWorldItem((String)object, isoGridSquare, 0.4f, Rand.Next(0.34f, 0.74f), ((IsoObject)object2).getSurfaceOffsetNoTable() / 96.0f);
                }
                if (isoDirections == IsoDirections.W) {
                    this.addWorldItem((String)object, isoGridSquare, 0.64f, Rand.Next(0.34f, 0.74f), ((IsoObject)object2).getSurfaceOffsetNoTable() / 96.0f);
                }
                if (isoDirections == IsoDirections.N) {
                    this.addWorldItem((String)object, isoGridSquare, Rand.Next(0.44f, 0.64f), 0.67f, ((IsoObject)object2).getSurfaceOffsetNoTable() / 96.0f);
                }
                if (isoDirections == IsoDirections.S) {
                    this.addWorldItem((String)object, isoGridSquare, Rand.Next(0.44f, 0.64f), 0.42f, ((IsoObject)object2).getSurfaceOffsetNoTable() / 96.0f);
                }
            }
        }
    }

    private void doBedroomStuff(IsoGridSquare isoGridSquare) {
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            int n;
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            if (isoObject.getSprite() == null || isoObject.getSprite().getName() == null) {
                return;
            }
            if (Rand.NextBool(7) && isoObject.getSprite().getName().contains("bedding") && isoObject.getProperties().Val("BedType") != null) {
                n = Rand.Next(0, 14);
                switch (n) {
                    case 0: {
                        this.addWorldItem("Shirt_FormalTINT", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 1: {
                        this.addWorldItem("Shirt_FormalWhite_ShortSleeveTINT", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 2: {
                        this.addWorldItem("Tshirt_DefaultDECAL_TINT", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 3: {
                        this.addWorldItem("Tshirt_PoloStripedTINT", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 4: {
                        this.addWorldItem("Tshirt_PoloTINT", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 5: {
                        this.addWorldItem("Jacket_WhiteTINT", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 6: {
                        this.addWorldItem("Jumper_DiamondPatternTINT", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 7: {
                        this.addWorldItem("Jumper_TankTopDiamondTINT", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 8: {
                        this.addWorldItem("HoodieDOWN_WhiteTINT", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 9: {
                        this.addWorldItem("Trousers_DefaultTEXTURE_TINT", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 10: {
                        this.addWorldItem("Trousers_WhiteTINT", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 11: {
                        this.addWorldItem("Trousers_Denim", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 12: {
                        this.addWorldItem("Trousers_Padded", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 13: {
                        this.addWorldItem("TrousersMesh_DenimLight", isoGridSquare, 0.6f, 0.6f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    }
                }
            }
            if (!Rand.NextBool(7) || isoObject.getContainer() == null || !"sidetable".equals(isoObject.getContainer().getType())) continue;
            n = Rand.Next(0, 4);
            String string = "Base.Book";
            switch (n) {
                case 0: {
                    string = "Base.Book";
                    break;
                }
                case 1: {
                    string = "Base.Notebook";
                    break;
                }
                case 2: {
                    string = "Base.VideoGame";
                    break;
                }
                case 3: {
                    string = "Base.CDPlayer";
                }
            }
            IsoDirections isoDirections = this.getFacing(isoObject.getSprite());
            if (isoDirections != null) {
                if (isoDirections == IsoDirections.E) {
                    this.addWorldItem(string, isoGridSquare, 0.42f, Rand.Next(0.34f, 0.74f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                }
                if (isoDirections == IsoDirections.W) {
                    this.addWorldItem(string, isoGridSquare, 0.64f, Rand.Next(0.34f, 0.74f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                }
                if (isoDirections == IsoDirections.N) {
                    this.addWorldItem(string, isoGridSquare, Rand.Next(0.44f, 0.64f), 0.67f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                }
                if (isoDirections == IsoDirections.S) {
                    this.addWorldItem(string, isoGridSquare, Rand.Next(0.44f, 0.64f), 0.42f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                }
            }
            return;
        }
    }

    private void doKitchenStuff(IsoGridSquare isoGridSquare) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            IsoDirections isoDirections;
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            if (isoObject.getSprite() == null || isoObject.getSprite().getName() == null) {
                return;
            }
            if (!bl && isoObject.getSprite().getName().contains("sink") && Rand.NextBool(4)) {
                isoDirections = this.getFacing(isoObject.getSprite());
                if (isoDirections == null) continue;
                this.generateSinkClutter(isoDirections, isoObject, isoGridSquare, kitchenSinkItems);
                bl = true;
                continue;
            }
            if (!bl2 && isoObject.getContainer() != null && "counter".equals(isoObject.getContainer().getType()) && Rand.NextBool(6)) {
                IsoDirections isoDirections2;
                boolean bl3 = true;
                for (int j = 0; j < isoGridSquare.getObjects().size(); ++j) {
                    IsoObject isoObject2 = isoGridSquare.getObjects().get(j);
                    if ((isoObject2.getSprite() == null || isoObject2.getSprite().getName() == null || !isoObject2.getSprite().getName().contains("sink")) && !(isoObject2 instanceof IsoStove) && !(isoObject2 instanceof IsoRadio)) continue;
                    bl3 = false;
                    break;
                }
                if (!bl3 || (isoDirections2 = this.getFacing(isoObject.getSprite())) == null) continue;
                this.generateCounterClutter(isoDirections2, isoObject, isoGridSquare, kitchenCounterItems);
                bl2 = true;
                continue;
            }
            if (!(isoObject instanceof IsoStove) || isoObject.getContainer() == null || !"stove".equals(isoObject.getContainer().getType()) || !Rand.NextBool(4) || (isoDirections = this.getFacing(isoObject.getSprite())) == null) continue;
            this.generateKitchenStoveClutter(isoDirections, isoObject, isoGridSquare);
        }
    }

    private void doBathroomStuff(IsoGridSquare isoGridSquare) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            IsoDirections isoDirections;
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            if (isoObject.getSprite() == null || isoObject.getSprite().getName() == null) {
                return;
            }
            if (!bl && !bl2 && isoObject.getSprite().getName().contains("sink") && Rand.NextBool(5) && isoObject.getSurfaceOffsetNoTable() > 0.0f) {
                IsoDirections isoDirections2 = this.getFacing(isoObject.getSprite());
                if (isoDirections2 == null) continue;
                this.generateSinkClutter(isoDirections2, isoObject, isoGridSquare, bathroomSinkItems);
                bl = true;
                continue;
            }
            if (bl || bl2 || isoObject.getContainer() == null || !"counter".equals(isoObject.getContainer().getType()) || !Rand.NextBool(5)) continue;
            boolean bl3 = true;
            for (int j = 0; j < isoGridSquare.getObjects().size(); ++j) {
                IsoObject isoObject2 = isoGridSquare.getObjects().get(j);
                if ((isoObject2.getSprite() == null || isoObject2.getSprite().getName() == null || !isoObject2.getSprite().getName().contains("sink")) && !(isoObject2 instanceof IsoStove) && !(isoObject2 instanceof IsoRadio)) continue;
                bl3 = false;
                break;
            }
            if (!bl3 || (isoDirections = this.getFacing(isoObject.getSprite())) == null) continue;
            this.generateCounterClutter(isoDirections, isoObject, isoGridSquare, bathroomSinkItems);
            bl2 = true;
        }
    }

    private void generateKitchenStoveClutter(IsoDirections isoDirections, IsoObject isoObject, IsoGridSquare isoGridSquare) {
        int n = Rand.Next(1, 3);
        String string = kitchenStoveItems.get(Rand.Next(1, kitchenStoveItems.size()));
        if (isoDirections == IsoDirections.W) {
            switch (n) {
                case 1: {
                    this.addWorldItem(string, isoGridSquare, 0.5703125f, 0.8046875f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    break;
                }
                case 2: {
                    this.addWorldItem(string, isoGridSquare, 0.5703125f, 0.2578125f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                }
            }
        }
        if (isoDirections == IsoDirections.E) {
            switch (n) {
                case 1: {
                    this.addWorldItem(string, isoGridSquare, 0.5f, 0.7890625f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    break;
                }
                case 2: {
                    this.addWorldItem(string, isoGridSquare, 0.5f, 0.1875f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                }
            }
        }
        if (isoDirections == IsoDirections.S) {
            switch (n) {
                case 1: {
                    this.addWorldItem(string, isoGridSquare, 0.3125f, 0.53125f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    break;
                }
                case 2: {
                    this.addWorldItem(string, isoGridSquare, 0.875f, 0.53125f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                }
            }
        }
        if (isoDirections == IsoDirections.N) {
            switch (n) {
                case 1: {
                    this.addWorldItem(string, isoGridSquare, 0.3203f, 0.523475f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    break;
                }
                case 2: {
                    this.addWorldItem(string, isoGridSquare, 0.8907f, 0.523475f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                }
            }
        }
    }

    private void generateCounterClutter(IsoDirections isoDirections, IsoObject isoObject, IsoGridSquare isoGridSquare, HashMap<Integer, String> hashMap) {
        int n;
        int n2;
        int n3 = Math.min(5, hashMap.size() + 1);
        int n4 = Rand.Next(1, n3);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n4; ++i) {
            n2 = Rand.Next(1, 5);
            n = 0;
            while (n == 0) {
                if (!arrayList.contains(n2)) {
                    arrayList.add(n2);
                    n = 1;
                    continue;
                }
                n2 = Rand.Next(1, 5);
            }
            if (arrayList.size() != 4) continue;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        block26: for (n2 = 0; n2 < arrayList.size(); ++n2) {
            n = (Integer)arrayList.get(n2);
            int n5 = Rand.Next(1, hashMap.size() + 1);
            String string = null;
            while (string == null) {
                string = hashMap.get(n5);
                if (!arrayList2.contains(string)) continue;
                string = null;
                n5 = Rand.Next(1, hashMap.size() + 1);
            }
            arrayList2.add(string);
            if (isoDirections == IsoDirections.S) {
                switch (n) {
                    case 1: {
                        this.addWorldItem(string, isoGridSquare, 0.138f, Rand.Next(0.2f, 0.523f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 2: {
                        this.addWorldItem(string, isoGridSquare, 0.383f, Rand.Next(0.2f, 0.523f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 3: {
                        this.addWorldItem(string, isoGridSquare, 0.633f, Rand.Next(0.2f, 0.523f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 4: {
                        this.addWorldItem(string, isoGridSquare, 0.78f, Rand.Next(0.2f, 0.523f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    }
                }
            }
            if (isoDirections == IsoDirections.N) {
                switch (n) {
                    case 1: {
                        isoGridSquare.AddWorldInventoryItem(string, 0.133f, Rand.Next(0.53125f, 0.9375f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 2: {
                        isoGridSquare.AddWorldInventoryItem(string, 0.38f, Rand.Next(0.53125f, 0.9375f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 3: {
                        isoGridSquare.AddWorldInventoryItem(string, 0.625f, Rand.Next(0.53125f, 0.9375f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 4: {
                        isoGridSquare.AddWorldInventoryItem(string, 0.92f, Rand.Next(0.53125f, 0.9375f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    }
                }
            }
            if (isoDirections == IsoDirections.E) {
                switch (n) {
                    case 1: {
                        isoGridSquare.AddWorldInventoryItem(string, Rand.Next(0.226f, 0.593f), 0.14f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 2: {
                        isoGridSquare.AddWorldInventoryItem(string, Rand.Next(0.226f, 0.593f), 0.33f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 3: {
                        isoGridSquare.AddWorldInventoryItem(string, Rand.Next(0.226f, 0.593f), 0.64f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 4: {
                        isoGridSquare.AddWorldInventoryItem(string, Rand.Next(0.226f, 0.593f), 0.92f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    }
                }
            }
            if (isoDirections != IsoDirections.W) continue;
            switch (n) {
                case 1: {
                    isoGridSquare.AddWorldInventoryItem(string, Rand.Next(0.5859375f, 0.9f), 0.21875f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    continue block26;
                }
                case 2: {
                    isoGridSquare.AddWorldInventoryItem(string, Rand.Next(0.5859375f, 0.9f), 0.421875f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    continue block26;
                }
                case 3: {
                    isoGridSquare.AddWorldInventoryItem(string, Rand.Next(0.5859375f, 0.9f), 0.71f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    continue block26;
                }
                case 4: {
                    isoGridSquare.AddWorldInventoryItem(string, Rand.Next(0.5859375f, 0.9f), 0.9175f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                }
            }
        }
    }

    private void generateSinkClutter(IsoDirections isoDirections, IsoObject isoObject, IsoGridSquare isoGridSquare, HashMap<Integer, String> hashMap) {
        int n;
        int n2;
        int n3 = Math.min(5, hashMap.size() + 1);
        int n4 = Rand.Next(1, n3);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n4; ++i) {
            n2 = Rand.Next(1, 5);
            n = 0;
            while (n == 0) {
                if (!arrayList.contains(n2)) {
                    arrayList.add(n2);
                    n = 1;
                    continue;
                }
                n2 = Rand.Next(1, 5);
            }
            if (arrayList.size() != 4) continue;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        block26: for (n2 = 0; n2 < arrayList.size(); ++n2) {
            n = (Integer)arrayList.get(n2);
            int n5 = Rand.Next(1, hashMap.size() + 1);
            String string = null;
            while (string == null) {
                string = hashMap.get(n5);
                if (!arrayList2.contains(string)) continue;
                string = null;
                n5 = Rand.Next(1, hashMap.size() + 1);
            }
            arrayList2.add(string);
            if (isoDirections == IsoDirections.S) {
                switch (n) {
                    case 1: {
                        this.addWorldItem(string, isoGridSquare, 0.71875f, 0.125f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 2: {
                        this.addWorldItem(string, isoGridSquare, 0.0935f, 0.21875f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 3: {
                        this.addWorldItem(string, isoGridSquare, 0.1328125f, 0.589375f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 4: {
                        this.addWorldItem(string, isoGridSquare, 0.7890625f, 0.589375f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    }
                }
            }
            if (isoDirections == IsoDirections.N) {
                switch (n) {
                    case 1: {
                        this.addWorldItem(string, isoGridSquare, 0.921875f, 0.921875f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 2: {
                        this.addWorldItem(string, isoGridSquare, 0.1640625f, 0.8984375f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 3: {
                        this.addWorldItem(string, isoGridSquare, 0.021875f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 4: {
                        this.addWorldItem(string, isoGridSquare, 0.8671875f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    }
                }
            }
            if (isoDirections == IsoDirections.E) {
                switch (n) {
                    case 1: {
                        this.addWorldItem(string, isoGridSquare, 0.234375f, 0.859375f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 2: {
                        this.addWorldItem(string, isoGridSquare, 0.59375f, 0.875f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 3: {
                        this.addWorldItem(string, isoGridSquare, 0.53125f, 0.125f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                        break;
                    }
                    case 4: {
                        this.addWorldItem(string, isoGridSquare, 0.210937f, 0.1328125f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    }
                }
            }
            if (isoDirections != IsoDirections.W) continue;
            switch (n) {
                case 1: {
                    this.addWorldItem(string, isoGridSquare, 0.515625f, 0.109375f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    continue block26;
                }
                case 2: {
                    this.addWorldItem(string, isoGridSquare, 0.578125f, 0.890625f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    continue block26;
                }
                case 3: {
                    this.addWorldItem(string, isoGridSquare, 0.8828125f, 0.8984375f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                    continue block26;
                }
                case 4: {
                    this.addWorldItem(string, isoGridSquare, 0.8671875f, 0.1653125f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                }
            }
        }
    }

    private IsoDirections getFacing(IsoSprite isoSprite) {
        if (isoSprite != null && isoSprite.getProperties().Is("Facing")) {
            String string;
            switch (string = isoSprite.getProperties().Val("Facing")) {
                case "N": {
                    return IsoDirections.N;
                }
                case "S": {
                    return IsoDirections.S;
                }
                case "W": {
                    return IsoDirections.W;
                }
                case "E": {
                    return IsoDirections.E;
                }
            }
        }
        return null;
    }

    private void checkForTableSpawn(BuildingDef buildingDef, IsoObject isoObject) {
        RBTableStoryBase rBTableStoryBase;
        if (Rand.NextBool(10) && (rBTableStoryBase = RBTableStoryBase.getRandomStory(isoObject.getSquare(), isoObject)) != null) {
            rBTableStoryBase.randomizeBuilding(buildingDef);
            this.doneTable = true;
        }
    }

    private IsoObject checkForTable(IsoGridSquare isoGridSquare, IsoObject isoObject) {
        if (this.tablesDone.contains(isoObject) || isoGridSquare == null) {
            return null;
        }
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            IsoObject isoObject2 = isoGridSquare.getObjects().get(i);
            if (this.tablesDone.contains(isoObject2) || !isoObject2.getProperties().isTable() || isoObject2.getProperties().getSurface() != 34 || isoObject2.getContainer() != null || isoObject2 == isoObject) continue;
            return isoObject2;
        }
        return null;
    }

    public void doProfessionStory(BuildingDef buildingDef, String string) {
        this.spawnItemsInContainers(buildingDef, string, 70);
    }

    private void addRandomDeadSurvivorStory(BuildingDef buildingDef) {
        this.initRDSMap(buildingDef);
        int n = Rand.Next(this.totalChanceRDS);
        Iterator<RandomizedDeadSurvivorBase> iterator = rdsMap.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            RandomizedDeadSurvivorBase randomizedDeadSurvivorBase = iterator.next();
            if (n >= (n2 += rdsMap.get(randomizedDeadSurvivorBase).intValue())) continue;
            randomizedDeadSurvivorBase.randomizeDeadSurvivor(buildingDef);
            if (!randomizedDeadSurvivorBase.isUnique()) break;
            RBBasic.getUniqueRDSSpawned().add(randomizedDeadSurvivorBase.getName());
            break;
        }
    }

    private void initRDSMap(BuildingDef buildingDef) {
        this.totalChanceRDS = 0;
        rdsMap.clear();
        for (int i = 0; i < this.deadSurvivorsStory.size(); ++i) {
            RandomizedDeadSurvivorBase randomizedDeadSurvivorBase = this.deadSurvivorsStory.get(i);
            if (!randomizedDeadSurvivorBase.isValid(buildingDef, false) || !randomizedDeadSurvivorBase.isTimeValid(false) || (!randomizedDeadSurvivorBase.isUnique() || RBBasic.getUniqueRDSSpawned().contains(randomizedDeadSurvivorBase.getName())) && randomizedDeadSurvivorBase.isUnique()) continue;
            this.totalChanceRDS += this.deadSurvivorsStory.get(i).getChance();
            rdsMap.put(this.deadSurvivorsStory.get(i), this.deadSurvivorsStory.get(i).getChance());
        }
    }

    public void doRandomDeadSurvivorStory(BuildingDef buildingDef, RandomizedDeadSurvivorBase randomizedDeadSurvivorBase) {
        randomizedDeadSurvivorBase.randomizeDeadSurvivor(buildingDef);
    }

    public RBBasic() {
        this.name = "RBBasic";
        this.deadSurvivorsStory.add(new RDSBleach());
        this.deadSurvivorsStory.add(new RDSGunslinger());
        this.deadSurvivorsStory.add(new RDSGunmanInBathroom());
        this.deadSurvivorsStory.add(new RDSZombieLockedBathroom());
        this.deadSurvivorsStory.add(new RDSDeadDrunk());
        this.deadSurvivorsStory.add(new RDSSpecificProfession());
        this.deadSurvivorsStory.add(new RDSZombiesEating());
        this.deadSurvivorsStory.add(new RDSBandPractice());
        this.deadSurvivorsStory.add(new RDSBathroomZed());
        this.deadSurvivorsStory.add(new RDSBedroomZed());
        this.deadSurvivorsStory.add(new RDSFootballNight());
        this.deadSurvivorsStory.add(new RDSHenDo());
        this.deadSurvivorsStory.add(new RDSStagDo());
        this.deadSurvivorsStory.add(new RDSStudentNight());
        this.deadSurvivorsStory.add(new RDSPokerNight());
        this.deadSurvivorsStory.add(new RDSSuicidePact());
        this.deadSurvivorsStory.add(new RDSPrisonEscape());
        this.deadSurvivorsStory.add(new RDSPrisonEscapeWithPolice());
        this.deadSurvivorsStory.add(new RDSSkeletonPsycho());
        this.deadSurvivorsStory.add(new RDSCorpsePsycho());
        this.deadSurvivorsStory.add(new RDSPoliceAtHouse());
        this.deadSurvivorsStory.add(new RDSHouseParty());
        this.deadSurvivorsStory.add(new RDSTinFoilHat());
        this.deadSurvivorsStory.add(new RDSHockeyPsycho());
        this.specificProfessionDistribution.add("Carpenter");
        this.specificProfessionDistribution.add("Electrician");
        this.specificProfessionDistribution.add("Farmer");
        this.specificProfessionDistribution.add("Nurse");
        this.specificProfessionRoomDistribution.put("Carpenter", "kitchen");
        this.specificProfessionRoomDistribution.put("Electrician", "kitchen");
        this.specificProfessionRoomDistribution.put("Farmer", "kitchen");
        this.specificProfessionRoomDistribution.put("Nurse", "kitchen");
        this.specificProfessionRoomDistribution.put("Nurse", "bathroom");
        this.coldFood.add("Base.Chicken");
        this.coldFood.add("Base.Steak");
        this.coldFood.add("Base.PorkChop");
        this.coldFood.add("Base.MuttonChop");
        this.coldFood.add("Base.MeatPatty");
        this.coldFood.add("Base.FishFillet");
        this.coldFood.add("Base.Salmon");
        this.plankStash.put("floors_interior_tilesandwood_01_40", "floors_interior_tilesandwood_01_56");
        this.plankStash.put("floors_interior_tilesandwood_01_41", "floors_interior_tilesandwood_01_57");
        this.plankStash.put("floors_interior_tilesandwood_01_42", "floors_interior_tilesandwood_01_58");
        this.plankStash.put("floors_interior_tilesandwood_01_43", "floors_interior_tilesandwood_01_59");
        this.plankStash.put("floors_interior_tilesandwood_01_44", "floors_interior_tilesandwood_01_60");
        this.plankStash.put("floors_interior_tilesandwood_01_45", "floors_interior_tilesandwood_01_61");
        this.plankStash.put("floors_interior_tilesandwood_01_46", "floors_interior_tilesandwood_01_62");
        this.plankStash.put("floors_interior_tilesandwood_01_47", "floors_interior_tilesandwood_01_63");
        this.plankStash.put("floors_interior_tilesandwood_01_52", "floors_interior_tilesandwood_01_68");
        kitchenSinkItems.put(1, "Soap2");
        kitchenSinkItems.put(2, "CleaningLiquid2");
        kitchenSinkItems.put(3, "Sponge");
        kitchenCounterItems.put(1, "Dogfood");
        kitchenCounterItems.put(2, "CannedCorn");
        kitchenCounterItems.put(3, "CannedPeas");
        kitchenCounterItems.put(4, "CannedPotato2");
        kitchenCounterItems.put(5, "CannedSardines");
        kitchenCounterItems.put(6, "CannedTomato2");
        kitchenCounterItems.put(7, "CannedCarrots2");
        kitchenCounterItems.put(8, "CannedChili");
        kitchenCounterItems.put(9, "CannedBolognese");
        kitchenCounterItems.put(10, "TinOpener");
        kitchenCounterItems.put(11, "WaterBottleFull");
        kitchenCounterItems.put(12, "Cereal");
        kitchenCounterItems.put(13, "CerealBowl");
        kitchenCounterItems.put(14, "Spoon");
        kitchenCounterItems.put(15, "Fork");
        kitchenCounterItems.put(16, "KitchenKnife");
        kitchenCounterItems.put(17, "ButterKnife");
        kitchenCounterItems.put(18, "BreadKnife");
        kitchenCounterItems.put(19, "DishCloth");
        kitchenCounterItems.put(20, "RollingPin");
        kitchenCounterItems.put(21, "EmptyJar");
        kitchenCounterItems.put(22, "Bowl");
        kitchenCounterItems.put(23, "MugWhite");
        kitchenCounterItems.put(24, "MugRed");
        kitchenCounterItems.put(25, "Mugl");
        kitchenCounterItems.put(26, "WaterPot");
        kitchenCounterItems.put(27, "WaterSaucepan");
        kitchenCounterItems.put(28, "PotOfSoup");
        kitchenCounterItems.put(29, "StewBowl");
        kitchenCounterItems.put(30, "SoupBowl");
        kitchenCounterItems.put(31, "WaterSaucepanPasta");
        kitchenCounterItems.put(32, "WaterSaucepanRice");
        kitchenStoveItems.put(1, "WaterSaucepanRice");
        kitchenStoveItems.put(2, "WaterSaucepanPasta");
        kitchenStoveItems.put(3, "WaterPot");
        kitchenStoveItems.put(4, "PotOfSoup");
        kitchenStoveItems.put(5, "WaterSaucepan");
        kitchenStoveItems.put(6, "PotOfStew");
        kitchenStoveItems.put(7, "PastaPot");
        kitchenStoveItems.put(8, "RicePot");
        bathroomSinkItems.put(1, "Comb");
        bathroomSinkItems.put(2, "Cologne");
        bathroomSinkItems.put(3, "Antibiotics");
        bathroomSinkItems.put(4, "Bandage");
        bathroomSinkItems.put(5, "Pills");
        bathroomSinkItems.put(6, "PillsAntiDep");
        bathroomSinkItems.put(7, "PillsBeta");
        bathroomSinkItems.put(8, "PillsSleepingTablets");
        bathroomSinkItems.put(9, "PillsVitamins");
        bathroomSinkItems.put(10, "Lipstick");
        bathroomSinkItems.put(11, "MakeupEyeshadow");
        bathroomSinkItems.put(12, "MakeupFoundation");
        bathroomSinkItems.put(13, "Perfume");
        bathroomSinkItems.put(14, "Razor");
        bathroomSinkItems.put(15, "Toothbrush");
        bathroomSinkItems.put(16, "Toothpaste");
        bathroomSinkItems.put(17, "Tweezers");
    }

    public ArrayList<RandomizedDeadSurvivorBase> getSurvivorStories() {
        return this.deadSurvivorsStory;
    }

    public ArrayList<String> getSurvivorProfession() {
        return this.specificProfessionDistribution;
    }

    public static ArrayList<String> getUniqueRDSSpawned() {
        return uniqueRDSSpawned;
    }
}

