/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBBar
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (int j = buildingDef.y - 1; j < buildingDef.y2 + 1; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null || !this.roomValid(isoGridSquare)) continue;
                    for (int i2 = 0; i2 < isoGridSquare.getObjects().size(); ++i2) {
                        IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                        if (isoObject.getSprite() != null && isoObject.getSprite().getName() != null && (isoObject.getSprite().getName().equals("recreational_01_6") || isoObject.getSprite().getName().equals("recreational_01_7"))) {
                            if (Rand.NextBool(3)) {
                                this.addWorldItem("PoolBall", isoGridSquare, isoObject);
                            }
                            if (!Rand.NextBool(3)) continue;
                            this.addWorldItem("Poolcue", isoGridSquare, isoObject);
                            continue;
                        }
                        if (!isoObject.isTableSurface() || !Rand.NextBool(2)) continue;
                        if (Rand.NextBool(3)) {
                            this.addWorldItem("Cigarettes", isoGridSquare, isoObject);
                            if (Rand.NextBool(2)) {
                                this.addWorldItem("Lighter", isoGridSquare, isoObject);
                            }
                        }
                        int n = Rand.Next(7);
                        switch (n) {
                            case 0: {
                                this.addWorldItem("WhiskeyFull", isoGridSquare, isoObject);
                                break;
                            }
                            case 1: {
                                this.addWorldItem("Wine", isoGridSquare, isoObject);
                                break;
                            }
                            case 2: {
                                this.addWorldItem("Wine2", isoGridSquare, isoObject);
                                break;
                            }
                            case 3: {
                                this.addWorldItem("BeerCan", isoGridSquare, isoObject);
                                break;
                            }
                            case 4: {
                                this.addWorldItem("BeerBottle", isoGridSquare, isoObject);
                            }
                        }
                        if (Rand.NextBool(3)) {
                            int n2 = Rand.Next(7);
                            switch (n2) {
                                case 0: {
                                    this.addWorldItem("Crisps", isoGridSquare, isoObject);
                                    break;
                                }
                                case 1: {
                                    this.addWorldItem("Crisps2", isoGridSquare, isoObject);
                                    break;
                                }
                                case 2: {
                                    this.addWorldItem("Crisps3", isoGridSquare, isoObject);
                                    break;
                                }
                                case 3: {
                                    this.addWorldItem("Crisps4", isoGridSquare, isoObject);
                                    break;
                                }
                                case 4: {
                                    this.addWorldItem("Peanuts", isoGridSquare, isoObject);
                                }
                            }
                        }
                        if (!Rand.NextBool(4)) continue;
                        this.addWorldItem("CardDeck", isoGridSquare, isoObject);
                    }
                    if (!Rand.NextBool(20) || isoGridSquare.getRoom() == null || !isoGridSquare.getRoom().getName().equals("bar") || isoGridSquare.getObjects().size() != 1 || !Rand.NextBool(8)) continue;
                    this.addWorldItem("Dart", isoGridSquare, null);
                }
            }
        }
    }

    public boolean roomValid(IsoGridSquare isoGridSquare) {
        return isoGridSquare.getRoom() != null && "bar".equals(isoGridSquare.getRoom().getName());
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        return buildingDef.getRoom("bar") != null && buildingDef.getRoom("stripclub") == null || bl;
    }

    public RBBar() {
        this.name = "Bar";
        this.setAlwaysDo(true);
    }
}

