/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.scripting;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import zombie.GameTime;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.radio.ChannelCategory;
import zombie.radio.RadioData;
import zombie.radio.ZomboidRadio;
import zombie.radio.scripting.RadioBroadCast;
import zombie.radio.scripting.RadioLine;
import zombie.radio.scripting.RadioScript;

public class RadioChannel {
    private String GUID;
    private RadioData radioData;
    private boolean isTimeSynced = false;
    private Map<String, RadioScript> scripts = new HashMap<String, RadioScript>();
    private int frequency = -1;
    private String name = "Unnamed channel";
    private boolean isTv = false;
    private ChannelCategory category = ChannelCategory.Undefined;
    private boolean playerIsListening = false;
    private RadioScript currentScript = null;
    private int currentScriptLoop = 1;
    private int currentScriptMaxLoops = 1;
    private RadioBroadCast airingBroadcast = null;
    private float airCounter = 0.0f;
    private String lastAiredLine = "";
    private String lastBroadcastID = null;
    private float airCounterMultiplier = 1.0f;
    private boolean louisvilleObfuscate = false;
    float minmod = 1.5f;
    float maxmod = 5.0f;

    public RadioChannel(String string, int n, ChannelCategory channelCategory) {
        this(string, n, channelCategory, UUID.randomUUID().toString());
    }

    public RadioChannel(String string, int n, ChannelCategory channelCategory, String string2) {
        this.name = string;
        this.frequency = n;
        this.category = channelCategory;
        this.isTv = this.category == ChannelCategory.Television;
        this.GUID = string2;
    }

    public String getGUID() {
        return this.GUID;
    }

    public int GetFrequency() {
        return this.frequency;
    }

    public String GetName() {
        return this.name;
    }

    public boolean IsTv() {
        return this.isTv;
    }

    public ChannelCategory GetCategory() {
        return this.category;
    }

    public RadioScript getCurrentScript() {
        return this.currentScript;
    }

    public RadioBroadCast getAiringBroadcast() {
        return this.airingBroadcast;
    }

    public String getLastAiredLine() {
        return this.lastAiredLine;
    }

    public int getCurrentScriptLoop() {
        return this.currentScriptLoop;
    }

    public int getCurrentScriptMaxLoops() {
        return this.currentScriptMaxLoops;
    }

    public String getLastBroadcastID() {
        return this.lastBroadcastID;
    }

    public RadioData getRadioData() {
        return this.radioData;
    }

    public void setRadioData(RadioData radioData) {
        this.radioData = radioData;
    }

    public boolean isTimeSynced() {
        return this.isTimeSynced;
    }

    public void setTimeSynced(boolean bl) {
        this.isTimeSynced = bl;
    }

    public boolean isVanilla() {
        return this.radioData == null || this.radioData.isVanilla();
    }

    public void setLouisvilleObfuscate(boolean bl) {
        this.louisvilleObfuscate = bl;
    }

    public void LoadAiringBroadcast(String string, int n) {
        if (this.currentScript != null) {
            this.airingBroadcast = this.currentScript.getBroadcastWithID(string);
            if (n < 0) {
                this.airingBroadcast = null;
            }
            if (this.airingBroadcast != null && n >= 0) {
                this.airingBroadcast.resetLineCounter();
                this.airingBroadcast.setCurrentLineNumber(n);
                this.airCounter = 120.0f;
                this.playerIsListening = true;
            }
        }
    }

    public void SetPlayerIsListening(boolean bl) {
        this.playerIsListening = bl;
        if (this.playerIsListening && this.airingBroadcast == null && this.currentScript != null) {
            this.airingBroadcast = this.currentScript.getValidAirBroadcast();
            if (this.airingBroadcast != null) {
                this.airingBroadcast.resetLineCounter();
            }
            this.airCounter = 0.0f;
        }
    }

    public boolean GetPlayerIsListening() {
        return this.playerIsListening;
    }

    public void setActiveScriptNull() {
        this.currentScript = null;
        this.airingBroadcast = null;
    }

    public void setActiveScript(String string, int n) {
        this.setActiveScript(string, n, 1, -1);
    }

    public void setActiveScript(String string, int n, int n2, int n3) {
        if (string != null && this.scripts.containsKey(string)) {
            this.currentScript = this.scripts.get(string);
            if (this.currentScript != null) {
                this.currentScript.Reset();
                this.currentScript.setStartDayStamp(n);
                this.currentScriptLoop = n2;
                if (n3 == -1) {
                    int n4;
                    int n5 = this.currentScript.getLoopMin();
                    n3 = n5 == (n4 = this.currentScript.getLoopMax()) || n5 > n4 ? n5 : Rand.Next(n5, n4);
                }
                this.currentScriptMaxLoops = n3;
                if (DebugLog.isEnabled(DebugType.Radio)) {
                    DebugLog.Radio.println("Script: " + string + ", day = " + n + ", minloops = " + this.currentScript.getLoopMin() + ", maxloops = " + this.currentScriptMaxLoops);
                }
            }
        }
    }

    private void getNextScript(int n) {
        if (this.currentScript != null) {
            if (this.currentScriptLoop < this.currentScriptMaxLoops) {
                ++this.currentScriptLoop;
                this.currentScript.Reset();
                this.currentScript.setStartDayStamp(n);
            } else {
                RadioScript.ExitOption exitOption = this.currentScript.getNextScript();
                this.currentScript = null;
                if (exitOption != null) {
                    this.setActiveScript(exitOption.getScriptname(), n + exitOption.getStartDelay());
                }
            }
        }
    }

    public void UpdateScripts(int n, int n2) {
        this.playerIsListening = false;
        if (this.currentScript != null && !this.currentScript.UpdateScript(n)) {
            this.getNextScript(n2 + 1);
        }
    }

    public void update() {
        if (this.airingBroadcast != null) {
            this.airCounter -= 1.25f * GameTime.getInstance().getMultiplier();
            if (this.airCounter < 0.0f) {
                RadioLine radioLine = this.airingBroadcast.getNextLine();
                if (radioLine == null) {
                    this.lastBroadcastID = this.airingBroadcast.getID();
                    this.airingBroadcast = null;
                    this.playerIsListening = false;
                } else {
                    this.lastAiredLine = radioLine.getText();
                    if (!ZomboidRadio.DISABLE_BROADCASTING) {
                        String string = radioLine.getText();
                        if (this.louisvilleObfuscate && ZomboidRadio.LOUISVILLE_OBFUSCATION) {
                            string = ZomboidRadio.getInstance().scrambleString(string, 85, true, null);
                            ZomboidRadio.getInstance().SendTransmission(0, 0, this.frequency, string, null, "", 0.7f, 0.5f, 0.5f, -1, this.isTv);
                        } else {
                            ZomboidRadio.getInstance().SendTransmission(0, 0, this.frequency, string, null, radioLine.getEffectsString(), radioLine.getR(), radioLine.getG(), radioLine.getB(), -1, this.isTv);
                        }
                    }
                    if (radioLine.isCustomAirTime()) {
                        this.airCounter = radioLine.getAirTime() * 60.0f;
                    } else {
                        this.airCounter = (float)radioLine.getText().length() / 10.0f * 60.0f;
                        if (this.airCounter < 60.0f * this.minmod) {
                            this.airCounter = 60.0f * this.minmod;
                        } else if (this.airCounter > 60.0f * this.maxmod) {
                            this.airCounter = 60.0f * this.maxmod;
                        }
                        this.airCounter *= this.airCounterMultiplier;
                    }
                }
            }
        }
    }

    public void AddRadioScript(RadioScript radioScript) {
        if (radioScript != null && !this.scripts.containsKey(radioScript.GetName())) {
            this.scripts.put(radioScript.GetName(), radioScript);
        } else {
            String string = radioScript != null ? radioScript.GetName() : "null";
            DebugLog.log(DebugType.Radio, "Error while attempting to add script (" + string + "), null or name already exists.");
        }
    }

    public RadioScript getRadioScript(String string) {
        if (string != null && this.scripts.containsKey(string)) {
            return this.scripts.get(string);
        }
        return null;
    }

    public void setAiringBroadcast(RadioBroadCast radioBroadCast) {
        this.airingBroadcast = radioBroadCast;
    }

    public float getAirCounterMultiplier() {
        return this.airCounterMultiplier;
    }

    public void setAirCounterMultiplier(float f) {
        this.airCounterMultiplier = PZMath.clamp(f, 0.1f, 10.0f);
    }
}

