/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.script;

import java.util.ArrayList;
import java.util.List;
import zombie.radio.globals.CompareMethod;
import zombie.radio.globals.CompareResult;
import zombie.radio.globals.RadioGlobal;
import zombie.radio.script.ConditionIter;
import zombie.radio.script.OperatorType;

public final class ConditionContainer
implements ConditionIter {
    private List<ConditionIter> conditions = new ArrayList<ConditionIter>();
    private OperatorType operatorType = OperatorType.NONE;

    public ConditionContainer() {
        this(OperatorType.NONE);
    }

    public ConditionContainer(OperatorType operatorType) {
        this.operatorType = operatorType;
    }

    @Override
    public CompareResult Evaluate() {
        boolean bl = false;
        for (int i = 0; i < this.conditions.size(); ++i) {
            CompareResult compareResult;
            ConditionIter conditionIter = this.conditions.get(i);
            CompareResult compareResult2 = compareResult = conditionIter != null ? conditionIter.Evaluate() : CompareResult.Invalid;
            if (compareResult.equals((Object)CompareResult.Invalid)) {
                return compareResult;
            }
            OperatorType operatorType = conditionIter.getNextOperator();
            if (i == this.conditions.size() - 1) {
                return !operatorType.equals((Object)OperatorType.NONE) ? CompareResult.Invalid : (!bl ? compareResult : CompareResult.False);
            }
            if (operatorType.equals((Object)OperatorType.OR)) {
                if (!bl && compareResult.equals((Object)CompareResult.True)) {
                    return compareResult;
                }
                bl = false;
                continue;
            }
            if (operatorType.equals((Object)OperatorType.AND)) {
                bl = bl || compareResult.equals((Object)CompareResult.False);
                continue;
            }
            if (!operatorType.equals((Object)OperatorType.NONE)) continue;
            return CompareResult.Invalid;
        }
        return CompareResult.Invalid;
    }

    @Override
    public OperatorType getNextOperator() {
        return this.operatorType;
    }

    @Override
    public void setNextOperator(OperatorType operatorType) {
        this.operatorType = operatorType;
    }

    public void Add(ConditionContainer conditionContainer) {
        this.conditions.add(conditionContainer);
    }

    public void Add(RadioGlobal radioGlobal, RadioGlobal radioGlobal2, CompareMethod compareMethod, OperatorType operatorType) {
        Condition condition = new Condition(radioGlobal, radioGlobal2, compareMethod, operatorType);
        this.conditions.add(condition);
    }

    private static final class Condition
    implements ConditionIter {
        private OperatorType operatorType = OperatorType.NONE;
        private CompareMethod compareMethod;
        private RadioGlobal valueA;
        private RadioGlobal valueB;

        public Condition(RadioGlobal radioGlobal, RadioGlobal radioGlobal2, CompareMethod compareMethod) {
            this(radioGlobal, radioGlobal2, compareMethod, OperatorType.NONE);
        }

        public Condition(RadioGlobal radioGlobal, RadioGlobal radioGlobal2, CompareMethod compareMethod, OperatorType operatorType) {
            this.valueA = radioGlobal;
            this.valueB = radioGlobal2;
            this.operatorType = operatorType;
            this.compareMethod = compareMethod;
        }

        @Override
        public CompareResult Evaluate() {
            if (this.valueA != null && this.valueB != null) {
                return this.valueA.compare(this.valueB, this.compareMethod);
            }
            return CompareResult.Invalid;
        }

        @Override
        public OperatorType getNextOperator() {
            return this.operatorType;
        }

        @Override
        public void setNextOperator(OperatorType operatorType) {
            this.operatorType = operatorType;
        }
    }
}

