/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.media;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.radio.media.MediaData;
import zombie.world.WorldDictionary;

public class RecordedMedia {
    public static boolean DISABLE_LINE_LEARNING = false;
    private static final int SPAWN_COMMON = 0;
    private static final int SPAWN_RARE = 1;
    private static final int SPAWN_EXCEPTIONAL = 2;
    public static final int VERSION1 = 1;
    public static final int VERSION2 = 2;
    public static final int VERSION = 2;
    public static final String SAVE_FILE = "recorded_media.bin";
    private final ArrayList<String> indexes = new ArrayList();
    private static final ArrayList<String> indexesFromServer = new ArrayList();
    private final Map<String, MediaData> mediaDataMap = new HashMap<String, MediaData>();
    private final Map<String, ArrayList<MediaData>> categorizedMap = new HashMap<String, ArrayList<MediaData>>();
    private final ArrayList<String> categories = new ArrayList();
    private final ArrayList<String> legacyListenedLines = new ArrayList();
    private final HashSet<Short> homeVhsSpawned = new HashSet();
    private final Map<Integer, ArrayList<MediaData>> retailVhsSpawnTable = new HashMap<Integer, ArrayList<MediaData>>();
    private final Map<Integer, ArrayList<MediaData>> retailCdSpawnTable = new HashMap<Integer, ArrayList<MediaData>>();
    private boolean REQUIRES_SAVING = true;

    public void init() {
        try {
            this.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LuaEventManager.triggerEvent("OnInitRecordedMedia", this);
        this.retailCdSpawnTable.put(0, new ArrayList());
        this.retailCdSpawnTable.put(1, new ArrayList());
        this.retailCdSpawnTable.put(2, new ArrayList());
        this.retailVhsSpawnTable.put(0, new ArrayList());
        this.retailVhsSpawnTable.put(1, new ArrayList());
        this.retailVhsSpawnTable.put(2, new ArrayList());
        ArrayList<MediaData> arrayList = this.categorizedMap.get("CDs");
        if (arrayList != null) {
            for (MediaData mediaData : arrayList) {
                if (mediaData.getSpawning() == 1) {
                    this.retailCdSpawnTable.get(1).add(mediaData);
                    continue;
                }
                if (mediaData.getSpawning() == 2) {
                    this.retailCdSpawnTable.get(2).add(mediaData);
                    continue;
                }
                this.retailCdSpawnTable.get(0).add(mediaData);
            }
        } else {
            DebugLog.General.error("categorizedMap with CDs is empty");
        }
        arrayList = this.categorizedMap.get("Retail-VHS");
        if (arrayList != null) {
            for (MediaData mediaData : arrayList) {
                if (mediaData.getSpawning() == 1) {
                    this.retailVhsSpawnTable.get(1).add(mediaData);
                    continue;
                }
                if (mediaData.getSpawning() == 2) {
                    this.retailVhsSpawnTable.get(2).add(mediaData);
                    continue;
                }
                this.retailVhsSpawnTable.get(0).add(mediaData);
            }
        } else {
            DebugLog.General.error("categorizedMap with Retail-VHS is empty");
        }
        try {
            this.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static byte getMediaTypeForCategory(String string) {
        if (string == null) {
            return -1;
        }
        return string.equalsIgnoreCase("cds") ? (byte)0 : 1;
    }

    public ArrayList<String> getCategories() {
        return this.categories;
    }

    public ArrayList<MediaData> getAllMediaForType(byte by) {
        ArrayList<MediaData> arrayList = new ArrayList<MediaData>();
        for (Map.Entry<String, MediaData> entry : this.mediaDataMap.entrySet()) {
            if (entry.getValue().getMediaType() != by) continue;
            arrayList.add(entry.getValue());
        }
        arrayList.sort(new MediaNameSorter());
        return arrayList;
    }

    public ArrayList<MediaData> getAllMediaForCategory(String string) {
        ArrayList<MediaData> arrayList = new ArrayList<MediaData>();
        for (Map.Entry<String, MediaData> entry : this.mediaDataMap.entrySet()) {
            if (!string.equalsIgnoreCase(entry.getValue().getCategory())) continue;
            arrayList.add(entry.getValue());
        }
        arrayList.sort(new MediaNameSorter());
        return arrayList;
    }

    public MediaData register(String string, String string2, String string3, int n) {
        short s;
        if (this.mediaDataMap.containsKey(string2)) {
            DebugLog.log("RecordeMedia -> MediaData id already exists : " + string2);
            return null;
        }
        if (n < 0) {
            n = 0;
        }
        MediaData mediaData = new MediaData(string2, string3, n);
        this.mediaDataMap.put(string2, mediaData);
        mediaData.setCategory(string);
        if (!this.categorizedMap.containsKey(string)) {
            this.categorizedMap.put(string, new ArrayList());
            this.categories.add(string);
        }
        this.categorizedMap.get(string).add(mediaData);
        if (this.indexes.contains(string2)) {
            s = (short)this.indexes.indexOf(string2);
        } else {
            s = (short)this.indexes.size();
            this.indexes.add(string2);
        }
        mediaData.setIndex(s);
        this.REQUIRES_SAVING = true;
        return mediaData;
    }

    public MediaData getMediaDataFromIndex(short s) {
        if (s >= 0 && s < this.indexes.size()) {
            return this.getMediaData(this.indexes.get(s));
        }
        return null;
    }

    public short getIndexForMediaData(MediaData mediaData) {
        return (short)this.indexes.indexOf(mediaData.getId());
    }

    public MediaData getMediaData(String string) {
        return this.mediaDataMap.get(string);
    }

    public MediaData getRandomFromCategory(String string) {
        if (this.categorizedMap.containsKey(string)) {
            ArrayList<MediaData> arrayList;
            int n;
            MediaData mediaData = null;
            if (string.equalsIgnoreCase("cds")) {
                int n2 = Rand.Next(0, 1000);
                if (n2 < 100) {
                    if (this.retailCdSpawnTable.get(2).size() > 0) {
                        mediaData = this.retailCdSpawnTable.get(2).get(Rand.Next(0, this.retailCdSpawnTable.get(2).size()));
                    }
                } else if (n2 < 400) {
                    if (this.retailCdSpawnTable.get(1).size() > 0) {
                        mediaData = this.retailCdSpawnTable.get(1).get(Rand.Next(0, this.retailCdSpawnTable.get(1).size()));
                    }
                } else {
                    mediaData = this.retailCdSpawnTable.get(0).get(Rand.Next(0, this.retailCdSpawnTable.get(0).size()));
                }
                if (mediaData != null) {
                    return mediaData;
                }
                return this.retailCdSpawnTable.get(0).get(Rand.Next(0, this.retailCdSpawnTable.get(0).size()));
            }
            if (string.equalsIgnoreCase("retail-vhs")) {
                int n3 = Rand.Next(0, 1000);
                if (n3 < 100) {
                    if (this.retailVhsSpawnTable.get(2).size() > 0) {
                        mediaData = this.retailVhsSpawnTable.get(2).get(Rand.Next(0, this.retailVhsSpawnTable.get(2).size()));
                    }
                } else if (n3 < 400) {
                    if (this.retailVhsSpawnTable.get(1).size() > 0) {
                        mediaData = this.retailVhsSpawnTable.get(1).get(Rand.Next(0, this.retailVhsSpawnTable.get(1).size()));
                    }
                } else {
                    mediaData = this.retailVhsSpawnTable.get(0).get(Rand.Next(0, this.retailVhsSpawnTable.get(0).size()));
                }
                if (mediaData != null) {
                    return mediaData;
                }
                return this.retailVhsSpawnTable.get(0).get(Rand.Next(0, this.retailVhsSpawnTable.get(0).size()));
            }
            if (string.equalsIgnoreCase("home-vhs") && (n = Rand.Next(0, 1000)) < 200 && !this.homeVhsSpawned.contains((mediaData = (arrayList = this.categorizedMap.get("Home-VHS")).get(Rand.Next(0, arrayList.size()))).getIndex())) {
                this.homeVhsSpawned.add(mediaData.getIndex());
                this.REQUIRES_SAVING = true;
                return mediaData;
            }
        }
        return null;
    }

    public void load() throws IOException {
        this.indexes.clear();
        if (GameClient.bClient) {
            this.indexes.addAll(indexesFromServer);
            indexesFromServer.clear();
        }
        if (Core.getInstance().isNoSave()) {
            return;
        }
        String string = ZomboidFileSystem.instance.getFileNameInCurrentSave(SAVE_FILE);
        File file = new File(string);
        if (!file.exists()) {
            if (!WorldDictionary.isIsNewGame()) {
                DebugLog.log("RecordedMedia data file is missing from world folder.");
            }
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string2;
            int n;
            DebugLog.log("Loading Recorded Media:" + string);
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)file.length());
            byteBuffer.clear();
            int n2 = fileInputStream.read(byteBuffer.array());
            byteBuffer.limit(n2);
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            for (n = 0; n < n4; ++n) {
                string2 = GameWindow.ReadString(byteBuffer);
                if (GameClient.bClient) continue;
                this.indexes.add(string2);
            }
            if (n3 == 1) {
                n4 = byteBuffer.getInt();
                for (n = 0; n < n4; ++n) {
                    string2 = GameWindow.ReadString(byteBuffer);
                    this.legacyListenedLines.add(string2);
                }
            }
            n4 = byteBuffer.getInt();
            for (n = 0; n < n4; ++n) {
                this.homeVhsSpawned.add(byteBuffer.getShort());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save() throws IOException {
        if (Core.getInstance().isNoSave() || !this.REQUIRES_SAVING) {
            return;
        }
        try {
            int n = 0;
            n += this.indexes.size() * 40;
            n += this.homeVhsSpawned.size() * 2;
            byte[] byArray = new byte[n += 512];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putInt(2);
            byteBuffer.putInt(this.indexes.size());
            for (int i = 0; i < this.indexes.size(); ++i) {
                GameWindow.WriteString(byteBuffer, this.indexes.get(i));
            }
            byteBuffer.putInt(this.homeVhsSpawned.size());
            Short[] shortArray = this.homeVhsSpawned.toArray(new Short[0]);
            for (int i = 0; i < shortArray.length; ++i) {
                byteBuffer.putShort(shortArray[i]);
            }
            byteBuffer.flip();
            String string = ZomboidFileSystem.instance.getFileNameInCurrentSave(SAVE_FILE);
            File file = new File(string);
            DebugLog.log("Saving Recorded Media:" + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.getChannel().truncate(0L);
            fileOutputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.REQUIRES_SAVING = false;
    }

    public static String toAscii(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        for (char c : string.toCharArray()) {
            if (c > '\u007f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public boolean hasListenedToLine(IsoPlayer isoPlayer, String string) {
        return isoPlayer.isKnownMediaLine(string);
    }

    public boolean hasListenedToAll(IsoPlayer isoPlayer, MediaData mediaData) {
        if (isoPlayer == null) {
            isoPlayer = IsoPlayer.players[0];
        }
        if (isoPlayer == null || mediaData == null) {
            return false;
        }
        for (int i = 0; i < mediaData.getLineCount(); ++i) {
            MediaData.MediaLineData mediaLineData = mediaData.getLine(i);
            if (isoPlayer.isKnownMediaLine(mediaLineData.getTextGuid())) continue;
            return false;
        }
        return mediaData.getLineCount() > 0;
    }

    public void sendRequestData(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.indexes.size());
        for (int i = 0; i < this.indexes.size(); ++i) {
            GameWindow.WriteStringUTF(byteBuffer, this.indexes.get(i));
        }
    }

    public static void receiveRequestData(ByteBuffer byteBuffer) {
        indexesFromServer.clear();
        int n = byteBuffer.getInt();
        for (int i = 0; i < n; ++i) {
            indexesFromServer.add(GameWindow.ReadStringUTF(byteBuffer));
        }
    }

    public void handleLegacyListenedLines(IsoPlayer isoPlayer) {
        if (this.legacyListenedLines.isEmpty()) {
            return;
        }
        if (isoPlayer != null) {
            for (String string : this.legacyListenedLines) {
                isoPlayer.addKnownMediaLine(string);
            }
        }
        this.legacyListenedLines.clear();
    }

    public static class MediaNameSorter
    implements Comparator<MediaData> {
        @Override
        public int compare(MediaData mediaData, MediaData mediaData2) {
            return mediaData.getTranslatedItemDisplayName().compareToIgnoreCase(mediaData2.getTranslatedItemDisplayName());
        }
    }
}

