/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.globals;

import zombie.radio.globals.CompareMethod;
import zombie.radio.globals.CompareResult;
import zombie.radio.globals.EditGlobalOps;
import zombie.radio.globals.RadioGlobal;
import zombie.radio.globals.RadioGlobalType;

public final class RadioGlobalFloat
extends RadioGlobal<Float> {
    public RadioGlobalFloat(float f) {
        super(Float.valueOf(f), RadioGlobalType.Float);
    }

    public RadioGlobalFloat(String string, float f) {
        super(string, Float.valueOf(f), RadioGlobalType.Float);
    }

    public float getValue() {
        return ((Float)this.value).floatValue();
    }

    public void setValue(float f) {
        this.value = Float.valueOf(f);
    }

    @Override
    public String getString() {
        return ((Float)this.value).toString();
    }

    @Override
    public CompareResult compare(RadioGlobal radioGlobal, CompareMethod compareMethod) {
        if (radioGlobal instanceof RadioGlobalFloat) {
            RadioGlobalFloat radioGlobalFloat = (RadioGlobalFloat)radioGlobal;
            switch (compareMethod) {
                case equals: {
                    return ((Float)this.value).floatValue() == radioGlobalFloat.getValue() ? CompareResult.True : CompareResult.False;
                }
                case notequals: {
                    return ((Float)this.value).floatValue() != radioGlobalFloat.getValue() ? CompareResult.True : CompareResult.False;
                }
                case lessthan: {
                    return ((Float)this.value).floatValue() < radioGlobalFloat.getValue() ? CompareResult.True : CompareResult.False;
                }
                case morethan: {
                    return ((Float)this.value).floatValue() > radioGlobalFloat.getValue() ? CompareResult.True : CompareResult.False;
                }
                case lessthanorequals: {
                    return ((Float)this.value).floatValue() <= radioGlobalFloat.getValue() ? CompareResult.True : CompareResult.False;
                }
                case morethanorequals: {
                    return ((Float)this.value).floatValue() >= radioGlobalFloat.getValue() ? CompareResult.True : CompareResult.False;
                }
            }
            return CompareResult.Invalid;
        }
        return CompareResult.Invalid;
    }

    @Override
    public boolean setValue(RadioGlobal radioGlobal, EditGlobalOps editGlobalOps) {
        if (radioGlobal instanceof RadioGlobalFloat) {
            RadioGlobalFloat radioGlobalFloat = (RadioGlobalFloat)radioGlobal;
            switch (editGlobalOps) {
                case set: {
                    this.value = Float.valueOf(radioGlobalFloat.getValue());
                    return true;
                }
                case add: {
                    this.value = Float.valueOf(((Float)this.value).floatValue() + radioGlobalFloat.getValue());
                    return true;
                }
                case sub: {
                    this.value = Float.valueOf(((Float)this.value).floatValue() - radioGlobalFloat.getValue());
                    return true;
                }
            }
        }
        return false;
    }
}

