/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.StorySounds;

import fmod.fmod.FMODManager;
import fmod.javafmod;
import java.util.ArrayList;
import java.util.Stack;
import zombie.GameSounds;
import zombie.SoundManager;
import zombie.audio.GameSound;
import zombie.audio.GameSoundClip;
import zombie.characters.IsoPlayer;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.Vector2;

public final class StoryEmitter {
    public int max = -1;
    public float volumeMod = 1.0f;
    public boolean coordinate3D = true;
    public Stack<Sound> SoundStack = new Stack();
    public ArrayList<Sound> Instances = new ArrayList();
    public ArrayList<Sound> ToStart = new ArrayList();
    private Vector2 soundVect = new Vector2();
    private Vector2 playerVect = new Vector2();

    public int stopSound(long l) {
        return javafmod.FMOD_Channel_Stop(l);
    }

    public long playSound(String string, float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.max != -1 && this.max <= this.Instances.size() + this.ToStart.size()) {
            return 0L;
        }
        GameSound gameSound = GameSounds.getSound(string);
        if (gameSound == null) {
            return 0L;
        }
        GameSoundClip gameSoundClip = gameSound.getRandomClip();
        long l = FMODManager.instance.loadSound(string);
        if (l == 0L) {
            return 0L;
        }
        Sound sound = this.SoundStack.isEmpty() ? new Sound() : this.SoundStack.pop();
        sound.minRange = f5;
        sound.maxRange = f6;
        sound.x = f2;
        sound.y = f3;
        sound.z = f4;
        sound.volume = SoundManager.instance.getSoundVolume() * f * this.volumeMod;
        sound.sound = l;
        sound.channel = javafmod.FMOD_System_PlaySound(l, true);
        this.ToStart.add(sound);
        javafmod.FMOD_Channel_Set3DAttributes(sound.channel, sound.x - IsoPlayer.getInstance().x, sound.y - IsoPlayer.getInstance().y, sound.z - IsoPlayer.getInstance().z, 0.0f, 0.0f, 0.0f);
        javafmod.FMOD_Channel_Set3DOcclusion(sound.channel, 1.0f, 1.0f);
        if (IsoPlayer.getInstance() != null && IsoPlayer.getInstance().Traits.Deaf.isSet()) {
            javafmod.FMOD_Channel_SetVolume(sound.channel, 0.0f);
        } else {
            javafmod.FMOD_Channel_SetVolume(sound.channel, sound.volume);
        }
        return sound.channel;
    }

    public void tick() {
        Sound sound;
        int n;
        for (n = 0; n < this.ToStart.size(); ++n) {
            sound = this.ToStart.get(n);
            javafmod.FMOD_Channel_SetPaused(sound.channel, false);
            this.Instances.add(sound);
        }
        this.ToStart.clear();
        for (n = 0; n < this.Instances.size(); ++n) {
            sound = this.Instances.get(n);
            if (!javafmod.FMOD_Channel_IsPlaying(sound.channel)) {
                this.SoundStack.push(sound);
                this.Instances.remove(sound);
                --n;
                continue;
            }
            float f = IsoUtils.DistanceManhatten(sound.x, sound.y, IsoPlayer.getInstance().x, IsoPlayer.getInstance().y, sound.z, IsoPlayer.getInstance().z) / sound.maxRange;
            if (f > 1.0f) {
                f = 1.0f;
            }
            if (!this.coordinate3D) {
                javafmod.FMOD_Channel_Set3DAttributes(sound.channel, Math.abs(sound.x - IsoPlayer.getInstance().x), Math.abs(sound.y - IsoPlayer.getInstance().y), Math.abs(sound.z - IsoPlayer.getInstance().z), 0.0f, 0.0f, 0.0f);
            } else {
                javafmod.FMOD_Channel_Set3DAttributes(sound.channel, Math.abs(sound.x - IsoPlayer.getInstance().x), Math.abs(sound.z - IsoPlayer.getInstance().z), Math.abs(sound.y - IsoPlayer.getInstance().y), 0.0f, 0.0f, 0.0f);
            }
            javafmod.FMOD_System_SetReverbDefault(0, FMODManager.FMOD_PRESET_MOUNTAINS);
            javafmod.FMOD_Channel_SetReverbProperties(sound.channel, 0, 1.0f);
            javafmod.FMOD_Channel_Set3DMinMaxDistance(sound.channel, sound.minRange, sound.maxRange);
            float f2 = 0.0f;
            float f3 = 0.0f;
            IsoGridSquare isoGridSquare = IsoPlayer.getInstance().getCurrentSquare();
            this.soundVect.set(sound.x, sound.y);
            this.playerVect.set(IsoPlayer.getInstance().x, IsoPlayer.getInstance().y);
            float f4 = (float)Math.toDegrees(this.playerVect.angleTo(this.soundVect));
            float f5 = (float)Math.toDegrees(IsoPlayer.getInstance().getForwardDirection().getDirectionNeg());
            if (f5 >= 0.0f && f5 <= 90.0f) {
                f5 = -90.0f - f5;
            } else if (f5 > 90.0f && f5 <= 180.0f) {
                f5 = 90.0f + (180.0f - f5);
            } else if (f5 < 0.0f && f5 >= -90.0f) {
                f5 = 0.0f - (90.0f + f5);
            } else if (f5 < 0.0f && f5 >= -180.0f) {
                f5 = 90.0f - (180.0f + f5);
            }
            float f6 = Math.abs(f4 - f5) % 360.0f;
            float f7 = f6 > 180.0f ? 360.0f - f6 : f6;
            float f8 = (180.0f - f7) / 180.0f;
            f /= 0.4f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            f2 = 0.85f * f * f8;
            f3 = 0.85f * f * f8;
            if (isoGridSquare.getRoom() != null) {
                f2 = 0.75f + 0.1f * f + 0.1f * f8;
                f3 = 0.75f + 0.1f * f + 0.1f * f8;
            }
            javafmod.FMOD_Channel_Set3DOcclusion(sound.channel, f2, f3);
        }
    }

    public static final class Sound {
        public long sound;
        public long channel;
        public float volume;
        public float x;
        public float y;
        public float z;
        public float minRange;
        public float maxRange;
    }
}

