/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import zombie.core.Language;
import zombie.core.Translator;

public final class RadioTranslationData {
    private String filePath;
    private String guid;
    private String language;
    private Language languageEnum;
    private int version = -1;
    private final ArrayList<String> translators = new ArrayList();
    private final Map<String, String> translations = new HashMap<String, String>();

    public RadioTranslationData(String string) {
        this.filePath = string;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getLanguage() {
        return this.language;
    }

    public Language getLanguageEnum() {
        return this.languageEnum;
    }

    public int getVersion() {
        return this.version;
    }

    public int getTranslationCount() {
        return this.translations.size();
    }

    public ArrayList<String> getTranslators() {
        return this.translators;
    }

    public boolean validate() {
        return this.guid != null && this.language != null && this.version >= 0;
    }

    public boolean loadTranslations() {
        boolean bl;
        block11: {
            bl = false;
            if (Translator.getLanguage() != this.languageEnum) {
                System.out.println("Radio translations trying to load language that is not the current language...");
                return false;
            }
            try {
                File file = new File(this.filePath);
                if (!file.exists() || file.isDirectory()) break block11;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filePath), Charset.forName(this.languageEnum.charset())));
                String string = null;
                boolean bl2 = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                while ((string = bufferedReader.readLine()) != null) {
                    String string22;
                    String[] stringArray;
                    Object object;
                    if ((string = string.trim()).equals("[Translations]")) {
                        bl2 = true;
                        continue;
                    }
                    if (!bl2) continue;
                    if (string.equals("[Collection]")) {
                        object = null;
                        while ((string = bufferedReader.readLine()) != null && !(string = string.trim()).equals("[/Collection]")) {
                            stringArray = string.split("=", 2);
                            if (stringArray.length != 2) continue;
                            string22 = stringArray[0].trim();
                            String string3 = stringArray[1].trim();
                            if (string22.equals("text")) {
                                object = string3;
                                continue;
                            }
                            if (!string22.equals("member")) continue;
                            arrayList.add(string3);
                        }
                        if (object != null && arrayList.size() > 0) {
                            for (String string22 : arrayList) {
                                this.translations.put(string22, (String)object);
                            }
                        }
                        arrayList.clear();
                        continue;
                    }
                    if (string.equals("[/Translations]")) {
                        bl = true;
                        break;
                    }
                    object = string.split("=", 2);
                    if (((String[])object).length != 2) continue;
                    stringArray = object[0].trim();
                    string22 = object[1].trim();
                    this.translations.put((String)stringArray, string22);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        }
        return bl;
    }

    public String getTranslation(String string) {
        if (this.translations.containsKey(string)) {
            return this.translations.get(string);
        }
        return null;
    }

    public static RadioTranslationData ReadFile(String string) {
        RadioTranslationData radioTranslationData = new RadioTranslationData(string);
        File file = new File(string);
        if (file.exists() && !file.isDirectory()) {
            try (FileInputStream fileInputStream = new FileInputStream(string);){
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                Object object = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    String string3;
                    String[] stringArray = string2.split("=");
                    if (stringArray.length > 1) {
                        String[] stringArray2;
                        String string4 = stringArray[0].trim();
                        Object object2 = "";
                        for (int i = 1; i < stringArray.length; ++i) {
                            object2 = (String)object2 + stringArray[i];
                        }
                        object2 = ((String)object2).trim();
                        if (string4.equals("guid")) {
                            radioTranslationData.guid = object2;
                        } else if (string4.equals("language")) {
                            radioTranslationData.language = object2;
                        } else if (string4.equals("version")) {
                            radioTranslationData.version = Integer.parseInt((String)object2);
                        } else if (string4.equals("translator") && (stringArray2 = ((String)object2).split(",")).length > 0) {
                            for (String string5 : stringArray2) {
                                radioTranslationData.translators.add(string5);
                            }
                        }
                    }
                    if (!(string3 = string2.trim()).equals("[/Info]")) continue;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean bl = false;
        if (radioTranslationData.language != null) {
            for (Language language : Translator.getAvailableLanguage()) {
                if (!language.toString().equals(radioTranslationData.language)) continue;
                radioTranslationData.languageEnum = language;
                bl = true;
                break;
            }
        }
        if (!bl && radioTranslationData.language != null) {
            System.out.println("Language " + radioTranslationData.language + " not found");
            return null;
        }
        if (radioTranslationData.guid != null && radioTranslationData.language != null && radioTranslationData.version >= 0) {
            return radioTranslationData;
        }
        return null;
    }
}

