/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio;

import java.util.HashMap;
import java.util.Map;
import zombie.core.Color;
import zombie.input.GameKeyboard;
import zombie.radio.scripting.RadioBroadCast;
import zombie.radio.scripting.RadioChannel;
import zombie.radio.scripting.RadioScript;
import zombie.radio.scripting.RadioScriptManager;
import zombie.ui.TextManager;
import zombie.ui.UIFont;

public final class RadioDebugConsole {
    private final HashMap<Integer, Boolean> state = new HashMap();
    private int channelIndex = 0;
    private int testcounter = 0;
    private Color colRed = new Color(255, 0, 0, 255);
    private Color colGreen = new Color(0, 255, 0, 255);
    private Color colWhite = new Color(255, 255, 255, 255);
    private Color colGrey = new Color(150, 150, 150, 255);
    private Color colDyn = new Color(255, 255, 255, 255);
    private int drawY = 0;
    private int drawX = 0;
    private int drawYLine = 20;

    public RadioDebugConsole() {
        this.state.put(12, false);
        this.state.put(13, false);
        this.state.put(53, false);
        this.state.put(26, false);
    }

    public void update() {
        Map<Integer, RadioChannel> map = RadioScriptManager.getInstance().getChannels();
        for (Map.Entry<Integer, Boolean> entry : this.state.entrySet()) {
            boolean bl = GameKeyboard.isKeyDown(entry.getKey());
            if (bl && entry.getValue() != bl) {
                switch (entry.getKey()) {
                    case 12: {
                        --this.channelIndex;
                        if (this.channelIndex >= 0 || map == null) break;
                        this.channelIndex = map.size() - 1;
                        break;
                    }
                    case 13: {
                        ++this.channelIndex;
                        if (map == null || this.channelIndex < map.size()) break;
                        this.channelIndex = 0;
                        break;
                    }
                    case 53: {
                        break;
                    }
                }
            }
            entry.setValue(bl);
        }
    }

    public void render() {
        Map<Integer, RadioChannel> map = RadioScriptManager.getInstance().getChannels();
        if (map == null || map.size() == 0) {
            return;
        }
        if (this.channelIndex < 0) {
            this.channelIndex = 0;
        }
        if (this.channelIndex >= map.size()) {
            this.channelIndex = map.size() - 1;
        }
        this.drawYLine = 20;
        this.drawX = 20;
        this.drawY = 200;
        int n = 150;
        this.DrawLine("Scamble once: ", 0, false, this.colGrey);
        this.AddBlancLine();
        this.DrawLine("Radio Script Manager Debug.", 0, true);
        this.DrawLine("Real Time: ", 0, false, this.colGrey);
        this.DrawLine(RadioDebugConsole.timeStampToString(RadioScriptManager.getInstance().getCurrentTimeStamp()), n, true);
        this.AddBlancLine();
        this.AddBlancLine();
        this.DrawLine("Index: " + (this.channelIndex + 1) + " of " + map.size() + " total channels.", 0, true);
        RadioChannel radioChannel = (RadioChannel)map.values().toArray()[this.channelIndex];
        if (radioChannel != null) {
            this.DrawLine("Selected channel: ", 0, false, this.colGrey);
            this.DrawLine(radioChannel.GetName(), n, true);
            this.DrawLine("Type: ", 0, false, this.colGrey);
            this.DrawLine(radioChannel.IsTv() ? "Television" : "Radio", n, true);
            this.DrawLine("Frequency: ", 0, false, this.colGrey);
            this.DrawLine(Integer.toString(radioChannel.GetFrequency()), n, true);
            this.DrawLine("Category: ", 0, false, this.colGrey);
            this.DrawLine(radioChannel.GetCategory().toString(), n, true);
            this.DrawLine("PlayerListening: ", 0, false, this.colGrey);
            if (radioChannel.GetPlayerIsListening()) {
                this.DrawLine("Yes", n, true, this.colGreen);
            } else {
                this.DrawLine("No", n, true, this.colRed);
            }
            RadioBroadCast radioBroadCast = radioChannel.getAiringBroadcast();
            if (radioBroadCast != null) {
                this.AddBlancLine();
                this.DrawLine("Is airing a broadcast:", 0, true, this.colGreen);
                this.DrawLine("ID: ", 0, false, this.colGrey);
                this.DrawLine(radioBroadCast.getID(), n, true);
                this.DrawLine("StartStamp: ", 0, false, this.colGrey);
                this.DrawLine(RadioDebugConsole.timeStampToString(radioBroadCast.getStartStamp()), n, true);
                this.DrawLine("EndStamp: ", 0, false, this.colGrey);
                this.DrawLine(RadioDebugConsole.timeStampToString(radioBroadCast.getEndStamp()), n, true);
                if (radioBroadCast.getCurrentLine() != null) {
                    this.colDyn.r = radioBroadCast.getCurrentLine().getR();
                    this.colDyn.g = radioBroadCast.getCurrentLine().getG();
                    this.colDyn.b = radioBroadCast.getCurrentLine().getB();
                    if (radioBroadCast.getCurrentLine().getText() != null) {
                        this.DrawLine("Next line to be aired: ", 0, false, this.colGrey);
                        this.DrawLine(radioBroadCast.PeekNextLineText(), n, true, this.colDyn);
                    }
                }
            }
            this.AddBlancLine();
            RadioScript radioScript = radioChannel.getCurrentScript();
            if (radioScript != null) {
                this.DrawLine("Currently working on RadioScript: ", 0, true);
                this.DrawLine("Name: ", 0, false, this.colGrey);
                this.DrawLine(radioScript.GetName(), n, true);
                this.DrawLine("Start day: ", 0, false, this.colGrey);
                this.DrawLine(RadioDebugConsole.timeStampToString(radioScript.getStartDayStamp()), n, true);
                this.DrawLine("Current loop: ", 0, false, this.colGrey);
                this.DrawLine(Integer.toString(radioChannel.getCurrentScriptLoop()), n, true);
                this.DrawLine("Total loops: ", 0, false, this.colGrey);
                this.DrawLine(Integer.toString(radioChannel.getCurrentScriptMaxLoops()), n, true);
                radioBroadCast = radioScript.getCurrentBroadcast();
                if (radioBroadCast != null) {
                    this.AddBlancLine();
                    this.DrawLine("Currently active broadcast:", 0, true);
                    this.DrawLine("ID: ", 0, false, this.colGrey);
                    this.DrawLine(radioBroadCast.getID(), n, true);
                    this.DrawLine("Real StartStamp: ", 0, false, this.colGrey);
                    this.DrawLine(RadioDebugConsole.timeStampToString(radioBroadCast.getStartStamp() + radioScript.getStartDayStamp()), n, true);
                    this.DrawLine("Real EndStamp: ", 0, false, this.colGrey);
                    this.DrawLine(RadioDebugConsole.timeStampToString(radioBroadCast.getEndStamp() + radioScript.getStartDayStamp()), n, true);
                    this.DrawLine("Script StartStamp: ", 0, false, this.colGrey);
                    this.DrawLine(RadioDebugConsole.timeStampToString(radioBroadCast.getStartStamp()), n, true);
                    this.DrawLine("Script EndStamp: ", 0, false, this.colGrey);
                    this.DrawLine(RadioDebugConsole.timeStampToString(radioBroadCast.getEndStamp()), n, true);
                    if (radioBroadCast.getCurrentLine() != null) {
                        this.colDyn.r = radioBroadCast.getCurrentLine().getR();
                        this.colDyn.g = radioBroadCast.getCurrentLine().getG();
                        this.colDyn.b = radioBroadCast.getCurrentLine().getB();
                        if (radioBroadCast.getCurrentLine().getText() != null) {
                            this.DrawLine("Next line to be aired: ", 0, false, this.colGrey);
                            this.DrawLine(radioBroadCast.PeekNextLineText(), n, true, this.colDyn);
                        }
                    }
                }
            }
        }
    }

    public static String timeStampToString(int n) {
        int n2 = n / 1440;
        int n3 = n / 60 % 24;
        int n4 = n % 60;
        return "Day: " + Integer.toString(n2) + ", Hour: " + Integer.toString(n3) + ", Minute: " + Integer.toString(n4);
    }

    private void AddBlancLine() {
        this.drawY += this.drawYLine;
    }

    private void DrawLine(String string, int n, boolean bl, Color color) {
        TextManager.instance.DrawString(UIFont.Medium, this.drawX + n, this.drawY, string, color.r, color.g, color.b, color.a);
        if (bl) {
            this.drawY += this.drawYLine;
        }
    }

    private void DrawLine(String string, int n, boolean bl) {
        this.DrawLine(string, n, bl, this.colWhite);
    }
}

