/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.Language;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.radio.ChannelCategory;
import zombie.radio.RadioTranslationData;
import zombie.radio.scripting.RadioBroadCast;
import zombie.radio.scripting.RadioChannel;
import zombie.radio.scripting.RadioLine;
import zombie.radio.scripting.RadioScript;

public final class RadioData {
    static boolean PRINTDEBUG = false;
    private boolean isVanilla = false;
    private String GUID;
    private int version;
    private String xmlFilePath;
    private final ArrayList<RadioChannel> radioChannels = new ArrayList();
    private final ArrayList<RadioTranslationData> translationDataList = new ArrayList();
    private RadioTranslationData currentTranslation;
    private Node rootNode;
    private final Map<String, RadioScript> advertQue = new HashMap<String, RadioScript>();
    private static final String fieldStart = "\\$\\{t:";
    private static final String fieldEnd = "\\}";
    private static final String regex = "\\$\\{t:([^}]+)\\}";
    private static final Pattern pattern = Pattern.compile("\\$\\{t:([^}]+)\\}");

    public RadioData(String string) {
        this.xmlFilePath = string;
    }

    public ArrayList<RadioChannel> getRadioChannels() {
        return this.radioChannels;
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    public static ArrayList<String> getTranslatorNames(Language language) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (language != Translator.getDefaultLanguage()) {
            ArrayList<RadioData> arrayList2 = RadioData.fetchRadioData(false);
            for (RadioData radioData : arrayList2) {
                for (RadioTranslationData radioTranslationData : radioData.translationDataList) {
                    if (radioTranslationData.getLanguageEnum() != language) continue;
                    for (String string : radioTranslationData.getTranslators()) {
                        if (arrayList.contains(string)) continue;
                        arrayList.add(string);
                    }
                }
            }
        }
        return arrayList;
    }

    private static ArrayList<RadioData> fetchRadioData(boolean bl) {
        return RadioData.fetchRadioData(bl, DebugLog.isEnabled(DebugType.Radio));
    }

    private static ArrayList<RadioData> fetchRadioData(boolean bl, boolean bl2) {
        ArrayList<RadioData> arrayList = new ArrayList<RadioData>();
        try {
            Object object;
            String string22;
            ArrayList<String> arrayList2 = ZomboidFileSystem.instance.getModIDs();
            if (bl2) {
                System.out.println(":: Searching for radio data files:");
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            RadioData.searchForFiles(ZomboidFileSystem.instance.getMediaFile("radio"), "xml", arrayList3);
            ArrayList<String> arrayList4 = new ArrayList<String>(arrayList3);
            if (bl) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    string22 = ZomboidFileSystem.instance.getModDir(arrayList2.get(i));
                    if (string22 == null) continue;
                    RadioData.searchForFiles(new File(string22 + File.separator + "media" + File.separator + "radio"), "xml", arrayList3);
                }
            }
            for (String string22 : arrayList3) {
                object = RadioData.ReadFile(string22);
                if (object != null) {
                    if (bl2) {
                        System.out.println(" Found file: " + string22);
                    }
                    for (String object2 : arrayList4) {
                        if (!object2.equals(string22)) continue;
                        ((RadioData)object).isVanilla = true;
                    }
                    arrayList.add((RadioData)object);
                    continue;
                }
                System.out.println("[Failure] Cannot parse file: " + string22);
            }
            if (bl2) {
                System.out.println(":: Searching for translation files:");
            }
            arrayList3.clear();
            RadioData.searchForFiles(ZomboidFileSystem.instance.getMediaFile("radio"), "txt", arrayList3);
            if (bl) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    string22 = ZomboidFileSystem.instance.getModDir(arrayList2.get(i));
                    if (string22 == null) continue;
                    RadioData.searchForFiles(new File(string22 + File.separator + "media" + File.separator + "radio"), "txt", arrayList3);
                }
            }
            for (String string22 : arrayList3) {
                object = RadioTranslationData.ReadFile(string22);
                if (object != null) {
                    if (bl2) {
                        System.out.println(" Found file: " + string22);
                    }
                    for (RadioData radioData : arrayList) {
                        if (!radioData.GUID.equals(((RadioTranslationData)object).getGuid())) continue;
                        if (bl2) {
                            System.out.println(" Adding translation: " + radioData.GUID);
                        }
                        radioData.translationDataList.add((RadioTranslationData)object);
                    }
                    continue;
                }
                if (!bl2) continue;
                System.out.println("[Failure] " + string22);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static ArrayList<RadioData> fetchAllRadioData() {
        boolean bl = DebugLog.isEnabled(DebugType.Radio);
        ArrayList<RadioData> arrayList = RadioData.fetchRadioData(true);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            RadioData radioData = arrayList.get(i);
            if (radioData.loadRadioScripts()) {
                if (bl) {
                    DebugLog.Radio.println(" Adding" + (radioData.isVanilla ? " (vanilla)" : "") + " file: " + radioData.xmlFilePath);
                    DebugLog.Radio.println(" - GUID: " + radioData.GUID);
                }
                radioData.currentTranslation = null;
                radioData.translationDataList.clear();
                continue;
            }
            DebugLog.Radio.println("[Failure] Failed to load radio scripts for GUID: " + radioData.GUID);
            DebugLog.Radio.println("          File: " + radioData.xmlFilePath);
            arrayList.remove(i);
        }
        return arrayList;
    }

    private static void searchForFiles(File file, String string, ArrayList<String> arrayList) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                RadioData.searchForFiles(new File(file.getAbsolutePath() + File.separator + stringArray[i]), string, arrayList);
            }
        } else if (file.getAbsolutePath().toLowerCase().contains(string)) {
            arrayList.add(file.getAbsolutePath());
        }
    }

    private static RadioData ReadFile(String string) {
        RadioData radioData = new RadioData(string);
        boolean bl = false;
        try {
            if (DebugLog.isEnabled(DebugType.Radio)) {
                DebugLog.Radio.println("Reading xml: " + string);
            }
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("RadioData");
            if (DebugLog.isEnabled(DebugType.Radio)) {
                DebugLog.Radio.println("RadioData nodes len: " + nodeList.getLength());
            }
            if (nodeList.getLength() > 0) {
                radioData.rootNode = nodeList.item(0);
                bl = radioData.loadRootInfo();
                if (DebugLog.isEnabled(DebugType.Radio)) {
                    DebugLog.Radio.println("valid file: " + bl);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            return radioData;
        }
        return null;
    }

    private void print(String string) {
        if (PRINTDEBUG) {
            DebugLog.log(DebugType.Radio, string);
        }
    }

    private ArrayList<Node> getChildNodes(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node.hasChildNodes()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (!(node2 instanceof Element)) {
                    node2 = node2.getNextSibling();
                    continue;
                }
                arrayList.add(node2);
                node2 = node2.getNextSibling();
            }
        }
        return arrayList;
    }

    private String toLowerLocaleSafe(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    private boolean nodeNameIs(Node node, String string) {
        return node.getNodeName().equals(string);
    }

    private String getAttrib(Node node, String string, boolean bl) {
        return this.getAttrib(node, string, bl, false);
    }

    private String getAttrib(Node node, String string) {
        return this.getAttrib(node, string, true, false).trim();
    }

    private String getAttrib(Node node, String string, boolean bl, boolean bl2) {
        String string2 = node.getAttributes().getNamedItem(string).getTextContent();
        if (bl) {
            string2 = string2.trim();
        }
        if (bl2) {
            string2 = this.toLowerLocaleSafe(string2);
        }
        return string2;
    }

    private boolean loadRootInfo() {
        boolean bl = DebugLog.isEnabled(DebugType.Radio);
        if (bl) {
            DebugLog.Radio.println("Reading RootInfo...");
        }
        for (Node node : this.getChildNodes(this.rootNode)) {
            if (!this.nodeNameIs(node, "RootInfo")) continue;
            if (bl) {
                DebugLog.Radio.println("RootInfo found");
            }
            for (Node node2 : this.getChildNodes(node)) {
                String string = node2.getNodeName();
                String string2 = node2.getTextContent();
                if (string == null || string2 == null) continue;
                string = string.trim();
                if (bl) {
                    DebugLog.Radio.println("Found element: " + string);
                }
                if (string.equals("Version")) {
                    if (bl) {
                        DebugLog.Radio.println("Version = " + this.version);
                    }
                    this.version = Integer.parseInt(string2);
                    continue;
                }
                if (!string.equals("FileGUID")) continue;
                if (bl) {
                    DebugLog.Radio.println("GUID = " + string2);
                }
                this.GUID = string2;
            }
        }
        return this.GUID != null && this.version >= 0;
    }

    private boolean loadRadioScripts() {
        boolean bl = false;
        this.currentTranslation = null;
        this.advertQue.clear();
        if (Core.getInstance().getContentTranslationsEnabled() && Translator.getLanguage() != Translator.getDefaultLanguage()) {
            System.out.println("Attempting to load translation: " + Translator.getLanguage().toString());
            for (RadioTranslationData object : this.translationDataList) {
                if (object.getLanguageEnum() != Translator.getLanguage()) continue;
                System.out.println("Translation found!");
                if (object.loadTranslations()) {
                    this.currentTranslation = object;
                    System.out.println("Count = " + this.currentTranslation.getTranslationCount());
                    continue;
                }
                System.out.println("Error loading translations for " + this.GUID);
            }
        } else if (!Core.getInstance().getContentTranslationsEnabled()) {
            System.out.println("NOTE: Community Content Translations are disabled.");
        }
        for (Node node : this.getChildNodes(this.rootNode)) {
            if (!this.nodeNameIs(node, "Adverts")) continue;
            this.loadAdverts(node);
        }
        for (Node node : this.getChildNodes(this.rootNode)) {
            if (!this.nodeNameIs(node, "Channels")) continue;
            this.loadChannels(node);
            bl = true;
        }
        return bl;
    }

    private void loadAdverts(Node node) {
        this.print(">>> Loading adverts...");
        ArrayList<RadioScript> arrayList = new ArrayList<RadioScript>();
        arrayList = this.loadScripts(node, arrayList, true);
        for (RadioScript radioScript : arrayList) {
            if (this.advertQue.containsKey(radioScript.GetName())) continue;
            this.advertQue.put(radioScript.GetGUID(), radioScript);
        }
    }

    private void loadChannels(Node node) {
        this.print(">>> Loading channels...");
        ArrayList<RadioScript> arrayList = new ArrayList<RadioScript>();
        for (Node node2 : this.getChildNodes(node)) {
            if (!this.nodeNameIs(node2, "ChannelEntry")) continue;
            String string = this.getAttrib(node2, "ID");
            String string2 = this.getAttrib(node2, "name");
            String string3 = this.getAttrib(node2, "cat");
            String string4 = this.getAttrib(node2, "freq");
            String string5 = this.getAttrib(node2, "startscript");
            this.print(" -> Found channel: " + string2 + ", on freq: " + string4 + " , category: " + string3 + ", startscript: " + string5 + ", ID: " + string);
            RadioChannel radioChannel = new RadioChannel(string2, Integer.parseInt(string4), ChannelCategory.valueOf(string3), string);
            arrayList.clear();
            arrayList = this.loadScripts(node2, arrayList, false);
            for (RadioScript radioScript : arrayList) {
                radioChannel.AddRadioScript(radioScript);
            }
            radioChannel.setActiveScript(string5, 0);
            this.radioChannels.add(radioChannel);
            radioChannel.setRadioData(this);
        }
    }

    private ArrayList<RadioScript> loadScripts(Node node, ArrayList<RadioScript> arrayList, boolean bl) {
        this.print(" --> Loading scripts...");
        for (Node node2 : this.getChildNodes(node)) {
            if (!this.nodeNameIs(node2, "ScriptEntry")) continue;
            String string = this.getAttrib(node2, "ID");
            String string2 = this.getAttrib(node2, "name");
            String string3 = this.getAttrib(node2, "loopmin");
            String string4 = this.getAttrib(node2, "loopmax");
            this.print(" ---> Found script: " + string2);
            RadioScript radioScript = new RadioScript(string2, Integer.parseInt(string3), Integer.parseInt(string4), string);
            for (Node node3 : this.getChildNodes(node2)) {
                if (this.nodeNameIs(node3, "BroadcastEntry")) {
                    this.loadBroadcast(node3, radioScript);
                    continue;
                }
                if (bl || !this.nodeNameIs(node3, "ExitOptions")) continue;
                this.loadExitOptions(node3, radioScript);
            }
            arrayList.add(radioScript);
        }
        return arrayList;
    }

    private RadioBroadCast loadBroadcast(Node node, RadioScript radioScript) {
        Object object;
        String string = this.getAttrib(node, "ID");
        String string2 = this.getAttrib(node, "timestamp");
        String string3 = this.getAttrib(node, "endstamp");
        this.print(" ----> BroadCast, Timestamp: " + string2 + ", endstamp: " + string3);
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        String string4 = this.getAttrib(node, "isSegment");
        boolean bl = this.toLowerLocaleSafe(string4).equals("true");
        String string5 = this.getAttrib(node, "advertCat");
        RadioBroadCast radioBroadCast = new RadioBroadCast(string, n, n2);
        if (!bl && !this.toLowerLocaleSafe(string5).equals("none") && this.advertQue.containsKey(string5) && Rand.Next(101) < 75 && ((RadioScript)(object = this.advertQue.get(string5))).getBroadcastList().size() > 0) {
            if (Rand.Next(101) < 50) {
                radioBroadCast.setPreSegment(((RadioScript)object).getBroadcastList().get(Rand.Next(((RadioScript)object).getBroadcastList().size())));
            } else {
                radioBroadCast.setPostSegment(((RadioScript)object).getBroadcastList().get(Rand.Next(((RadioScript)object).getBroadcastList().size())));
            }
        }
        for (Node node2 : this.getChildNodes(node)) {
            if (!this.nodeNameIs(node2, "LineEntry")) continue;
            String string6 = this.getAttrib(node2, "ID");
            String string7 = this.getAttrib(node2, "r");
            String string8 = this.getAttrib(node2, "g");
            String string9 = this.getAttrib(node2, "b");
            String string10 = null;
            if (node2.getAttributes().getNamedItem("codes") != null) {
                string10 = this.getAttrib(node2, "codes");
            }
            String string11 = node2.getTextContent();
            this.print(" -----> New Line, Color: " + string7 + ", " + string8 + ", " + string9);
            string11 = this.checkForTranslation(string6, string11);
            RadioLine radioLine = new RadioLine(string11, Float.parseFloat(string7) / 255.0f, Float.parseFloat(string8) / 255.0f, Float.parseFloat(string9) / 255.0f, string10);
            radioBroadCast.AddRadioLine(radioLine);
            if (!(string11 = string11.trim()).toLowerCase().startsWith("${t:")) continue;
            string11 = this.checkForCustomAirTimer(string11, radioLine);
            radioLine.setText(string11);
        }
        if (radioScript != null) {
            radioScript.AddBroadcast(radioBroadCast, bl);
        }
        return radioBroadCast;
    }

    private String checkForTranslation(String string, String string2) {
        if (this.currentTranslation != null) {
            String string3 = this.currentTranslation.getTranslation(string);
            if (string3 != null) {
                return string3;
            }
            DebugLog.log(DebugType.Radio, "no translation for: " + string);
        }
        return string2;
    }

    private void loadExitOptions(Node node, RadioScript radioScript) {
        for (Node node2 : this.getChildNodes(node)) {
            if (!this.nodeNameIs(node2, "ExitOption")) continue;
            String string = this.getAttrib(node2, "script");
            String string2 = this.getAttrib(node2, "chance");
            String string3 = this.getAttrib(node2, "delay");
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
            radioScript.AddExitOption(string, n, n2);
        }
    }

    private String checkForCustomAirTimer(String string, RadioLine radioLine) {
        Matcher matcher = pattern.matcher(string);
        String string2 = string;
        float f = -1.0f;
        if (matcher.find()) {
            String string3 = matcher.group(1).toLowerCase().trim();
            try {
                f = Float.parseFloat(string3);
                radioLine.setAirTime(f);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string2 = string2.replaceFirst(regex, "");
        }
        if (f >= 0.0f) {
            return "[cdt=" + f + "]" + string2.trim();
        }
        return string2.trim();
    }
}

