/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio;

import java.util.Map;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.radio.ZomboidRadio;

public final class RadioAPI {
    private static RadioAPI instance;

    public static int timeToTimeStamp(int n, int n2, int n3) {
        return n * 24 + n2 * 60 + n3;
    }

    public static int timeStampToDays(int n) {
        return n / 1440;
    }

    public static int timeStampToHours(int n) {
        return n / 60 % 24;
    }

    public static int timeStampToMinutes(int n) {
        return n % 60;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static RadioAPI getInstance() {
        if (instance == null) {
            instance = new RadioAPI();
        }
        return instance;
    }

    private RadioAPI() {
    }

    public KahluaTable getChannels(String string) {
        Map<Integer, String> map = ZomboidRadio.getInstance().GetChannelList(string);
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        if (map != null) {
            for (Map.Entry<Integer, String> entry : map.entrySet()) {
                kahluaTable.rawset(entry.getKey(), (Object)entry.getValue());
            }
        }
        return kahluaTable;
    }
}

