/*
 * Decompiled with CFR 0.152.
 */
package zombie.profanity.locales;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zombie.ZomboidFileSystem;
import zombie.profanity.Phonizer;
import zombie.profanity.ProfanityFilter;

public abstract class Locale {
    protected String id;
    protected int storeVowelsAmount = 3;
    protected String phoneticRules = "";
    protected Map<String, Phonizer> phonizers = new HashMap<String, Phonizer>();
    protected Map<String, String> filterWords = new HashMap<String, String>();
    protected List<String> filterWordsRaw = new ArrayList<String>();
    protected List<String> filterContains = new ArrayList<String>();
    protected ArrayList<String> whitelistWords = new ArrayList();
    protected Pattern pattern;
    private Pattern preProcessLeet = Pattern.compile("(?<leet>[\\$@34701])\\k<leet>*|(?<nonWord>[^A-Z\\s\\$@34701]+)");
    private Pattern preProcessDoubles = Pattern.compile("(?<doublechar>[A-Z])\\k<doublechar>+");
    private Pattern preProcessVowels = Pattern.compile("(?<vowel>[AOUIE])");

    protected Locale(String string) {
        this.id = string;
        this.Init();
        this.finalizeData();
        this.loadFilterWords();
        this.loadFilterContains();
        this.loadWhiteListWords();
        ProfanityFilter.printDebug("Done init locale: " + this.id);
    }

    public String getID() {
        return this.id;
    }

    public String getPhoneticRules() {
        return this.phoneticRules;
    }

    public int getFilterWordsCount() {
        return this.filterWords.size();
    }

    protected abstract void Init();

    public void addWhiteListWord(String string) {
        if (!this.whitelistWords.contains(string = string.toUpperCase().trim())) {
            this.whitelistWords.add(string);
        }
    }

    public void removeWhiteListWord(String string) {
        if (this.whitelistWords.contains(string = string.toUpperCase().trim())) {
            this.whitelistWords.remove(string);
        }
    }

    public boolean isWhiteListedWord(String string) {
        return this.whitelistWords.contains(string.toUpperCase().trim());
    }

    public void addFilterWord(String string) {
        String string2 = this.phonizeWord(string);
        if (string2.length() > 2) {
            Object object = "";
            if (this.filterWords.containsKey(string2)) {
                object = (String)object + this.filterWords.get(string2) + ",";
            }
            ProfanityFilter.printDebug("Adding word: " + string + ", Phonized: " + string2);
            this.filterWords.put(string2, (String)object + string.toLowerCase());
        } else {
            ProfanityFilter.printDebug("Refusing word: " + string + ", Phonized: " + string2 + ", null or phonized < 2 characters");
        }
    }

    public void removeFilterWord(String string) {
        String string2 = this.phonizeWord(string);
        if (this.filterWords.containsKey(string2)) {
            this.filterWords.remove(string2);
        }
    }

    public void addFilterContains(String string) {
        if (string != null && !string.isEmpty() && !this.filterContains.contains(string.toUpperCase())) {
            this.filterContains.add(string.toUpperCase());
        }
    }

    public void removeFilterContains(String string) {
        this.filterContains.remove(string.toUpperCase());
    }

    public void addFilterRawWord(String string) {
        if (string != null && !string.isEmpty() && !this.filterWordsRaw.contains(string.toUpperCase())) {
            this.filterWordsRaw.add(string.toUpperCase());
        }
    }

    public void removeFilterWordRaw(String string) {
        this.filterWordsRaw.remove(string.toUpperCase());
    }

    protected String repeatString(int n, char c) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    protected boolean containsIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n == 0) {
            return true;
        }
        for (int i = string.length() - n; i >= 0; --i) {
            if (!string.regionMatches(true, i, string2, 0, n)) continue;
            return true;
        }
        return false;
    }

    public String filterWord(String string) {
        return this.filterWord(string, false);
    }

    public String filterWord(String string, boolean bl) {
        if (this.isWhiteListedWord(string)) {
            return string;
        }
        String string2 = this.phonizeWord(string);
        if (this.filterWords.containsKey(string2)) {
            return new String(new char[string.length()]).replace('\u0000', '*');
        }
        if (this.filterWordsRaw.size() > 0) {
            for (int i = 0; i < this.filterWordsRaw.size(); ++i) {
                if (!string.equalsIgnoreCase(this.filterWordsRaw.get(i))) continue;
                return new String(new char[string.length()]).replace('\u0000', '*');
            }
        }
        if (bl) {
            for (int i = 0; i < this.filterContains.size(); ++i) {
                String string3 = this.filterContains.get(i);
                if (!this.containsIgnoreCase(string, string3)) continue;
                string = string.replaceAll("(?i)" + Pattern.quote(string3), this.repeatString(string3.length(), '*'));
            }
        }
        return string;
    }

    public String validateWord(String string, boolean bl) {
        if (this.isWhiteListedWord(string)) {
            return null;
        }
        String string2 = this.phonizeWord(string);
        if (this.filterWords.containsKey(string2)) {
            return string;
        }
        if (this.filterWordsRaw.size() > 0) {
            for (int i = 0; i < this.filterWordsRaw.size(); ++i) {
                if (!string.equalsIgnoreCase(this.filterWordsRaw.get(i))) continue;
                return string;
            }
        }
        if (bl) {
            for (int i = 0; i < this.filterContains.size(); ++i) {
                String string3 = this.filterContains.get(i);
                if (!this.containsIgnoreCase(string, string3)) continue;
                return string3.toLowerCase();
            }
        }
        return null;
    }

    public String returnMatchSetForWord(String string) {
        String string2 = this.phonizeWord(string);
        if (this.filterWords.containsKey(string2)) {
            return this.filterWords.get(string2);
        }
        return null;
    }

    public String returnPhonizedWord(String string) {
        return this.phonizeWord(string);
    }

    protected String phonizeWord(String string) {
        if (this.whitelistWords.contains(string = string.toUpperCase().trim())) {
            return string;
        }
        string = this.preProcessWord(string);
        if (this.phonizers.size() <= 0) {
            return string;
        }
        Matcher matcher = this.pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        block0: while (matcher.find()) {
            for (Map.Entry<String, Phonizer> entry : this.phonizers.entrySet()) {
                if (matcher.group(entry.getKey()) == null) continue;
                entry.getValue().execute(matcher, stringBuffer);
                continue block0;
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String preProcessWord(String string) {
        Matcher matcher = this.preProcessLeet.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group("leet") != null) {
                switch (matcher.group("leet").toString()) {
                    case "$": {
                        matcher.appendReplacement(stringBuffer, "S");
                        break;
                    }
                    case "4": 
                    case "@": {
                        matcher.appendReplacement(stringBuffer, "A");
                        break;
                    }
                    case "3": {
                        matcher.appendReplacement(stringBuffer, "E");
                        break;
                    }
                    case "7": {
                        matcher.appendReplacement(stringBuffer, "T");
                        break;
                    }
                    case "0": {
                        matcher.appendReplacement(stringBuffer, "O");
                        break;
                    }
                    case "1": {
                        matcher.appendReplacement(stringBuffer, "I");
                    }
                }
                continue;
            }
            if (matcher.group("nonWord") == null) continue;
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        matcher = this.preProcessDoubles.matcher(stringBuffer.toString());
        stringBuffer.delete(0, stringBuffer.capacity());
        while (matcher.find()) {
            if (matcher.group("doublechar") == null) continue;
            matcher.appendReplacement(stringBuffer, "${doublechar}");
        }
        matcher.appendTail(stringBuffer);
        matcher = this.preProcessVowels.matcher(stringBuffer.toString());
        stringBuffer.delete(0, stringBuffer.capacity());
        int n = 0;
        while (matcher.find()) {
            if (matcher.group("vowel") == null) continue;
            if (n < this.storeVowelsAmount) {
                matcher.appendReplacement(stringBuffer, "${vowel}");
                ++n;
                continue;
            }
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    protected void addPhonizer(Phonizer phonizer) {
        if (phonizer != null && !this.phonizers.containsKey(phonizer.getName())) {
            this.phonizers.put(phonizer.getName(), phonizer);
        }
    }

    protected void finalizeData() {
        this.phoneticRules = "";
        int n = this.phonizers.size();
        int n2 = 0;
        for (Phonizer phonizer : this.phonizers.values()) {
            this.phoneticRules = this.phoneticRules + phonizer.getRegex();
            if (++n2 >= n) continue;
            this.phoneticRules = this.phoneticRules + "|";
        }
        ProfanityFilter.printDebug("PhoneticRules: " + this.phoneticRules);
        this.pattern = Pattern.compile(this.phoneticRules);
    }

    protected void loadFilterWords() {
        try {
            String string;
            String string2 = ZomboidFileSystem.instance.getString(ProfanityFilter.LOCALES_DIR + "blacklist_" + this.id + ".txt");
            File file = new File(string2);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                this.addFilterWord(string);
                ++n;
            }
            fileReader.close();
            ProfanityFilter.printDebug("BlackList, " + n + " added.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void loadFilterContains() {
        try {
            String string;
            String string2 = ZomboidFileSystem.instance.getString(ProfanityFilter.LOCALES_DIR + "blacklist_contains_" + this.id + ".txt");
            File file = new File(string2);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("//")) continue;
                this.addFilterContains(string);
                ++n;
            }
            fileReader.close();
            ProfanityFilter.printDebug("BlackList contains, " + n + " added.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void loadWhiteListWords() {
        try {
            String string;
            String string2 = ZomboidFileSystem.instance.getString(ProfanityFilter.LOCALES_DIR + "whitelist_" + this.id + ".txt");
            File file = new File(string2);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                this.addWhiteListWord(string);
                ++n;
            }
            fileReader.close();
            ProfanityFilter.printDebug("WhiteList, " + n + " added.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

