/*
 * Decompiled with CFR 0.152.
 */
package zombie.profanity;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import zombie.ZomboidFileSystem;
import zombie.profanity.ProfanityFilter;
import zombie.profanity.locales.Locale;

public class ProfanityTest {
    public static void runTest() {
        ProfanityFilter profanityFilter = ProfanityFilter.getInstance();
        System.out.println("");
        ProfanityTest.loadDictionary();
        ProfanityTest.testString(1, "profane stuff:  f u c k. sex xex h4rd \u00c3\u0178hit knight hello, @ $ $ H O L E   ass-hole f-u-c-k f_u_c_k_ @$$h0le fu'ckeerr: sdsi: KUNT as'as!! ffffuuuccckkkerrr");
    }

    public static void testString(int n, String string) {
        ProfanityFilter profanityFilter = ProfanityFilter.getInstance();
        String string2 = "";
        System.out.println("Benchmarking " + n + " iterations: ");
        System.out.println("Original: " + string);
        long l = System.nanoTime();
        for (int i = 0; i < n; ++i) {
            string2 = profanityFilter.filterString(string);
        }
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        System.out.println("Done, time spent: " + (float)l3 / 1.0E9f + " seconds");
        System.out.println("Result: " + string2);
        System.out.println("");
    }

    public static void loadDictionary() {
        System.out.println("");
        System.out.println("Dictionary: ");
        long l = System.nanoTime();
        ProfanityFilter profanityFilter = ProfanityFilter.getInstance();
        try {
            String string;
            File file = ZomboidFileSystem.instance.getMediaFile("profanity" + File.separator + "Dictionary.txt");
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = 0;
            Locale locale = profanityFilter.getLocale();
            while ((string = bufferedReader.readLine()) != null) {
                String string2 = locale.returnMatchSetForWord(string);
                if (string2 != null) {
                    System.out.println("Found match: " + string.trim() + ", Phonized: " + locale.returnPhonizedWord(string.trim()) + ", Set: " + string2);
                    ++n2;
                }
                ++n;
            }
            fileReader.close();
            System.out.println("Profanity filter tested " + profanityFilter.getFilterWordsCount() + " blacklisted words against " + n + " words from dictionary.");
            System.out.println("Found " + n2 + " matches.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        System.out.println("Done, time spent: " + (float)l3 / 1.0E9f + " seconds");
        System.out.println("");
    }
}

