/*
 * Decompiled with CFR 0.152.
 */
package zombie.popman;

import java.util.ArrayList;
import zombie.iso.BuildingDef;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;

final class PlayerSpawns {
    private final ArrayList<PlayerSpawn> playerSpawns = new ArrayList();

    PlayerSpawns() {
    }

    public void addSpawn(int n, int n2, int n3) {
        PlayerSpawn playerSpawn = new PlayerSpawn(n, n2, n3);
        if (playerSpawn.building != null) {
            this.playerSpawns.add(playerSpawn);
        }
    }

    public void update() {
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.playerSpawns.size(); ++i) {
            PlayerSpawn playerSpawn = this.playerSpawns.get(i);
            if (playerSpawn.counter == -1L) {
                playerSpawn.counter = l;
            }
            if (playerSpawn.counter + 10000L > l) continue;
            this.playerSpawns.remove(i--);
        }
    }

    public boolean allowZombie(IsoGridSquare isoGridSquare) {
        for (int i = 0; i < this.playerSpawns.size(); ++i) {
            PlayerSpawn playerSpawn = this.playerSpawns.get(i);
            if (playerSpawn.allowZombie(isoGridSquare)) continue;
            return false;
        }
        return true;
    }

    private static class PlayerSpawn {
        public int x;
        public int y;
        public long counter;
        public BuildingDef building;

        public PlayerSpawn(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.counter = -1L;
            RoomDef roomDef = IsoWorld.instance.getMetaGrid().getRoomAt(n, n2, n3);
            if (roomDef != null) {
                this.building = roomDef.getBuilding();
            }
        }

        public boolean allowZombie(IsoGridSquare isoGridSquare) {
            if (this.building == null) {
                return true;
            }
            if (isoGridSquare.getBuilding() != null && this.building == isoGridSquare.getBuilding().getDef()) {
                return false;
            }
            return isoGridSquare.getX() < this.building.getX() - 15 || isoGridSquare.getX() >= this.building.getX2() + 15 || isoGridSquare.getY() < this.building.getY() - 15 || isoGridSquare.getY() >= this.building.getY2() + 15;
        }
    }
}

