/*
 * Decompiled with CFR 0.152.
 */
package zombie.popman;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import zombie.SystemDisabler;
import zombie.ai.State;
import zombie.ai.states.ZombieEatBodyState;
import zombie.ai.states.ZombieIdleState;
import zombie.ai.states.ZombieSittingState;
import zombie.ai.states.ZombieTurnAlerted;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.network.GameServer;
import zombie.popman.NetworkZombieList;
import zombie.popman.NetworkZombiePacker;
import zombie.util.Type;

public class NetworkZombieManager {
    private static final NetworkZombieManager instance = new NetworkZombieManager();
    private final NetworkZombieList owns = new NetworkZombieList();
    private static final float NospottedDistanceSquared = 16.0f;

    public static NetworkZombieManager getInstance() {
        return instance;
    }

    public int getAuthorizedZombieCount(UdpConnection udpConnection) {
        return (int)IsoWorld.instance.CurrentCell.getZombieList().stream().filter(isoZombie -> isoZombie.authOwner == udpConnection).count();
    }

    public int getUnauthorizedZombieCount() {
        return (int)IsoWorld.instance.CurrentCell.getZombieList().stream().filter(isoZombie -> isoZombie.authOwner == null).count();
    }

    public static boolean canSpotted(IsoZombie isoZombie) {
        if (isoZombie.isRemoteZombie()) {
            return false;
        }
        if (isoZombie.target != null && IsoUtils.DistanceToSquared(isoZombie.x, isoZombie.y, isoZombie.target.x, isoZombie.target.y) < 16.0f) {
            return false;
        }
        State state = isoZombie.getCurrentState();
        return state == null || state == ZombieIdleState.instance() || state == ZombieEatBodyState.instance() || state == ZombieSittingState.instance() || state == ZombieTurnAlerted.instance();
    }

    public void updateAuth(IsoZombie isoZombie) {
        UdpConnection udpConnection;
        int n;
        float f;
        UdpConnection udpConnection2;
        if (!GameServer.bServer) {
            return;
        }
        if (System.currentTimeMillis() - isoZombie.lastChangeOwner < 2000L && isoZombie.authOwner != null) {
            return;
        }
        if (SystemDisabler.zombiesSwitchOwnershipEachUpdate && GameServer.getPlayerCount() > 1) {
            if (isoZombie.authOwner == null) {
                for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                    UdpConnection udpConnection3 = GameServer.udpEngine.connections.get(i);
                    if (udpConnection3 == null) continue;
                    this.moveZombie(isoZombie, udpConnection3, null);
                    break;
                }
            } else {
                int n2 = GameServer.udpEngine.connections.indexOf(isoZombie.authOwner) + 1;
                for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                    UdpConnection udpConnection4 = GameServer.udpEngine.connections.get((i + n2) % GameServer.udpEngine.connections.size());
                    if (udpConnection4 == null) continue;
                    this.moveZombie(isoZombie, udpConnection4, null);
                    break;
                }
            }
            return;
        }
        if (isoZombie.target instanceof IsoPlayer && (udpConnection2 = GameServer.getConnectionFromPlayer((IsoPlayer)isoZombie.target)) != null && udpConnection2.isFullyConnected() && !Float.isInfinite(f = ((IsoPlayer)isoZombie.target).getRelevantAndDistance(isoZombie.x, isoZombie.y, udpConnection2.ReleventRange - 2))) {
            this.moveZombie(isoZombie, udpConnection2, (IsoPlayer)isoZombie.target);
            if (Core.bDebug) {
                DebugLog.log(DebugType.Ownership, String.format("Zombie (%d) owner (\"%s\"): zombie has target", isoZombie.getOnlineID(), ((IsoPlayer)isoZombie.target).getUsername()));
            }
            return;
        }
        udpConnection2 = isoZombie.authOwner;
        IsoPlayer isoPlayer = isoZombie.authOwnerPlayer;
        float f2 = Float.POSITIVE_INFINITY;
        if (udpConnection2 != null) {
            f2 = udpConnection2.getRelevantAndDistance(isoZombie.x, isoZombie.y, isoZombie.z);
        }
        for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
            udpConnection = GameServer.udpEngine.connections.get(n);
            if (udpConnection == udpConnection2) continue;
            for (IsoPlayer isoPlayer2 : udpConnection.players) {
                float f3;
                if (isoPlayer2 == null || !isoPlayer2.isAlive() || Float.isInfinite(f3 = isoPlayer2.getRelevantAndDistance(isoZombie.x, isoZombie.y, udpConnection.ReleventRange - 2)) || udpConnection2 != null && !(f2 > f3 * 1.618034f)) continue;
                udpConnection2 = udpConnection;
                f2 = f3;
                isoPlayer = isoPlayer2;
            }
        }
        if (Core.bDebug && isoPlayer != null && isoPlayer != isoZombie.authOwnerPlayer) {
            DebugLog.log(DebugType.Ownership, String.format("Zombie (%d) owner (\"%s\"): zombie is closer", isoZombie.getOnlineID(), isoPlayer.getUsername()));
        }
        if (udpConnection2 == null && isoZombie.isReanimatedPlayer()) {
            for (n = 0; n < GameServer.udpEngine.connections.size(); ++n) {
                udpConnection = GameServer.udpEngine.connections.get(n);
                if (udpConnection == udpConnection2) continue;
                for (IsoPlayer isoPlayer2 : udpConnection.players) {
                    if (isoPlayer2 == null || !isoPlayer2.isDead() || isoPlayer2.ReanimatedCorpse != isoZombie) continue;
                    udpConnection2 = udpConnection;
                    isoPlayer = isoPlayer2;
                    if (!Core.bDebug) continue;
                    DebugLog.log(DebugType.Ownership, String.format("Zombie (%d) owner (\"%s\"): zombie is reanimated", isoZombie.getOnlineID(), isoPlayer.getUsername()));
                }
            }
        }
        if (udpConnection2 != null && !udpConnection2.RelevantTo(isoZombie.x, isoZombie.y, (udpConnection2.ReleventRange - 2) * 10)) {
            udpConnection2 = null;
        }
        this.moveZombie(isoZombie, udpConnection2, isoPlayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveZombie(IsoZombie isoZombie, UdpConnection udpConnection, IsoPlayer isoPlayer) {
        if (isoZombie.isDead()) {
            if (isoZombie.authOwner == null && isoZombie.authOwnerPlayer == null) {
                isoZombie.becomeCorpse();
            } else {
                Object object = this.owns.lock;
                synchronized (object) {
                    isoZombie.authOwner = null;
                    isoZombie.authOwnerPlayer = null;
                    isoZombie.getNetworkCharacterAI().resetSpeedLimiter();
                }
                NetworkZombiePacker.getInstance().setExtraUpdate();
            }
            if (Core.bDebug) {
                DebugLog.log(DebugType.Ownership, String.format("Zombie (%d) owner (\"%s\" / null): zombie is dead", isoZombie.getOnlineID(), isoPlayer == null ? "" : isoPlayer.getUsername()));
            }
            return;
        }
        if (isoPlayer != null && isoPlayer.getVehicle() != null && isoPlayer.getVehicle().getSpeed2D() > 2.0f && isoPlayer.getVehicle().getDriver() != isoPlayer && isoPlayer.getVehicle().getDriver() instanceof IsoPlayer) {
            isoPlayer = (IsoPlayer)isoPlayer.getVehicle().getDriver();
            udpConnection = GameServer.getConnectionFromPlayer(isoPlayer);
            if (Core.bDebug) {
                DebugLog.log(DebugType.Ownership, String.format("Zombie (%d) owner (\"%s\"): zombie owner is driver", isoZombie.getOnlineID(), isoPlayer == null ? "" : isoPlayer.getUsername()));
            }
        }
        if (isoZombie.authOwner == udpConnection) {
            return;
        }
        Object object = this.owns.lock;
        synchronized (object) {
            NetworkZombieList.NetworkZombie networkZombie;
            if (isoZombie.authOwner != null && (networkZombie = this.owns.getNetworkZombie(isoZombie.authOwner)) != null && !networkZombie.zombies.remove(isoZombie)) {
                DebugLog.log("moveZombie: There are no zombies in nz.zombies.");
            }
            if (udpConnection != null) {
                networkZombie = this.owns.getNetworkZombie(udpConnection);
                if (networkZombie != null) {
                    networkZombie.zombies.add(isoZombie);
                    isoZombie.authOwner = udpConnection;
                    isoZombie.authOwnerPlayer = isoPlayer;
                    isoZombie.getNetworkCharacterAI().resetSpeedLimiter();
                    udpConnection.timerSendZombie.reset(0L);
                }
            } else {
                isoZombie.authOwner = null;
                isoZombie.authOwnerPlayer = null;
                isoZombie.getNetworkCharacterAI().resetSpeedLimiter();
            }
        }
        isoZombie.lastChangeOwner = System.currentTimeMillis();
        NetworkZombiePacker.getInstance().setExtraUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getZombieAuth(UdpConnection udpConnection, ByteBuffer byteBuffer) {
        NetworkZombieList.NetworkZombie networkZombie = this.owns.getNetworkZombie(udpConnection);
        int n = networkZombie.zombies.size();
        int n2 = 0;
        int n3 = byteBuffer.position();
        byteBuffer.putShort((short)n);
        Object object = this.owns.lock;
        synchronized (object) {
            networkZombie.zombies.removeIf(isoZombie -> isoZombie.OnlineID == -1);
            for (IsoZombie isoZombie2 : networkZombie.zombies) {
                if (isoZombie2.OnlineID != -1) {
                    byteBuffer.putShort(isoZombie2.OnlineID);
                    ++n2;
                    continue;
                }
                DebugLog.General.error("getZombieAuth: zombie.OnlineID == -1");
            }
        }
        if (n2 < n) {
            int n4 = byteBuffer.position();
            byteBuffer.position(n3);
            byteBuffer.putShort((short)n2);
            byteBuffer.position(n4);
        }
    }

    public LinkedList<IsoZombie> getZombieList(UdpConnection udpConnection) {
        NetworkZombieList.NetworkZombie networkZombie = this.owns.getNetworkZombie(udpConnection);
        return networkZombie.zombies;
    }

    public void clearTargetAuth(UdpConnection udpConnection, IsoPlayer isoPlayer) {
        if (Core.bDebug) {
            DebugLog.log(DebugType.Multiplayer, "Clear zombies target and auth for player id=" + isoPlayer.getOnlineID());
        }
        if (GameServer.bServer) {
            for (IsoZombie isoZombie : IsoWorld.instance.CurrentCell.getZombieList()) {
                if (isoZombie.target == isoPlayer) {
                    isoZombie.setTarget(null);
                }
                if (isoZombie.authOwner != udpConnection) continue;
                isoZombie.authOwner = null;
                isoZombie.authOwnerPlayer = null;
                isoZombie.getNetworkCharacterAI().resetSpeedLimiter();
                NetworkZombieManager.getInstance().updateAuth(isoZombie);
            }
        }
    }

    public static void removeZombies(UdpConnection udpConnection) {
        int n = (IsoChunkMap.ChunkGridWidth / 2 + 2) * 10;
        for (IsoPlayer isoPlayer : udpConnection.players) {
            if (isoPlayer == null) continue;
            int n2 = (int)isoPlayer.getX();
            int n3 = (int)isoPlayer.getY();
            for (int i = 0; i < 8; ++i) {
                for (int j = n3 - n; j <= n3 + n; ++j) {
                    for (int k = n2 - n; k <= n2 + n; ++k) {
                        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(k, j, i);
                        if (isoGridSquare == null || isoGridSquare.getMovingObjects().isEmpty()) continue;
                        for (int i2 = isoGridSquare.getMovingObjects().size() - 1; i2 >= 0; --i2) {
                            IsoZombie isoZombie = Type.tryCastTo(isoGridSquare.getMovingObjects().get(i2), IsoZombie.class);
                            if (isoZombie == null) continue;
                            NetworkZombiePacker.getInstance().deleteZombie(isoZombie);
                            isoZombie.removeFromWorld();
                            isoZombie.removeFromSquare();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recheck(UdpConnection udpConnection) {
        Object object = this.owns.lock;
        synchronized (object) {
            NetworkZombieList.NetworkZombie networkZombie = this.owns.getNetworkZombie(udpConnection);
            if (networkZombie != null) {
                networkZombie.zombies.removeIf(isoZombie -> isoZombie.authOwner != udpConnection);
            }
        }
    }
}

