/*
 * Decompiled with CFR 0.152.
 */
package zombie.popman;

import zombie.characters.IsoPlayer;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoWorld;
import zombie.iso.Vector3;
import zombie.network.GameServer;
import zombie.network.ServerMap;

final class LoadedAreas {
    public static final int MAX_AREAS = 64;
    public int[] areas = new int[256];
    public int count;
    public boolean changed;
    public int[] prevAreas = new int[256];
    public int prevCount;
    private boolean serverCells;

    public LoadedAreas(boolean bl) {
        this.serverCells = bl;
    }

    public boolean set() {
        this.setPrev();
        this.clear();
        if (GameServer.bServer) {
            if (this.serverCells) {
                for (int i = 0; i < ServerMap.instance.LoadedCells.size(); ++i) {
                    ServerMap.ServerCell serverCell = ServerMap.instance.LoadedCells.get(i);
                    this.add(serverCell.WX * 5, serverCell.WY * 5, 5, 5);
                }
            } else {
                int n;
                Object object;
                int n2;
                for (n2 = 0; n2 < GameServer.Players.size(); ++n2) {
                    object = GameServer.Players.get(n2);
                    n = (int)((IsoPlayer)object).x / 10;
                    int n3 = (int)((IsoPlayer)object).y / 10;
                    this.add(n - ((IsoPlayer)object).OnlineChunkGridWidth / 2, n3 - ((IsoPlayer)object).OnlineChunkGridWidth / 2, ((IsoPlayer)object).OnlineChunkGridWidth, ((IsoPlayer)object).OnlineChunkGridWidth);
                }
                for (n2 = 0; n2 < GameServer.udpEngine.connections.size(); ++n2) {
                    object = GameServer.udpEngine.connections.get(n2);
                    for (n = 0; n < 4; ++n) {
                        Vector3 vector3 = ((UdpConnection)object).connectArea[n];
                        if (vector3 == null) continue;
                        int n4 = (int)vector3.z;
                        this.add((int)vector3.x - n4 / 2, (int)vector3.y - n4 / 2, n4, n4);
                    }
                }
            }
        } else {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[i];
                if (isoChunkMap.ignore) continue;
                this.add(isoChunkMap.getWorldXMin(), isoChunkMap.getWorldYMin(), IsoChunkMap.ChunkGridWidth, IsoChunkMap.ChunkGridWidth);
            }
        }
        this.changed = this.compareWithPrev();
        return this.changed;
    }

    public void add(int n, int n2, int n3, int n4) {
        if (this.count >= 64) {
            return;
        }
        int n5 = this.count * 4;
        this.areas[n5++] = n;
        this.areas[n5++] = n2;
        this.areas[n5++] = n3;
        this.areas[n5++] = n4;
        ++this.count;
    }

    public void clear() {
        this.count = 0;
        this.changed = false;
    }

    public void copy(LoadedAreas loadedAreas) {
        this.count = loadedAreas.count;
        for (int i = 0; i < this.count; ++i) {
            int n;
            this.areas[n = i * 4] = loadedAreas.areas[n++];
            this.areas[n] = loadedAreas.areas[n++];
            this.areas[n] = loadedAreas.areas[n++];
            this.areas[n] = loadedAreas.areas[n++];
        }
    }

    private void setPrev() {
        this.prevCount = this.count;
        for (int i = 0; i < this.count; ++i) {
            int n;
            this.prevAreas[n = i * 4] = this.areas[n++];
            this.prevAreas[n] = this.areas[n++];
            this.prevAreas[n] = this.areas[n++];
            this.prevAreas[n] = this.areas[n++];
        }
    }

    private boolean compareWithPrev() {
        if (this.prevCount != this.count) {
            return true;
        }
        for (int i = 0; i < this.count; ++i) {
            int n = i * 4;
            if (this.prevAreas[n] != this.areas[n++]) {
                return true;
            }
            if (this.prevAreas[n] != this.areas[n++]) {
                return true;
            }
            if (this.prevAreas[n] != this.areas[n++]) {
                return true;
            }
            if (this.prevAreas[n] == this.areas[n++]) continue;
            return true;
        }
        return false;
    }

    public boolean isOnEdge(int n, int n2) {
        if (n % 10 != 0 && (n + 1) % 10 != 0 && n2 % 10 != 0 && (n2 + 1) % 10 != 0) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            boolean bl;
            int n3 = i * 4;
            int n4 = this.areas[n3++] * 10;
            int n5 = this.areas[n3++] * 10;
            int n6 = n4 + this.areas[n3++] * 10;
            int n7 = n5 + this.areas[n3++] * 10;
            boolean bl2 = n >= n4 && n < n6;
            boolean bl3 = bl = n2 >= n5 && n2 < n7;
            if (bl2 && (n2 == n5 || n2 == n7 - 1)) {
                return true;
            }
            if (!bl || n != n4 && n != n6 - 1) continue;
            return true;
        }
        return false;
    }
}

