/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.vehicle;

import java.nio.ByteBuffer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.physics.Bullet;
import zombie.core.physics.WorldSimulation;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.packets.INetworkPacket;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleInterpolationData;
import zombie.vehicles.VehicleManager;

public class Physics
extends VehicleInterpolationData
implements INetworkPacket {
    private static final float[] buffer = new float[27];
    protected short id;
    protected float force;
    private BaseVehicle vehicle;
    private boolean hasAuth;

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.id = byteBuffer.getShort();
        this.time = byteBuffer.getLong();
        this.force = byteBuffer.getFloat();
        this.x = byteBuffer.getFloat();
        this.y = byteBuffer.getFloat();
        this.z = byteBuffer.getFloat();
        this.qx = byteBuffer.getFloat();
        this.qy = byteBuffer.getFloat();
        this.qz = byteBuffer.getFloat();
        this.qw = byteBuffer.getFloat();
        this.vx = byteBuffer.getFloat();
        this.vy = byteBuffer.getFloat();
        this.vz = byteBuffer.getFloat();
        this.engineSpeed = byteBuffer.getFloat();
        this.throttle = byteBuffer.getFloat();
        this.setNumWheels(byteBuffer.getShort());
        for (int i = 0; i < this.wheelsCount; ++i) {
            this.wheelSteering[i] = byteBuffer.getFloat();
            this.wheelRotation[i] = byteBuffer.getFloat();
            this.wheelSkidInfo[i] = byteBuffer.getFloat();
            this.wheelSuspensionLength[i] = byteBuffer.getFloat();
        }
        this.vehicle = VehicleManager.instance.getVehicleByID(this.id);
        if (this.vehicle != null) {
            this.hasAuth = this.vehicle.hasAuthorization(udpConnection);
        }
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putShort(this.id);
        byteBufferWriter.putLong(this.time);
        byteBufferWriter.putFloat(this.force);
        byteBufferWriter.putFloat(this.x);
        byteBufferWriter.putFloat(this.y);
        byteBufferWriter.putFloat(this.z);
        byteBufferWriter.putFloat(this.qx);
        byteBufferWriter.putFloat(this.qy);
        byteBufferWriter.putFloat(this.qz);
        byteBufferWriter.putFloat(this.qw);
        byteBufferWriter.putFloat(this.vx);
        byteBufferWriter.putFloat(this.vy);
        byteBufferWriter.putFloat(this.vz);
        byteBufferWriter.putFloat(this.engineSpeed);
        byteBufferWriter.putFloat(this.throttle);
        byteBufferWriter.putShort(this.wheelsCount);
        for (int i = 0; i < this.wheelsCount; ++i) {
            byteBufferWriter.putFloat(this.wheelSteering[i]);
            byteBufferWriter.putFloat(this.wheelRotation[i]);
            byteBufferWriter.putFloat(this.wheelSkidInfo[i]);
            byteBufferWriter.putFloat(this.wheelSuspensionLength[i]);
        }
    }

    public boolean set(BaseVehicle baseVehicle) {
        if (Bullet.getOwnVehiclePhysics(baseVehicle.VehicleID, buffer) != 0) {
            return false;
        }
        this.id = baseVehicle.getId();
        this.time = WorldSimulation.instance.time;
        this.force = baseVehicle.getForce();
        int n = 0;
        this.x = buffer[n++];
        this.y = buffer[n++];
        this.z = buffer[n++];
        this.qx = buffer[n++];
        this.qy = buffer[n++];
        this.qz = buffer[n++];
        this.qw = buffer[n++];
        this.vx = buffer[n++];
        this.vy = buffer[n++];
        this.vz = buffer[n++];
        this.engineSpeed = (float)baseVehicle.getEngineSpeed();
        this.throttle = baseVehicle.throttle;
        this.wheelsCount = (short)buffer[n++];
        for (int i = 0; i < this.wheelsCount; ++i) {
            this.wheelSteering[i] = buffer[n++];
            this.wheelRotation[i] = buffer[n++];
            this.wheelSkidInfo[i] = buffer[n++];
            this.wheelSuspensionLength[i] = buffer[n++];
        }
        return true;
    }

    @Override
    public boolean isConsistent() {
        return INetworkPacket.super.isConsistent() && this.vehicle != null && (GameClient.bClient && !this.hasAuth || GameServer.bServer && this.hasAuth);
    }

    public void process() {
        if (this.isConsistent()) {
            if (GameClient.bClient) {
                this.vehicle.interpolation.interpolationDataAdd(this.vehicle, this);
            } else if (GameServer.bServer) {
                this.vehicle.setClientForce(this.force);
                this.vehicle.setX(this.x);
                this.vehicle.setY(this.y);
                this.vehicle.setZ(this.z);
                this.vehicle.savedRot.x = this.qx;
                this.vehicle.savedRot.y = this.qy;
                this.vehicle.savedRot.z = this.qz;
                this.vehicle.savedRot.w = this.qw;
                this.vehicle.jniTransform.origin.set(this.vehicle.x - WorldSimulation.instance.offsetX, this.vehicle.z, this.vehicle.y - WorldSimulation.instance.offsetY);
                this.vehicle.jniTransform.setRotation(this.vehicle.savedRot);
                this.vehicle.jniLinearVelocity.x = this.vx;
                this.vehicle.jniLinearVelocity.y = this.vy;
                this.vehicle.jniLinearVelocity.z = this.vz;
                this.vehicle.engineSpeed = this.engineSpeed;
                this.vehicle.throttle = this.throttle;
                this.setNumWheels(this.wheelsCount);
                for (int i = 0; i < this.wheelsCount; ++i) {
                    this.vehicle.wheelInfo[i].steering = this.wheelSteering[i];
                    this.vehicle.wheelInfo[i].rotation = this.wheelRotation[i];
                    this.vehicle.wheelInfo[i].skidInfo = this.wheelSkidInfo[i];
                    this.vehicle.wheelInfo[i].suspensionLength = this.wheelSuspensionLength[i];
                }
            }
        } else if (GameClient.bClient) {
            VehicleManager.instance.sendRequestGetFull(this.id, PacketTypes.PacketType.Vehicles);
        }
    }

    public boolean isRelevant(UdpConnection udpConnection) {
        return udpConnection.RelevantTo(this.x, this.y);
    }
}

