/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.Lua.LuaEventManager;
import zombie.ai.states.SwipeStatePlayer;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoLivingCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.inventory.types.HandWeapon;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.Hit;

public class WeaponHit
extends Hit
implements INetworkPacket {
    protected float range;
    protected boolean hitHead;

    public void set(boolean bl, float f, float f2, float f3, float f4, float f5, boolean bl2) {
        super.set(bl, f, f3, f4, f5);
        this.range = f2;
        this.hitHead = bl2;
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        super.parse(byteBuffer, udpConnection);
        this.range = byteBuffer.getFloat();
        this.hitHead = byteBuffer.get() != 0;
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        super.write(byteBufferWriter);
        byteBufferWriter.putFloat(this.range);
        byteBufferWriter.putBoolean(this.hitHead);
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "\n\tWeapon [ range=" + this.range + " | hitHead=" + this.hitHead + " ]";
    }

    void process(IsoGameCharacter isoGameCharacter, IsoGameCharacter isoGameCharacter2, HandWeapon handWeapon) {
        isoGameCharacter2.Hit(handWeapon, isoGameCharacter, this.damage, this.ignore, this.range, true);
        super.process(isoGameCharacter, isoGameCharacter2);
        LuaEventManager.triggerEvent("OnWeaponHitXp", isoGameCharacter, handWeapon, isoGameCharacter2, Float.valueOf(this.damage));
        if (isoGameCharacter.isAimAtFloor() && !handWeapon.isRanged() && isoGameCharacter.isNPC()) {
            SwipeStatePlayer.splash(isoGameCharacter2, handWeapon, isoGameCharacter);
        }
        if (this.hitHead) {
            SwipeStatePlayer.splash(isoGameCharacter2, handWeapon, isoGameCharacter);
            SwipeStatePlayer.splash(isoGameCharacter2, handWeapon, isoGameCharacter);
            isoGameCharacter2.addBlood(BloodBodyPartType.Head, true, true, true);
            isoGameCharacter2.addBlood(BloodBodyPartType.Torso_Upper, true, false, false);
            isoGameCharacter2.addBlood(BloodBodyPartType.UpperArm_L, true, false, false);
            isoGameCharacter2.addBlood(BloodBodyPartType.UpperArm_R, true, false, false);
        }
        if ((!((IsoLivingCharacter)isoGameCharacter).bDoShove || isoGameCharacter.isAimAtFloor()) && isoGameCharacter.DistToSquared(isoGameCharacter2) < 2.0f && Math.abs(isoGameCharacter.z - isoGameCharacter2.z) < 0.5f) {
            isoGameCharacter.addBlood(null, false, false, false);
        }
        if (!(isoGameCharacter2.isDead() || isoGameCharacter2 instanceof IsoPlayer || ((IsoLivingCharacter)isoGameCharacter).bDoShove && !isoGameCharacter.isAimAtFloor())) {
            SwipeStatePlayer.splash(isoGameCharacter2, handWeapon, isoGameCharacter);
        }
    }
}

