/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.PacketValidator;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.Fall;
import zombie.network.packets.hit.HitCharacterPacket;
import zombie.network.packets.hit.Player;
import zombie.network.packets.hit.VehicleHit;
import zombie.network.packets.hit.VehicleHitPacket;
import zombie.vehicles.BaseVehicle;

public class VehicleHitPlayerPacket
extends VehicleHitPacket
implements INetworkPacket {
    protected final Player target = new Player();
    protected final VehicleHit vehicleHit = new VehicleHit();
    protected final Fall fall = new Fall();

    public VehicleHitPlayerPacket() {
        super(HitCharacterPacket.HitType.VehicleHitPlayer);
    }

    public void set(IsoPlayer isoPlayer, IsoPlayer isoPlayer2, BaseVehicle baseVehicle, float f, boolean bl, int n, float f2, boolean bl2) {
        super.set(isoPlayer, baseVehicle, false);
        this.target.set(isoPlayer2, false);
        this.vehicleHit.set(false, f, isoPlayer2.getHitForce(), isoPlayer2.getHitDir().x, isoPlayer2.getHitDir().y, n, f2, bl2, bl);
        this.fall.set(isoPlayer2.getHitReactionNetworkAI());
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        super.parse(byteBuffer, udpConnection);
        this.target.parse(byteBuffer, udpConnection);
        this.target.parsePlayer(udpConnection);
        this.vehicleHit.parse(byteBuffer, udpConnection);
        this.fall.parse(byteBuffer, udpConnection);
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        super.write(byteBufferWriter);
        this.target.write(byteBufferWriter);
        this.vehicleHit.write(byteBufferWriter);
        this.fall.write(byteBufferWriter);
    }

    @Override
    public boolean isConsistent() {
        return super.isConsistent() && this.target.isConsistent() && this.vehicleHit.isConsistent();
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "\n\tTarget " + this.target.getDescription() + "\n\tVehicleHit " + this.vehicleHit.getDescription() + "\n\tFall " + this.fall.getDescription();
    }

    @Override
    protected void preProcess() {
        super.preProcess();
        this.target.process();
    }

    @Override
    protected void process() {
        this.vehicleHit.process(this.wielder.getCharacter(), this.target.getCharacter(), this.vehicle.getVehicle());
        this.fall.process(this.target.getCharacter());
    }

    @Override
    protected void postProcess() {
        super.postProcess();
        this.target.process();
    }

    @Override
    protected void react() {
        this.target.react();
    }

    @Override
    protected void postpone() {
        this.target.getCharacter().getNetworkCharacterAI().setVehicleHit(this);
    }

    @Override
    public boolean validate(UdpConnection udpConnection) {
        if (!PacketValidator.checkPVP(udpConnection, this.wielder, this.target, VehicleHitPlayerPacket.class.getSimpleName())) {
            return false;
        }
        if (!PacketValidator.checkSpeed(udpConnection, this.vehicleHit, VehicleHitPlayerPacket.class.getSimpleName())) {
            return false;
        }
        if (!PacketValidator.checkShortDistance(udpConnection, this.wielder, this.target, VehicleHitPlayerPacket.class.getSimpleName())) {
            return false;
        }
        return PacketValidator.checkDamage(udpConnection, this.vehicleHit, VehicleHitPlayerPacket.class.getSimpleName());
    }
}

