/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.inventory.types.HandWeapon;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.HitCharacterPacket;
import zombie.network.packets.hit.PlayerHitPacket;
import zombie.network.packets.hit.Square;

public class PlayerHitSquarePacket
extends PlayerHitPacket
implements INetworkPacket {
    protected final Square square = new Square();

    public PlayerHitSquarePacket() {
        super(HitCharacterPacket.HitType.PlayerHitSquare);
    }

    @Override
    public void set(IsoPlayer isoPlayer, HandWeapon handWeapon, boolean bl) {
        super.set(isoPlayer, handWeapon, bl);
        this.square.set(isoPlayer);
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        super.parse(byteBuffer, udpConnection);
        this.square.parse(byteBuffer, udpConnection);
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        super.write(byteBufferWriter);
        this.square.write(byteBufferWriter);
    }

    @Override
    public boolean isRelevant(UdpConnection udpConnection) {
        return this.wielder.isRelevant(udpConnection);
    }

    @Override
    public boolean isConsistent() {
        return super.isConsistent() && this.square.isConsistent();
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "\n\tSquare " + this.square.getDescription();
    }

    @Override
    protected void process() {
        this.square.process(this.wielder.getCharacter());
    }

    @Override
    public boolean validate(UdpConnection udpConnection) {
        return true;
    }
}

