/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.characters.IsoPlayer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.inventory.types.HandWeapon;
import zombie.network.PacketValidator;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.Fall;
import zombie.network.packets.hit.HitCharacterPacket;
import zombie.network.packets.hit.Player;
import zombie.network.packets.hit.PlayerHitPacket;
import zombie.network.packets.hit.WeaponHit;

public class PlayerHitPlayerPacket
extends PlayerHitPacket
implements INetworkPacket {
    protected final Player target = new Player();
    protected final WeaponHit hit = new WeaponHit();
    protected final Fall fall = new Fall();

    public PlayerHitPlayerPacket() {
        super(HitCharacterPacket.HitType.PlayerHitPlayer);
    }

    public void set(IsoPlayer isoPlayer, IsoPlayer isoPlayer2, HandWeapon handWeapon, float f, boolean bl, float f2, boolean bl2, boolean bl3) {
        super.set(isoPlayer, handWeapon, bl2);
        this.target.set(isoPlayer2, false);
        this.hit.set(bl, f, f2, isoPlayer2.getHitForce(), isoPlayer2.getHitDir().x, isoPlayer2.getHitDir().y, bl3);
        this.fall.set(isoPlayer2.getHitReactionNetworkAI());
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        super.parse(byteBuffer, udpConnection);
        this.target.parse(byteBuffer, udpConnection);
        this.target.parsePlayer(null);
        this.hit.parse(byteBuffer, udpConnection);
        this.fall.parse(byteBuffer, udpConnection);
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        super.write(byteBufferWriter);
        this.target.write(byteBufferWriter);
        this.hit.write(byteBufferWriter);
        this.fall.write(byteBufferWriter);
    }

    @Override
    public boolean isConsistent() {
        return super.isConsistent() && this.target.isConsistent() && this.hit.isConsistent();
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "\n\tTarget " + this.target.getDescription() + "\n\tHit " + this.hit.getDescription() + "\n\tFall " + this.fall.getDescription();
    }

    @Override
    protected void preProcess() {
        super.preProcess();
        this.target.process();
    }

    @Override
    protected void process() {
        this.hit.process(this.wielder.getCharacter(), this.target.getCharacter(), this.weapon.getWeapon());
        this.fall.process(this.target.getCharacter());
    }

    @Override
    protected void postProcess() {
        super.postProcess();
        this.target.process();
    }

    @Override
    public boolean validate(UdpConnection udpConnection) {
        if (!PacketValidator.checkPVP(udpConnection, this.wielder, this.target, PlayerHitPlayerPacket.class.getSimpleName())) {
            return false;
        }
        if (!PacketValidator.checkLongDistance(udpConnection, this.wielder, this.target, PlayerHitPlayerPacket.class.getSimpleName())) {
            return false;
        }
        return PacketValidator.checkDamage(udpConnection, this.hit, PlayerHitPlayerPacket.class.getSimpleName());
    }

    @Override
    protected void attack() {
        this.wielder.attack(this.weapon.getWeapon(), true);
    }

    @Override
    protected void react() {
        this.target.react();
    }
}

