/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.IsoGameCharacter;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.network.packets.INetworkPacket;

public class PlayerBodyPart
implements INetworkPacket {
    protected byte bodyPartIndex;
    protected BodyPart bodyPart;

    public void set(BodyPart bodyPart) {
        this.bodyPartIndex = bodyPart == null ? (byte)-1 : (byte)bodyPart.getIndex();
        this.bodyPart = bodyPart;
    }

    public void parse(ByteBuffer byteBuffer, IsoGameCharacter isoGameCharacter) {
        boolean bl;
        boolean bl2 = bl = byteBuffer.get() == 1;
        if (bl) {
            this.bodyPartIndex = byteBuffer.get();
            this.bodyPart = isoGameCharacter == null ? null : isoGameCharacter.getBodyDamage().getBodyPart(BodyPartType.FromIndex(this.bodyPartIndex));
        } else {
            this.bodyPart = null;
        }
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        DebugLog.Multiplayer.error("PlayerBodyPart.parse is not implemented");
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        if (this.bodyPart == null) {
            byteBufferWriter.putByte((byte)0);
        } else {
            byteBufferWriter.putByte((byte)1);
            byteBufferWriter.putByte((byte)this.bodyPart.getIndex());
        }
    }

    @Override
    public String getDescription() {
        return "\n\tPlayerBodyPart [ Item=" + (String)(this.bodyPart == null ? "?" : "\"" + this.bodyPart.getType().name() + "\"") + " ]";
    }

    public BodyPart getBodyPart() {
        return this.bodyPart;
    }
}

