/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameWindow;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.SurvivorDesc;
import zombie.characters.skills.PerkFactory;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.inventory.types.HandWeapon;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.AttackVars;
import zombie.network.packets.hit.Character;
import zombie.network.packets.hit.HitInfo;

public class Player
extends Character
implements INetworkPacket {
    protected IsoPlayer player;
    protected short playerIndex;
    protected short playerFlags;
    protected float charge;
    protected float perkAiming;
    protected float combatSpeed;
    protected String attackType;
    protected AttackVars attackVars = new AttackVars();
    ArrayList<HitInfo> hitList = new ArrayList();

    public void set(IsoPlayer isoPlayer, boolean bl) {
        super.set(isoPlayer);
        this.playerIndex = (short)(isoPlayer.isLocal() ? (int)isoPlayer.getPlayerNum() : -1);
        this.player = isoPlayer;
        this.playerFlags = 0;
        this.playerFlags = (short)(this.playerFlags | (short)(isoPlayer.isAimAtFloor() ? 1 : 0));
        this.playerFlags = (short)(this.playerFlags | (short)(isoPlayer.isDoShove() ? 2 : 0));
        this.playerFlags = (short)(this.playerFlags | (short)(isoPlayer.isAttackFromBehind() ? 4 : 0));
        this.playerFlags = (short)(this.playerFlags | (short)(bl ? 8 : 0));
        this.charge = isoPlayer.useChargeDelta;
        this.perkAiming = isoPlayer.getPerkLevel(PerkFactory.Perks.Aiming);
        this.combatSpeed = isoPlayer.getVariableFloat("CombatSpeed", 1.0f);
        this.attackType = isoPlayer.getAttackType();
        this.attackVars.copy(isoPlayer.attackVars);
        this.hitList.clear();
        this.hitList.addAll(isoPlayer.hitList);
    }

    public void parsePlayer(UdpConnection udpConnection) {
        if (GameServer.bServer) {
            this.player = udpConnection != null && this.playerIndex != -1 ? GameServer.getPlayerFromConnection(udpConnection, this.playerIndex) : GameServer.IDToPlayerMap.get(this.ID);
            this.character = this.player;
        } else if (GameClient.bClient) {
            IsoPlayer isoPlayer;
            this.player = GameClient.IDToPlayerMap.get(this.ID);
            if (this.player == null && (isoPlayer = IsoPlayer.getInstance()) != null) {
                this.player = new IsoPlayer(isoPlayer.getCell(), new SurvivorDesc(), (int)isoPlayer.x, (int)isoPlayer.y, (int)isoPlayer.z);
            }
            this.character = this.player;
        }
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        super.parse(byteBuffer, udpConnection);
        this.playerIndex = byteBuffer.getShort();
        this.playerFlags = byteBuffer.getShort();
        this.charge = byteBuffer.getFloat();
        this.perkAiming = byteBuffer.getFloat();
        this.combatSpeed = byteBuffer.getFloat();
        this.attackType = GameWindow.ReadString(byteBuffer);
        this.attackVars.parse(byteBuffer, udpConnection);
        int n = byteBuffer.get();
        for (int i = 0; i < n; ++i) {
            HitInfo hitInfo = new HitInfo();
            hitInfo.parse(byteBuffer, udpConnection);
            this.hitList.add(hitInfo);
        }
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        super.write(byteBufferWriter);
        byteBufferWriter.putShort(this.playerIndex);
        byteBufferWriter.putShort(this.playerFlags);
        byteBufferWriter.putFloat(this.charge);
        byteBufferWriter.putFloat(this.perkAiming);
        byteBufferWriter.putFloat(this.combatSpeed);
        byteBufferWriter.putUTF(this.attackType);
        this.attackVars.write(byteBufferWriter);
        int n = this.hitList.size();
        byteBufferWriter.putByte((byte)n);
        for (int i = 0; i < n; ++i) {
            this.hitList.get(i).write(byteBufferWriter);
        }
    }

    @Override
    public boolean isConsistent() {
        return super.isConsistent() && this.player != null;
    }

    @Override
    public String getDescription() {
        Object object = "";
        int n = Math.min(100, this.hitList.size());
        for (int i = 0; i < n; ++i) {
            HitInfo hitInfo = this.hitList.get(i);
            object = (String)object + hitInfo.getDescription();
        }
        return super.getDescription() + "\n\tPlayer [ player " + (String)(this.player == null ? "?" : "\"" + this.player.getUsername() + "\"") + " | charge=" + this.charge + " | perkAiming=" + this.perkAiming + " | combatSpeed=" + this.combatSpeed + " | attackType=\"" + this.attackType + "\" | isAimAtFloor=" + ((this.playerFlags & 1) != 0) + " | isDoShove=" + ((this.playerFlags & 2) != 0) + " | isAttackFromBehind=" + ((this.playerFlags & 4) != 0) + " | isCriticalHit=" + ((this.playerFlags & 8) != 0) + " | _bodyDamage=" + (Serializable)(this.player == null ? "?" : Float.valueOf(this.player.getBodyDamage().getHealth())) + this.attackVars.getDescription() + "\n\t hitList=[" + (String)object + "](count=" + this.hitList.size() + ") ]";
    }

    @Override
    void process() {
        super.process();
        this.player.useChargeDelta = this.charge;
        this.player.setVariable("recoilVarX", this.perkAiming / 10.0f);
        this.player.setAttackType(this.attackType);
        this.player.setVariable("CombatSpeed", this.combatSpeed);
        this.player.setVariable("AimFloorAnim", (this.playerFlags & 1) != 0);
        this.player.setAimAtFloor((this.playerFlags & 1) != 0);
        this.player.setDoShove((this.playerFlags & 2) != 0);
        this.player.setAttackFromBehind((this.playerFlags & 4) != 0);
        this.player.setCriticalHit((this.playerFlags & 8) != 0);
    }

    void attack(HandWeapon handWeapon, boolean bl) {
        if (GameClient.bClient) {
            this.player.attackStarted = false;
            this.player.attackVars.copy(this.attackVars);
            this.player.hitList.clear();
            this.player.hitList.addAll(this.hitList);
            this.player.pressedAttack(false);
            if (this.player.isAttackStarted() && handWeapon.isRanged() && !this.player.isDoShove()) {
                this.player.startMuzzleFlash();
            }
            if (handWeapon.getPhysicsObject() != null) {
                this.player.Throw(handWeapon);
            }
        } else if (GameServer.bServer && bl && !this.player.getSafety().isEnabled()) {
            this.player.getSafety().setCooldown(this.player.getSafety().getCooldown() + (float)ServerOptions.getInstance().SafetyCooldownTimer.getValue());
            GameServer.sendChangeSafety(this.player.getSafety());
        }
    }

    @Override
    public IsoGameCharacter getCharacter() {
        return this.player;
    }

    public IsoPlayer getPlayer() {
        return this.player;
    }

    boolean isRelevant(UdpConnection udpConnection) {
        return udpConnection.RelevantTo(this.positionX, this.positionY);
    }
}

