/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.network.packets.INetworkPacket;

public class NetObject
implements INetworkPacket {
    public final byte objectTypeNone = 0;
    public final byte objectTypeObject = 1;
    private boolean isProcessed = false;
    private byte objectType = 0;
    private short objectId;
    private int squareX;
    private int squareY;
    private byte squareZ;
    private IsoObject object;

    public void setObject(IsoObject isoObject) {
        this.object = isoObject;
        this.isProcessed = true;
        if (this.object == null) {
            this.objectType = 0;
            this.objectId = 0;
            return;
        }
        IsoGridSquare isoGridSquare = this.object.square;
        this.objectType = 1;
        this.objectId = (short)isoGridSquare.getObjects().indexOf(this.object);
        this.squareX = isoGridSquare.getX();
        this.squareY = isoGridSquare.getY();
        this.squareZ = (byte)isoGridSquare.getZ();
    }

    public IsoObject getObject() {
        if (!this.isProcessed) {
            if (this.objectType == 0) {
                this.object = null;
            }
            if (this.objectType == 1) {
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(this.squareX, this.squareY, this.squareZ);
                this.object = isoGridSquare == null ? null : isoGridSquare.getObjects().get(this.objectId);
            }
            this.isProcessed = true;
        }
        return this.object;
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.objectType = byteBuffer.get();
        if (this.objectType == 1) {
            this.objectId = byteBuffer.getShort();
            this.squareX = byteBuffer.getInt();
            this.squareY = byteBuffer.getInt();
            this.squareZ = byteBuffer.get();
        }
        this.isProcessed = false;
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putByte(this.objectType);
        if (this.objectType == 1) {
            byteBufferWriter.putShort(this.objectId);
            byteBufferWriter.putInt(this.squareX);
            byteBufferWriter.putInt(this.squareY);
            byteBufferWriter.putByte(this.squareZ);
        }
    }

    @Override
    public int getPacketSizeBytes() {
        if (this.objectType == 1) {
            return 12;
        }
        return 1;
    }

    @Override
    public String getDescription() {
        String string = "";
        switch (this.objectType) {
            case 0: {
                string = "None";
                break;
            }
            case 1: {
                string = "NetObject";
            }
        }
        return "\n\tNetObject [type=" + string + "(" + this.objectType + ") | id=" + this.objectId + " | pos=(" + this.squareX + ", " + this.squareY + ", " + this.squareZ + ") ]";
    }
}

