/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoWorld;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.network.packets.INetworkPacket;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleManager;

public class MovingObject
implements INetworkPacket {
    public final byte objectTypeNone = 0;
    public final byte objectTypePlayer = 1;
    public final byte objectTypeZombie = (byte)2;
    public final byte objectTypeVehicle = (byte)3;
    public final byte objectTypeObject = (byte)4;
    private boolean isProcessed = false;
    private byte objectType = 0;
    private short objectId;
    private int squareX;
    private int squareY;
    private byte squareZ;
    private IsoMovingObject object;

    public void setMovingObject(IsoMovingObject isoMovingObject) {
        this.object = isoMovingObject;
        this.isProcessed = true;
        if (this.object == null) {
            this.objectType = 0;
            this.objectId = 0;
            return;
        }
        if (this.object instanceof IsoPlayer) {
            this.objectType = 1;
            this.objectId = ((IsoPlayer)this.object).getOnlineID();
            return;
        }
        if (this.object instanceof IsoZombie) {
            this.objectType = (byte)2;
            this.objectId = ((IsoZombie)this.object).getOnlineID();
            return;
        }
        if (this.object instanceof BaseVehicle) {
            this.objectType = (byte)3;
            this.objectId = ((BaseVehicle)this.object).VehicleID;
            return;
        }
        IsoGridSquare isoGridSquare = this.object.getCurrentSquare();
        this.objectType = (byte)4;
        this.objectId = (short)isoGridSquare.getMovingObjects().indexOf(this.object);
        this.squareX = isoGridSquare.getX();
        this.squareY = isoGridSquare.getY();
        this.squareZ = (byte)isoGridSquare.getZ();
    }

    public IsoMovingObject getMovingObject() {
        if (!this.isProcessed) {
            if (this.objectType == 0) {
                this.object = null;
            }
            if (this.objectType == 1) {
                if (GameServer.bServer) {
                    this.object = GameServer.IDToPlayerMap.get(this.objectId);
                } else if (GameClient.bClient) {
                    this.object = GameClient.IDToPlayerMap.get(this.objectId);
                }
            }
            if (this.objectType == 2) {
                if (GameServer.bServer) {
                    this.object = ServerMap.instance.ZombieMap.get(this.objectId);
                } else if (GameClient.bClient) {
                    this.object = (IsoMovingObject)GameClient.IDToZombieMap.get(this.objectId);
                }
            }
            if (this.objectType == 3) {
                this.object = VehicleManager.instance.getVehicleByID(this.objectId);
            }
            if (this.objectType == 4) {
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(this.squareX, this.squareY, this.squareZ);
                this.object = isoGridSquare == null ? null : isoGridSquare.getMovingObjects().get(this.objectId);
            }
            this.isProcessed = true;
        }
        return this.object;
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.objectType = byteBuffer.get();
        this.objectId = byteBuffer.getShort();
        if (this.objectType == 4) {
            this.squareX = byteBuffer.getInt();
            this.squareY = byteBuffer.getInt();
            this.squareZ = byteBuffer.get();
        }
        this.isProcessed = false;
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putByte(this.objectType);
        byteBufferWriter.putShort(this.objectId);
        if (this.objectType == 4) {
            byteBufferWriter.putInt(this.squareX);
            byteBufferWriter.putInt(this.squareY);
            byteBufferWriter.putByte(this.squareZ);
        }
    }

    @Override
    public int getPacketSizeBytes() {
        if (this.objectType == 4) {
            return 12;
        }
        return 3;
    }

    @Override
    public String getDescription() {
        String string = "";
        switch (this.objectType) {
            case 0: {
                string = "None";
                break;
            }
            case 1: {
                string = "Player";
                break;
            }
            case 2: {
                string = "Zombie";
                break;
            }
            case 3: {
                string = "Vehicle";
                break;
            }
            case 4: {
                string = "NetObject";
            }
        }
        if (this.objectType == 4) {
            return "\n\tMovingObject [type=" + string + "(" + this.objectType + ") | id=" + this.objectId + " | position=(" + this.squareX + ", " + this.squareY + ", " + this.squareZ + ") ]";
        }
        return "\n\tMovingObject [type=" + string + "(" + this.objectType + ") | id=" + this.objectId + "]";
    }
}

