/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.PlayerHitPlayerPacket;
import zombie.network.packets.hit.PlayerHitSquarePacket;
import zombie.network.packets.hit.PlayerHitVehiclePacket;
import zombie.network.packets.hit.PlayerHitZombiePacket;
import zombie.network.packets.hit.VehicleHitPlayerPacket;
import zombie.network.packets.hit.VehicleHitZombiePacket;
import zombie.network.packets.hit.ZombieHitPlayerPacket;

public abstract class HitCharacterPacket
implements INetworkPacket {
    private final HitType hitType;

    public HitCharacterPacket(HitType hitType) {
        this.hitType = hitType;
    }

    public static HitCharacterPacket process(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by > HitType.Min.ordinal() && by < HitType.Max.ordinal()) {
            return switch (HitType.values()[by]) {
                case HitType.PlayerHitSquare -> new PlayerHitSquarePacket();
                case HitType.PlayerHitVehicle -> new PlayerHitVehiclePacket();
                case HitType.PlayerHitZombie -> new PlayerHitZombiePacket();
                case HitType.PlayerHitPlayer -> new PlayerHitPlayerPacket();
                case HitType.ZombieHitPlayer -> new ZombieHitPlayerPacket();
                case HitType.VehicleHitZombie -> new VehicleHitZombiePacket();
                case HitType.VehicleHitPlayer -> new VehicleHitPlayerPacket();
                default -> null;
            };
        }
        return null;
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putByte((byte)this.hitType.ordinal());
    }

    @Override
    public String getDescription() {
        return INetworkPacket.super.getDescription() + " (" + this.hitType.name() + ")";
    }

    public void tryProcess() {
        if (GameClient.bClient && (HitType.VehicleHitZombie.equals((Object)this.hitType) || HitType.VehicleHitPlayer.equals((Object)this.hitType))) {
            this.postpone();
        } else {
            this.tryProcessInternal();
        }
    }

    public void tryProcessInternal() {
        if (this.isConsistent()) {
            this.preProcess();
            this.process();
            this.postProcess();
            this.attack();
            this.react();
        } else {
            DebugLog.Multiplayer.warn("HitCharacter: check error");
        }
    }

    public abstract boolean isRelevant(UdpConnection var1);

    protected abstract void attack();

    protected abstract void react();

    protected void preProcess() {
    }

    protected void process() {
    }

    protected void postProcess() {
    }

    protected void postpone() {
    }

    public abstract boolean validate(UdpConnection var1);

    public static enum HitType {
        Min,
        PlayerHitSquare,
        PlayerHitVehicle,
        PlayerHitZombie,
        PlayerHitPlayer,
        ZombieHitPlayer,
        VehicleHitZombie,
        VehicleHitPlayer,
        Max;

    }
}

