/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.network.GameServer;
import zombie.network.packets.INetworkPacket;

public abstract class Hit
implements INetworkPacket {
    private static final float MAX_DAMAGE = 100.0f;
    protected boolean ignore;
    protected float damage;
    protected float hitForce;
    protected float hitDirectionX;
    protected float hitDirectionY;

    public void set(boolean bl, float f, float f2, float f3, float f4) {
        this.ignore = bl;
        this.damage = Math.min(f, 100.0f);
        this.hitForce = f2;
        this.hitDirectionX = f3;
        this.hitDirectionY = f4;
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.ignore = byteBuffer.get() != 0;
        this.damage = byteBuffer.getFloat();
        this.hitForce = byteBuffer.getFloat();
        this.hitDirectionX = byteBuffer.getFloat();
        this.hitDirectionY = byteBuffer.getFloat();
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putBoolean(this.ignore);
        byteBufferWriter.putFloat(this.damage);
        byteBufferWriter.putFloat(this.hitForce);
        byteBufferWriter.putFloat(this.hitDirectionX);
        byteBufferWriter.putFloat(this.hitDirectionY);
    }

    @Override
    public String getDescription() {
        return "\n\tHit [ ignore=" + this.ignore + " | damage=" + this.damage + " | force=" + this.hitForce + " | dir=( " + this.hitDirectionX + " ; " + this.hitDirectionY + " ) ]";
    }

    void process(IsoGameCharacter isoGameCharacter, IsoGameCharacter isoGameCharacter2) {
        isoGameCharacter2.getHitDir().set(this.hitDirectionX, this.hitDirectionY);
        isoGameCharacter2.setHitForce(this.hitForce);
        if (GameServer.bServer && isoGameCharacter2 instanceof IsoZombie && isoGameCharacter instanceof IsoPlayer) {
            ((IsoZombie)isoGameCharacter2).addAggro(isoGameCharacter, this.damage);
            DebugLog.Damage.noise("AddAggro zombie=%d player=%d ( \"%s\" ) damage=%f", isoGameCharacter2.getOnlineID(), isoGameCharacter.getOnlineID(), ((IsoPlayer)isoGameCharacter).getUsername(), Float.valueOf(this.damage));
        }
        isoGameCharacter2.setAttackedBy(isoGameCharacter);
    }

    public float getDamage() {
        return this.damage;
    }
}

