/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import zombie.GameWindow;
import zombie.characters.IsoGameCharacter;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.network.GameServer;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.IPositional;
import zombie.network.packets.hit.Instance;

public abstract class Character
extends Instance
implements IPositional,
INetworkPacket {
    protected IsoGameCharacter character;
    protected short characterFlags;
    protected float positionX;
    protected float positionY;
    protected float positionZ;
    protected float directionX;
    protected float directionY;
    protected String characterReaction;
    protected String playerReaction;
    protected String zombieReaction;

    public void set(IsoGameCharacter isoGameCharacter) {
        super.set(isoGameCharacter.getOnlineID());
        this.characterFlags = 0;
        this.characterFlags = (short)(this.characterFlags | (short)(isoGameCharacter.isDead() ? 1 : 0));
        this.characterFlags = (short)(this.characterFlags | (short)(isoGameCharacter.isCloseKilled() ? 2 : 0));
        this.characterFlags = (short)(this.characterFlags | (short)(isoGameCharacter.isHitFromBehind() ? 4 : 0));
        this.characterFlags = (short)(this.characterFlags | (short)(isoGameCharacter.isFallOnFront() ? 8 : 0));
        this.characterFlags = (short)(this.characterFlags | (short)(isoGameCharacter.isKnockedDown() ? 16 : 0));
        this.characterFlags = (short)(this.characterFlags | (short)(isoGameCharacter.isOnFloor() ? 32 : 0));
        this.character = isoGameCharacter;
        this.positionX = isoGameCharacter.getX();
        this.positionY = isoGameCharacter.getY();
        this.positionZ = isoGameCharacter.getZ();
        this.directionX = isoGameCharacter.getForwardDirection().getX();
        this.directionY = isoGameCharacter.getForwardDirection().getY();
        this.characterReaction = Optional.ofNullable(isoGameCharacter.getHitReaction()).orElse("");
        this.playerReaction = Optional.ofNullable(isoGameCharacter.getVariableString("PlayerHitReaction")).orElse("");
        this.zombieReaction = Optional.ofNullable(isoGameCharacter.getVariableString("ZombieHitReaction")).orElse("");
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        super.parse(byteBuffer, udpConnection);
        this.characterFlags = byteBuffer.getShort();
        this.positionX = byteBuffer.getFloat();
        this.positionY = byteBuffer.getFloat();
        this.positionZ = byteBuffer.getFloat();
        this.directionX = byteBuffer.getFloat();
        this.directionY = byteBuffer.getFloat();
        this.characterReaction = GameWindow.ReadString(byteBuffer);
        this.playerReaction = GameWindow.ReadString(byteBuffer);
        this.zombieReaction = GameWindow.ReadString(byteBuffer);
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        super.write(byteBufferWriter);
        byteBufferWriter.putShort(this.characterFlags);
        byteBufferWriter.putFloat(this.positionX);
        byteBufferWriter.putFloat(this.positionY);
        byteBufferWriter.putFloat(this.positionZ);
        byteBufferWriter.putFloat(this.directionX);
        byteBufferWriter.putFloat(this.directionY);
        byteBufferWriter.putUTF(this.characterReaction);
        byteBufferWriter.putUTF(this.playerReaction);
        byteBufferWriter.putUTF(this.zombieReaction);
    }

    @Override
    public boolean isConsistent() {
        return super.isConsistent() && this.character != null;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "\n\tCharacter [ hit-reactions=( \"c=\"" + this.characterReaction + "\" ; p=\"" + this.playerReaction + "\" ; z=\"" + this.zombieReaction + "\" ) | " + this.getFlagsDescription() + " | pos=( " + this.positionX + " ; " + this.positionY + " ; " + this.positionZ + " ) | dir=( " + this.directionX + " ; " + this.directionY + " ) | health=" + (Serializable)(this.character == null ? "?" : Float.valueOf(this.character.getHealth())) + " | current=" + (String)(this.character == null ? "?" : "\"" + this.character.getCurrentActionContextStateName() + "\"") + " | previous=" + (String)(this.character == null ? "?" : "\"" + this.character.getPreviousActionContextStateName() + "\"") + " ]";
    }

    String getFlagsDescription() {
        return " Flags [ isDead=" + ((this.characterFlags & 1) != 0) + " | isKnockedDown=" + ((this.characterFlags & 0x10) != 0) + " | isCloseKilled=" + ((this.characterFlags & 2) != 0) + " | isHitFromBehind=" + ((this.characterFlags & 4) != 0) + " | isFallOnFront=" + ((this.characterFlags & 8) != 0) + " | isOnFloor=" + ((this.characterFlags & 0x20) != 0) + " ]";
    }

    void process() {
        this.character.setHitReaction(this.characterReaction);
        this.character.setVariable("PlayerHitReaction", this.playerReaction);
        this.character.setVariable("ZombieHitReaction", this.zombieReaction);
        this.character.setCloseKilled((this.characterFlags & 2) != 0);
        this.character.setHitFromBehind((this.characterFlags & 4) != 0);
        this.character.setFallOnFront((this.characterFlags & 8) != 0);
        this.character.setKnockedDown((this.characterFlags & 0x10) != 0);
        this.character.setOnFloor((this.characterFlags & 0x20) != 0);
        if (GameServer.bServer && (this.characterFlags & 0x20) == 0 && (this.characterFlags & 4) != 0) {
            this.character.setFallOnFront(true);
        }
    }

    protected void react() {
    }

    @Override
    public float getX() {
        return this.positionX;
    }

    @Override
    public float getY() {
        return this.positionY;
    }

    public abstract IsoGameCharacter getCharacter();
}

