/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets.hit;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.characters.IsoLivingCharacter;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.inventory.types.HandWeapon;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.HitInfo;
import zombie.network.packets.hit.MovingObject;

public class AttackVars
implements INetworkPacket {
    private boolean isBareHeadsWeapon;
    public MovingObject targetOnGround = new MovingObject();
    public boolean bAimAtFloor;
    public boolean bCloseKill;
    public boolean bDoShove;
    public float useChargeDelta;
    public int recoilDelay;
    public final ArrayList<HitInfo> targetsStanding = new ArrayList();
    public final ArrayList<HitInfo> targetsProne = new ArrayList();

    public void setWeapon(HandWeapon handWeapon) {
        this.isBareHeadsWeapon = "BareHands".equals(handWeapon.getType());
    }

    public HandWeapon getWeapon(IsoLivingCharacter isoLivingCharacter) {
        if (this.isBareHeadsWeapon || isoLivingCharacter.getUseHandWeapon() == null) {
            return isoLivingCharacter.bareHands;
        }
        return isoLivingCharacter.getUseHandWeapon();
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        HitInfo hitInfo;
        int n;
        byte by = byteBuffer.get();
        this.isBareHeadsWeapon = (by & 1) != 0;
        this.bAimAtFloor = (by & 2) != 0;
        this.bCloseKill = (by & 4) != 0;
        this.bDoShove = (by & 8) != 0;
        this.targetOnGround.parse(byteBuffer, udpConnection);
        this.useChargeDelta = byteBuffer.getFloat();
        this.recoilDelay = byteBuffer.getInt();
        int n2 = byteBuffer.get();
        this.targetsStanding.clear();
        for (n = 0; n < n2; ++n) {
            hitInfo = new HitInfo();
            hitInfo.parse(byteBuffer, udpConnection);
            this.targetsStanding.add(hitInfo);
        }
        n2 = byteBuffer.get();
        this.targetsProne.clear();
        for (n = 0; n < n2; ++n) {
            hitInfo = new HitInfo();
            hitInfo.parse(byteBuffer, udpConnection);
            this.targetsProne.add(hitInfo);
        }
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        HitInfo hitInfo;
        int n;
        byte by = 0;
        by = (byte)(by | (byte)(this.isBareHeadsWeapon ? 1 : 0));
        by = (byte)(by | (byte)(this.bAimAtFloor ? 2 : 0));
        by = (byte)(by | (byte)(this.bCloseKill ? 4 : 0));
        by = (byte)(by | (byte)(this.bDoShove ? 8 : 0));
        byteBufferWriter.putByte(by);
        this.targetOnGround.write(byteBufferWriter);
        byteBufferWriter.putFloat(this.useChargeDelta);
        byteBufferWriter.putInt(this.recoilDelay);
        int n2 = Math.min(100, this.targetsStanding.size());
        byteBufferWriter.putByte((byte)n2);
        for (n = 0; n < n2; ++n) {
            hitInfo = this.targetsStanding.get(n);
            hitInfo.write(byteBufferWriter);
        }
        n2 = (byte)Math.min(100, this.targetsProne.size());
        byteBufferWriter.putByte((byte)n2);
        for (n = 0; n < n2; ++n) {
            hitInfo = this.targetsProne.get(n);
            hitInfo.write(byteBufferWriter);
        }
    }

    @Override
    public int getPacketSizeBytes() {
        HitInfo hitInfo;
        int n;
        int n2 = 11 + this.targetOnGround.getPacketSizeBytes();
        int n3 = Math.min(100, this.targetsStanding.size());
        for (n = 0; n < n3; ++n) {
            hitInfo = this.targetsStanding.get(n);
            n2 += hitInfo.getPacketSizeBytes();
        }
        n3 = (byte)Math.min(100, this.targetsProne.size());
        for (n = 0; n < n3; ++n) {
            hitInfo = this.targetsProne.get(n);
            n2 += hitInfo.getPacketSizeBytes();
        }
        return n2;
    }

    @Override
    public String getDescription() {
        Object object = "";
        int n = Math.min(100, this.targetsStanding.size());
        for (int i = 0; i < n; ++i) {
            HitInfo hitInfo = this.targetsStanding.get(i);
            object = (String)object + hitInfo.getDescription();
        }
        Object object2 = "";
        n = (byte)Math.min(100, this.targetsProne.size());
        for (int i = 0; i < n; ++i) {
            HitInfo hitInfo = this.targetsProne.get(i);
            object2 = (String)object2 + hitInfo.getDescription();
        }
        return "\n\tHitInfo [ isBareHeadsWeapon=" + this.isBareHeadsWeapon + " bAimAtFloor=" + this.bAimAtFloor + " bCloseKill=" + this.bCloseKill + " bDoShove=" + this.bDoShove + " useChargeDelta=" + this.useChargeDelta + " recoilDelay=" + this.recoilDelay + "\n\t  targetOnGround:" + this.targetOnGround.getDescription() + "\n\t  targetsStanding=[" + (String)object + "](size=" + this.targetsStanding.size() + ")\n\t  targetsProne=[" + (String)object2 + "](size=" + this.targetsProne.size() + ")]";
    }

    public void copy(AttackVars attackVars) {
        this.isBareHeadsWeapon = attackVars.isBareHeadsWeapon;
        this.targetOnGround = attackVars.targetOnGround;
        this.bAimAtFloor = attackVars.bAimAtFloor;
        this.bCloseKill = attackVars.bCloseKill;
        this.bDoShove = attackVars.bDoShove;
        this.useChargeDelta = attackVars.useChargeDelta;
        this.recoilDelay = attackVars.recoilDelay;
        this.targetsStanding.clear();
        for (HitInfo hitInfo : attackVars.targetsStanding) {
            this.targetsStanding.add(hitInfo);
        }
        this.targetsProne.clear();
        for (HitInfo hitInfo : attackVars.targetsProne) {
            this.targetsProne.add(hitInfo);
        }
    }

    public void clear() {
        this.targetOnGround.setMovingObject(null);
        this.targetsStanding.clear();
        this.targetsProne.clear();
    }
}

