/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameWindow;
import zombie.characters.IsoPlayer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.inventory.InventoryItem;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerGUI;
import zombie.network.packets.INetworkPacket;

public class SyncClothingPacket
implements INetworkPacket {
    private IsoPlayer player = null;
    private String location = "";
    private InventoryItem item = null;

    public void set(IsoPlayer isoPlayer, String string, InventoryItem inventoryItem) {
        this.player = isoPlayer;
        this.location = string;
        this.item = inventoryItem;
    }

    public boolean isEquals(IsoPlayer isoPlayer, String string, InventoryItem inventoryItem) {
        return this.player.OnlineID == isoPlayer.OnlineID && this.location.equals(string) && this.item == inventoryItem;
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        short s = byteBuffer.getShort();
        this.location = GameWindow.ReadString(byteBuffer);
        byte by = byteBuffer.get();
        if (by == 1) {
            try {
                this.item = InventoryItem.loadItem(byteBuffer, 195);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.item == null) {
                return;
            }
        }
        this.player = GameServer.bServer ? GameServer.IDToPlayerMap.get(s) : GameClient.IDToPlayerMap.get(s);
        if (this.player == null) {
            return;
        }
        try {
            this.player.getHumanVisual().load(byteBuffer, 195);
            this.player.getItemVisuals().load(byteBuffer, 195);
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
            return;
        }
        if (by == 1) {
            this.player.getWornItems().setItem(this.location, this.item);
        }
        if (GameServer.bServer && ServerGUI.isCreated() || GameClient.bClient) {
            this.player.resetModelNextFrame();
        }
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putShort(this.player.OnlineID);
        byteBufferWriter.putUTF(this.location);
        if (this.item == null) {
            byteBufferWriter.putByte((byte)0);
        } else {
            byteBufferWriter.putByte((byte)1);
            try {
                this.item.saveWithSize(byteBufferWriter.bb, false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            this.player.getHumanVisual().save(byteBufferWriter.bb);
            ItemVisuals itemVisuals = new ItemVisuals();
            this.player.getItemVisuals(itemVisuals);
            itemVisuals.save(byteBufferWriter.bb);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public boolean isConsistent() {
        return this.player != null;
    }

    @Override
    public String getDescription() {
        Object object = this.player == null ? "player=null" : String.format("player=%s(oid:%d)", this.player.username, this.player.OnlineID);
        object = (String)object + ", location=" + this.location;
        object = this.item == null ? (String)object + ", item=null" : (String)object + ", item=" + this.item.getFullType();
        return object;
    }
}

