/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.nio.ByteBuffer;
import zombie.GameWindow;
import zombie.characters.IsoGameCharacter;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoMovingObject;
import zombie.network.packets.INetworkPacket;
import zombie.network.packets.hit.MovingObject;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public class StopSoundPacket
implements INetworkPacket {
    MovingObject object = new MovingObject();
    String name;
    boolean trigger;

    public void set(IsoMovingObject isoMovingObject, String string, boolean bl) {
        this.object.setMovingObject(isoMovingObject);
        this.name = string;
        this.trigger = bl;
    }

    public void process() {
        IsoMovingObject isoMovingObject = this.object.getMovingObject();
        IsoGameCharacter isoGameCharacter = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class);
        if (isoGameCharacter != null) {
            if (this.trigger) {
                isoGameCharacter.getEmitter().stopOrTriggerSoundByName(this.name);
            } else {
                isoGameCharacter.getEmitter().stopSoundByName(this.name);
            }
            return;
        }
        BaseVehicle baseVehicle = Type.tryCastTo(isoMovingObject, BaseVehicle.class);
        if (baseVehicle != null) {
            if (this.trigger) {
                baseVehicle.getEmitter().stopOrTriggerSoundByName(this.name);
            } else {
                baseVehicle.getEmitter().stopSoundByName(this.name);
            }
            return;
        }
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        this.trigger = byteBuffer.get() == 1;
        this.object.parse(byteBuffer, udpConnection);
        this.name = GameWindow.ReadString(byteBuffer);
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putByte((byte)(this.trigger ? 1 : 0));
        this.object.write(byteBufferWriter);
        byteBufferWriter.putUTF(this.name);
    }

    @Override
    public int getPacketSizeBytes() {
        return this.object.getPacketSizeBytes() + 2 + this.name.length();
    }

    @Override
    public String getDescription() {
        return "\n\tStopSoundPacket [name=" + this.name + " | object=" + this.object.getDescription() + "]";
    }
}

