/*
 * Decompiled with CFR 0.152.
 */
package zombie.network.packets;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.PersistentOutfits;
import zombie.SharedDescriptors;
import zombie.ZomboidFileSystem;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.debug.LogSeverity;
import zombie.iso.IsoWorld;
import zombie.network.ConnectionDetails;
import zombie.network.ConnectionManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.RequestDataManager;
import zombie.network.ServerWorldDatabase;
import zombie.network.packets.INetworkPacket;
import zombie.radio.ZomboidRadio;
import zombie.radio.media.RecordedMedia;

public class RequestDataPacket
implements INetworkPacket {
    RequestType type;
    RequestID id;
    ByteBuffer buffer = null;
    int dataSize;
    int dataSent;
    int partSize;
    public static ByteBuffer large_file_bb = ByteBuffer.allocate(0x3200000);

    public void setRequest() {
        this.type = RequestType.Request;
        this.id = RequestID.Descriptors;
    }

    public void setRequest(RequestID requestID) {
        this.type = RequestType.Request;
        this.id = requestID;
    }

    public void setPartData(RequestID requestID, ByteBuffer byteBuffer) {
        this.type = RequestType.PartData;
        this.buffer = byteBuffer;
        this.id = requestID;
        this.dataSize = byteBuffer.limit();
    }

    public void setPartDataParameters(int n, int n2) {
        this.dataSent = n;
        this.partSize = n2;
    }

    public void setACK(RequestID requestID) {
        this.type = RequestType.PartDataACK;
        this.id = requestID;
    }

    public void sendConnectingDetails(UdpConnection udpConnection, ServerWorldDatabase.LogonResult logonResult) {
        if (!GameServer.bServer) {
            return;
        }
        this.id = RequestID.ConnectionDetails;
        large_file_bb.clear();
        ConnectionDetails.write(udpConnection, logonResult, large_file_bb);
        this.doSendRequest(udpConnection);
        DebugLog.Multiplayer.debugln("%s %db", this.id.name(), large_file_bb.position());
        ConnectionManager.log("send-packet", "connection-details", udpConnection);
    }

    @Override
    public void parse(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        try {
            this.type = RequestType.values()[byteBuffer.get()];
        }
        catch (Exception exception) {
            DebugLog.Multiplayer.printException(exception, "RequestData packet parse failed", LogSeverity.Error);
            this.type = RequestType.None;
        }
        this.id = RequestID.values()[byteBuffer.get()];
        if (GameClient.bClient) {
            if (this.type == RequestType.FullData) {
                int n = byteBuffer.limit() - byteBuffer.position();
                large_file_bb.clear();
                large_file_bb.limit(n);
                large_file_bb.put(byteBuffer.array(), byteBuffer.position(), n);
                this.buffer = large_file_bb;
            } else if (this.type == RequestType.PartData) {
                this.dataSize = byteBuffer.getInt();
                this.dataSent = byteBuffer.getInt();
                this.partSize = byteBuffer.getInt();
                large_file_bb.clear();
                large_file_bb.limit(this.partSize);
                large_file_bb.put(byteBuffer.array(), byteBuffer.position(), this.partSize);
                this.buffer = large_file_bb;
            }
        }
    }

    @Override
    public void write(ByteBufferWriter byteBufferWriter) {
        byteBufferWriter.putByte((byte)this.type.ordinal());
        byteBufferWriter.putByte((byte)this.id.ordinal());
        if (GameServer.bServer) {
            if (this.type == RequestType.FullData) {
                byteBufferWriter.bb.put(this.buffer.array(), 0, this.buffer.position());
            } else if (this.type == RequestType.PartData) {
                byteBufferWriter.putInt(this.dataSize);
                byteBufferWriter.putInt(this.dataSent);
                byteBufferWriter.putInt(this.partSize);
                byteBufferWriter.bb.put(this.buffer.array(), this.dataSent, this.partSize);
            }
        }
    }

    public void processServer(PacketTypes.PacketType packetType, UdpConnection udpConnection) {
        if (!udpConnection.wasInLoadingQueue && this.id != RequestID.ConnectionDetails) {
            GameServer.kick(udpConnection, "UI_Policy_Kick", "The server received an invalid request");
        }
        if (this.type == RequestType.Request) {
            this.doProcessRequest(udpConnection);
        } else if (this.type == RequestType.PartDataACK) {
            RequestDataManager.getInstance().ACKWasReceived(this.id, udpConnection, this.dataSent);
        }
    }

    private void doSendRequest(UdpConnection udpConnection) {
        if (large_file_bb.position() < 1024) {
            this.type = RequestType.FullData;
            this.buffer = large_file_bb;
            ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.RequestData.doPacket(byteBufferWriter);
            this.write(byteBufferWriter);
            PacketTypes.PacketType.RequestData.send(udpConnection);
        } else {
            RequestDataManager.getInstance().putDataForTransmit(this.id, udpConnection, large_file_bb);
        }
    }

    private void doProcessRequest(UdpConnection udpConnection) {
        if (this.id == RequestID.Descriptors) {
            try {
                large_file_bb.clear();
                PersistentOutfits.instance.save(large_file_bb);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.doSendRequest(udpConnection);
        }
        if (this.id == RequestID.PlayerZombieDescriptors) {
            SharedDescriptors.Descriptor[] descriptorArray = SharedDescriptors.getPlayerZombieDescriptors();
            int n = 0;
            for (int i = 0; i < descriptorArray.length; ++i) {
                if (descriptorArray[i] == null) continue;
                ++n;
            }
            if (n * 2 * 1024 > large_file_bb.capacity()) {
                large_file_bb = ByteBuffer.allocate(n * 2 * 1024);
            }
            try {
                large_file_bb.clear();
                large_file_bb.putShort((short)n);
                for (SharedDescriptors.Descriptor descriptor : descriptorArray) {
                    if (descriptor == null) continue;
                    descriptor.save(large_file_bb);
                }
                this.doSendRequest(udpConnection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.id == RequestID.MetaGrid) {
            try {
                large_file_bb.clear();
                IsoWorld.instance.MetaGrid.savePart(large_file_bb, 0, true);
                IsoWorld.instance.MetaGrid.savePart(large_file_bb, 1, true);
                this.doSendRequest(udpConnection);
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, "map_meta.bin could not be saved", LogSeverity.Error);
                GameServer.kick(udpConnection, "You have been kicked from this server because map_meta.bin could not be saved.", null);
                udpConnection.forceDisconnect("save-map-meta-bin");
                GameServer.addDisconnect(udpConnection);
            }
        }
        if (this.id == RequestID.MapZone) {
            try {
                large_file_bb.clear();
                IsoWorld.instance.MetaGrid.saveZone(large_file_bb);
                this.doSendRequest(udpConnection);
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, "map_zone.bin could not be saved", LogSeverity.Error);
                GameServer.kick(udpConnection, "You have been kicked from this server because map_zone.bin could not be saved.", null);
                udpConnection.forceDisconnect("save-map-zone-bin");
                GameServer.addDisconnect(udpConnection);
            }
        }
        if (this.id == RequestID.RadioData) {
            large_file_bb.clear();
            ZomboidRadio.getInstance().getRecordedMedia().sendRequestData(large_file_bb);
            this.doSendRequest(udpConnection);
        }
        DebugLog.Multiplayer.debugln("%s %db", this.id.name(), large_file_bb.position());
    }

    public void process(UdpConnection udpConnection) {
        if (this.type == RequestType.FullData) {
            large_file_bb.position(0);
            this.doProcessData(large_file_bb);
        } else if (this.type == RequestType.PartData) {
            large_file_bb.position(0);
            this.doProcessPart(large_file_bb);
        }
    }

    private void doProcessPart(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = RequestDataManager.getInstance().receiveClientData(this.id, byteBuffer, this.dataSize, this.dataSent);
        if (byteBuffer2 != null) {
            this.doProcessData(byteBuffer2);
        }
    }

    private void doProcessData(ByteBuffer byteBuffer) {
        if (this.id == RequestID.ConnectionDetails) {
            ConnectionDetails.parse(byteBuffer);
        }
        if (this.id == RequestID.Descriptors) {
            try {
                DebugLog.Multiplayer.debugln("received zombie descriptors");
                PersistentOutfits.instance.load(byteBuffer);
            }
            catch (IOException iOException) {
                DebugLog.Multiplayer.printException(iOException, "PersistentOutfits loading IO error", LogSeverity.Error);
                ExceptionLogger.logException(iOException);
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, "PersistentOutfits loading error", LogSeverity.Error);
            }
        }
        if (this.id == RequestID.PlayerZombieDescriptors) {
            try {
                this.receivePlayerZombieDescriptors(byteBuffer);
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, "Player zombie descriptors loading error", LogSeverity.Error);
                ExceptionLogger.logException(exception);
            }
        }
        if (this.id == RequestID.MetaGrid) {
            this.saveToFile(byteBuffer, "map_meta.bin");
        }
        if (this.id == RequestID.MapZone) {
            this.saveToFile(byteBuffer, "map_zone.bin");
        }
        if (this.id == RequestID.RadioData) {
            try {
                RecordedMedia.receiveRequestData(byteBuffer);
            }
            catch (Exception exception) {
                DebugLog.Multiplayer.printException(exception, "Radio data loading error", LogSeverity.Error);
                ExceptionLogger.logException(exception);
            }
        }
        this.sendNextRequest(this.id);
    }

    private void sendNextRequest(RequestID requestID) {
        switch (requestID) {
            case Descriptors: {
                this.setRequest(RequestID.MetaGrid);
                break;
            }
            case MetaGrid: {
                this.setRequest(RequestID.MapZone);
                break;
            }
            case MapZone: {
                this.setRequest(RequestID.PlayerZombieDescriptors);
                break;
            }
            case PlayerZombieDescriptors: {
                this.setRequest(RequestID.RadioData);
                break;
            }
            case RadioData: {
                GameClient.instance.setRequest(GameClient.RequestState.Complete);
            }
        }
        if (requestID != RequestID.RadioData) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.RequestData.doPacket(byteBufferWriter);
            this.write(byteBufferWriter);
            PacketTypes.PacketType.RequestData.send(GameClient.connection);
        }
    }

    private void saveToFile(ByteBuffer byteBuffer, String string) {
        File file = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave(string));
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, false);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            bufferedOutputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            DebugLog.Multiplayer.printException(iOException, "Save to the " + string + " file error", LogSeverity.Error);
        }
    }

    private void receivePlayerZombieDescriptors(ByteBuffer byteBuffer) throws IOException {
        short s = byteBuffer.getShort();
        DebugLog.Multiplayer.debugln("received " + s + " player-zombie descriptors");
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            SharedDescriptors.Descriptor descriptor = new SharedDescriptors.Descriptor();
            descriptor.load(byteBuffer, 195);
            SharedDescriptors.registerPlayerZombieDescriptor(descriptor);
        }
    }

    @Override
    public boolean isConsistent() {
        return this.type != RequestType.None;
    }

    @Override
    public String getDescription() {
        int n;
        Object object = "\n\tRequestDataPacket [";
        object = (String)object + "type=" + this.type.name() + " | ";
        if (this.type == RequestType.Request || this.type == RequestType.PartDataACK) {
            object = (String)object + "id=" + this.id.name() + "] ";
        }
        if (this.type == RequestType.FullData) {
            object = (String)object + "id=" + this.id.name() + " | ";
            object = (String)object + "data=(size:" + this.buffer.limit() + ", data=";
            this.buffer.position(0);
            for (n = 0; n < Math.min(15, this.buffer.limit()); ++n) {
                object = (String)object + " 0x" + Integer.toHexString(this.buffer.get() & 0xFF);
            }
            object = (String)object + ".. ] ";
        }
        if (this.type == RequestType.PartData) {
            object = (String)object + "id=" + this.id.name() + " | ";
            object = (String)object + "dataSize=" + this.dataSize + " | ";
            object = (String)object + "dataSent=" + this.dataSent + " | ";
            object = (String)object + "partSize=" + this.partSize + " | ";
            object = (String)object + "data=(size:" + this.buffer.limit() + ", data=";
            if (this.buffer.limit() >= this.dataSize) {
                this.buffer.position(this.dataSent);
            } else {
                this.buffer.position(0);
            }
            for (n = 0; n < Math.min(15, this.buffer.limit() - this.buffer.position()); ++n) {
                object = (String)object + " " + Integer.toHexString(this.buffer.get() & 0xFF);
            }
            object = (String)object + ".. ] ";
        }
        return object;
    }

    static enum RequestType {
        None,
        Request,
        FullData,
        PartData,
        PartDataACK;

    }

    public static enum RequestID {
        ConnectionDetails,
        Descriptors,
        MetaGrid,
        MapZone,
        PlayerZombieDescriptors,
        RadioData;


        public String getDescriptor() {
            return Translator.getText("IGUI_RequestID_" + this.name());
        }
    }
}

